/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.datagen;

import com.denfop.datagen.IUChestLoot;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class IULootTableProvider
extends LootTableProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> industrialSubProviders = ImmutableList.of((Object)Pair.of(IUChestLoot::new, (Object)LootContextParamSets.f_81411_));
    private final DataGenerator.PathProvider pathProvider;
    public static final ResourceLocation VOLCANO_LOOT_TABLE = ResourceLocation.m_214293_((String)"industrialupgrade", (String)"chests/volcano");

    public IULootTableProvider(DataGenerator pGenerator) {
        super(pGenerator);
        this.pathProvider = pGenerator.m_236036_(DataGenerator.Target.DATA_PACK, "loot_tables");
    }

    public void m_213708_(CachedOutput pOutput) {
        HashMap map = Maps.newHashMap();
        this.industrialSubProviders.forEach(p_124458_ -> ((Consumer)((Supplier)p_124458_.getFirst()).get()).accept((p_176077_, p_176078_) -> {
            if (map.put(p_176077_, p_176078_.m_79165_((LootContextParamSet)p_124458_.getSecond()).m_79167_()) != null) {
                throw new IllegalStateException("Duplicate loot table " + p_176077_);
            }
        }));
        ValidationContext validationcontext = new ValidationContext(LootContextParamSets.f_81420_, p_124465_ -> null, map::get);
        Multimap multimap = validationcontext.m_79352_();
        if (!multimap.isEmpty()) {
            multimap.forEach((p_124446_, p_124447_) -> LOGGER.warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        map.forEach((p_236272_, p_236273_) -> {
            Path path = this.pathProvider.m_236048_(p_236272_);
            try {
                DataProvider.m_236072_((CachedOutput)pOutput, (JsonElement)LootTables.m_79200_((LootTable)p_236273_), (Path)path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

