/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.dataregistry;

import com.denfop.mixin.access.DeferredRegisterAccessor;
import com.denfop.register.Register;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;

public class DataSimpleBlock<E extends Block, F extends BlockItem> {
    private final RegistryObject<E> block;
    private RegistryObject<F> itemBlock;

    public DataSimpleBlock(Class<E> blockClass, Class<F> itemClass, String mainPath, String name) {
        try {
            Constructor<?> constructor = blockClass.getConstructors()[0];
            Supplier<Block> supplier = () -> {
                try {
                    return (Block)constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            ResourceLocation key = new ResourceLocation("industrialupgrade", mainPath + "/" + name.toLowerCase());
            RegistryObject ret = RegistryObject.create((ResourceLocation)key, (ResourceKey)Register.BLOCKS.getRegistryKey(), (String)"industrialupgrade");
            Map entries = ((DeferredRegisterAccessor)Register.BLOCKS).getEntries();
            if (entries.putIfAbsent(ret, supplier) != null) {
                throw new IllegalArgumentException("Duplicate registration " + key.toString());
            }
            this.block = ret;
            this.registerBlockItem(ret, itemClass, mainPath, name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void registerBlockItem(RegistryObject<E> block, Class<F> itemClass, String mainPath, String name) {
        boolean indexMax = false;
        try {
            Constructor<?> constructor = itemClass.getConstructors()[0];
            Supplier<BlockItem> supplier = () -> {
                try {
                    return (BlockItem)constructor.newInstance(block.get());
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            ResourceLocation key = new ResourceLocation("industrialupgrade", mainPath + "/" + name.toLowerCase());
            RegistryObject ret = RegistryObject.create((ResourceLocation)key, (ResourceKey)Register.ITEMS.getRegistryKey(), (String)"industrialupgrade");
            Map entries = ((DeferredRegisterAccessor)Register.ITEMS).getEntries();
            if (entries.putIfAbsent(ret, supplier) != null) {
                throw new IllegalArgumentException("Duplicate registration " + name);
            }
            this.itemBlock = ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RegistryObject<E> getBlock() {
        return this.block;
    }

    public BlockState getBlockState(int meta) {
        return ((Block)this.block.get()).m_49966_();
    }

    public BlockState getStateFromMeta(int meta) {
        return ((Block)this.block.get()).m_49966_();
    }

    public BlockState getDefaultState() {
        return ((Block)this.block.get()).m_49966_();
    }

    public F getItem() {
        return (F)((BlockItem)this.itemBlock.get());
    }

    public ItemStack getItemStack() {
        return new ItemStack((ItemLike)this.itemBlock.get());
    }
}

