/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUCore;
import com.denfop.config.ModConfig;
import com.denfop.utils.Localization;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class EventUpdate {
    private boolean playerNotified = false;
    private int delay = 120;

    @SubscribeEvent
    public void onPlayerTick(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!this.playerNotified) {
            this.playerNotified = true;
            this.sendModCheckMessage((Player)player2);
        }
    }

    private void sendModCheckMessage(Player player) {
        if (!player.m_9236_().f_46443_ && ((Boolean)ModConfig.COMMON.informationText.get()).booleanValue()) {
            String modVersion = "3.3.2.16";
            boolean hasPowerUtilities = ModList.get().isLoaded("powerutils");
            boolean hasSimplyQuarry = ModList.get().isLoaded("simplyquarries");
            boolean hasQuantumGenerators = ModList.get().isLoaded("quantumgenerators");
            boolean hasJEI = ModList.get().isLoaded("jei");
            boolean oneprobe = ModList.get().isLoaded("oneprobe");
            boolean jade = ModList.get().isLoaded("jade");
            String message = ChatFormatting.DARK_GRAY + "================\n" + ChatFormatting.GREEN + Localization.translate("iu.mod.name") + " " + modVersion + "\n" + ChatFormatting.WHITE + Localization.translate("iu.addons.installed") + "\n" + this.formatAddonStatus("Power Utilities", hasPowerUtilities) + "\n" + this.formatAddonStatus("Simply Quarry", hasSimplyQuarry) + "\n" + this.formatAddonStatus("Quantum Generators", hasQuantumGenerators) + "\n" + ChatFormatting.YELLOW + Localization.translate("iu.addons.optional") + "\n\n" + this.formatAddonStatus("Diamond Vein", ModList.get().isLoaded("diamondvein")) + "\n" + this.formatAddonStatus("Fast Primitive Age", ModList.get().isLoaded("fastprimitiveage")) + "\n" + this.formatAddonStatus("Fast Steam Age", ModList.get().isLoaded("faststeameage")) + "\n" + this.formatAddonStatus("Mining World Upgrade", ModList.get().isLoaded("miningworldupgrade")) + "\n" + this.formatAddonStatus("No Damage Bee", ModList.get().isLoaded("nodamagebee")) + "\n" + this.formatAddonStatus("No Heat Machine", ModList.get().isLoaded("noheatmachine")) + "\n" + this.formatAddonStatus("No Weed", ModList.get().isLoaded("noweed")) + "\n" + this.formatAddonStatus("Reactor Plus", ModList.get().isLoaded("reactorplus")) + "\n" + this.formatAddonStatus("Watering Can", ModList.get().isLoaded("wateringcan")) + "\n\n" + ChatFormatting.YELLOW + Localization.translate("iu.addons.required") + "\n" + this.formatAddonStatus("JEI", hasJEI) + "\n" + this.formatAddonStatus("One Probe", oneprobe) + "\n" + this.formatAddonStatus("Jade", jade) + "\n" + ChatFormatting.DARK_GRAY + "================";
            IUCore.proxy.messagePlayer(player, message);
            this.sendDiscordLink(player);
        }
    }

    private String formatAddonStatus(String addonName, boolean isInstalled) {
        return ChatFormatting.WHITE + " " + addonName + ": " + (isInstalled ? ChatFormatting.GREEN + "[\u2611]" : ChatFormatting.RED + "[\u274c]");
    }

    private void sendDiscordLink(Player player) {
        MutableComponent discordMessage = Component.m_237113_((String)("[" + Localization.translate("iu.discord.click") + "]")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/nFHcxqVx")));
        MutableComponent fullMessage = Component.m_237113_((String)(Localization.translate("iu.discord.question") + " ")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)).m_7220_((Component)discordMessage);
        player.m_213846_((Component)fullMessage);
    }
}

