/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.api.item.upgrade.UpgradeItem;
import com.denfop.api.item.upgrade.UpgradeItemInform;
import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.pollution.component.ChunkLevel;
import com.denfop.api.pollution.radiation.RadiationSystem;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.api.space.upgrades.SpaceUpgradeSystem;
import com.denfop.api.space.upgrades.info.SpaceUpgradeItemInform;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.lightning_rod.BlockEntityLightningRodController;
import com.denfop.blockentity.lightning_rod.IController;
import com.denfop.blockentity.mechanism.BlockEntityPalletGenerator;
import com.denfop.blockentity.transport.tiles.BlockEntityMultiCable;
import com.denfop.blocks.ISubEnum;
import com.denfop.containermenu.ContainerMenuBags;
import com.denfop.containermenu.ContainerMenuLeadBox;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.ItemBaseCircuit;
import com.denfop.items.ItemCraftingElements;
import com.denfop.items.armour.ItemAdvJetpack;
import com.denfop.items.armour.special.EnumCapability;
import com.denfop.items.armour.special.ItemSpecialArmor;
import com.denfop.items.bags.ItemEnergyBags;
import com.denfop.items.bags.ItemLeadBox;
import com.denfop.items.modules.EnumBaseType;
import com.denfop.items.modules.EnumModule;
import com.denfop.items.modules.ItemAdditionModule;
import com.denfop.items.modules.ItemBaseModules;
import com.denfop.items.modules.ItemCoolingUpgrade;
import com.denfop.items.modules.ItemEntityModule;
import com.denfop.items.reactors.IRadioactiveItemType;
import com.denfop.items.resource.ItemNuclearResource;
import com.denfop.mixin.invoker.LevelInvoker;
import com.denfop.network.WorldData;
import com.denfop.network.packet.PacketColorPickerAllLoggIn;
import com.denfop.network.packet.PacketRadiationUpdateValue;
import com.denfop.utils.CapturedMobUtils;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class IUEventHandler {
    public static TagKey<Item> electrumTag = new TagKey(Registry.f_122904_, ResourceLocation.m_135820_((String)"forge:ingots/electrum"));
    public static TagKey<Item> coalDustTag = new TagKey(Registry.f_122904_, ResourceLocation.m_135820_((String)"forge:dusts/coal"));
    public static List<ItemEntity> entityItemList = new LinkedList<ItemEntity>();
    final ChatFormatting[] name = new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.YELLOW, ChatFormatting.BLUE, ChatFormatting.RED, ChatFormatting.GRAY, ChatFormatting.GREEN, ChatFormatting.DARK_AQUA, ChatFormatting.AQUA};
    final String[] mattertype = new String[]{"matter.name", "sun_matter.name", "aqua_matter.name", "nether_matter.name", "night_matter.name", "earth_matter.name", "end_matter.name", "aer_matter.name"};
    Tuple<ItemStack, BaseMachineRecipe> tupleRecipe;
    Tuple<ItemStack, BaseMachineRecipe> tupleReplicatorRecipe;

    public static boolean getUpgradeItem(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof UpgradeItem;
    }

    @SubscribeEvent
    public void onWorldTick1(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Level level = event.level;
            if (!level.m_46470_() || level.f_46443_ || level.m_46467_() % 20L != 0L) {
                return;
            }
            if (WorldBaseGen.random.nextInt(100) < 2) {
                for (Map.Entry<BlockPos, IController> entry : BlockEntityLightningRodController.controllerMap.entrySet()) {
                    IController controller = entry.getValue();
                    if (!controller.isFull() || controller.getTimer().isCanWork()) continue;
                    BlockPos antennaPos = controller.getBlockAntennaPos();
                    LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                    if (lightning == null) break;
                    lightning.m_6027_((double)antennaPos.m_123341_(), (double)antennaPos.m_123342_(), (double)antennaPos.m_123343_());
                    level.m_7967_((Entity)lightning);
                    controller.getTimer().setCanWork(true);
                    controller.getTimer().resetTime();
                    controller.getEnergy().addEnergy(500000.0);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void workCutters(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity tile;
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (world.f_46443_) {
            return;
        }
        if (stack.m_41720_() == IUItem.cutter.getItem()) {
            BlockEntity tile2 = world.m_7702_(pos);
            if (tile2 instanceof BlockEntityMultiCable) {
                BlockEntityMultiCable cable = (BlockEntityMultiCable)tile2;
                ItemStack drop = cable.getPickBlock(player, null);
                if (!drop.m_41619_()) {
                    ModUtils.dropAsEntity(world, pos, drop);
                }
                cable.removeConductor();
            }
        } else if (!stack.m_41619_() && (tile = world.m_7702_(pos)) instanceof BlockEntityBase && player.m_6144_()) {
            ((BlockEntityBase)tile).onSneakingActivated(player, event.getHand(), event.getFace(), event.getHitVec().m_82450_());
        }
    }

    @SubscribeEvent
    public void bagPickup(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        try {
            ItemStack stack2;
            Item bags;
            ItemStack stack;
            int i;
            boolean isContainerBox;
            boolean isContainerBags = !(player.f_36096_ instanceof ContainerMenuBags);
            boolean bl = isContainerBox = !(player.f_36096_ instanceof ContainerMenuLeadBox);
            if (isContainerBags) {
                for (i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    stack = player.m_150109_().m_8020_(i);
                    if (!(stack.m_41720_() instanceof ItemEnergyBags) || !UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BAGS, stack)) continue;
                    bags = (ItemEnergyBags)stack.m_41720_();
                    stack2 = event.getItem().m_32055_();
                    if (event.getItem().m_213877_() || stack2.m_41720_() instanceof ItemEnergyBags || !bags.canInsert(player, stack, stack2)) continue;
                    ItemStack stack1 = stack2.m_41777_();
                    stack1.m_41764_(Math.min(stack1.m_41613_(), stack1.m_41741_()));
                    bags.insert(player, stack, stack1);
                    event.getItem().m_32045_(stack1);
                    event.getItem().m_142687_(Entity.RemovalReason.KILLED);
                    event.setResult(Event.Result.DENY);
                    event.setCanceled(true);
                    return;
                }
            }
            if (isContainerBox) {
                for (i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    stack = player.m_150109_().m_8020_(i);
                    if (!(stack.m_41720_() instanceof ItemLeadBox)) continue;
                    bags = (ItemLeadBox)stack.m_41720_();
                    stack2 = event.getItem().m_32055_();
                    if (event.getItem().m_213877_() || stack2.m_41720_() instanceof ItemLeadBox || !bags.canInsert(player, stack, stack2)) continue;
                    ItemStack stack1 = stack2.m_41777_();
                    stack1.m_41764_(Math.min(stack1.m_41613_(), stack1.m_41741_()));
                    bags.insert(player, stack, stack1);
                    event.getItem().m_32045_(stack1);
                    event.getItem().m_142687_(Entity.RemovalReason.KILLED);
                    event.setCanceled(true);
                    return;
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onCropGrowPre(BlockEvent.CropGrowEvent.Pre event) {
        BlockPos pos = event.getPos();
        Level world = (Level)event.getLevel();
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkLevel pollution = PollutionManager.pollutionManager.getChunkLevelSoil(chunkPos);
        if (pollution != null) {
            int pollutionLevel = pollution.getLevelPollution().ordinal();
            if (pollutionLevel >= 4) {
                event.setResult(Event.Result.DENY);
            } else if (pollutionLevel >= 1) {
                int chance = 0;
                chance = pollutionLevel == 1 ? 25 : (pollutionLevel == 2 ? 50 : 75);
                if (world.f_46441_.m_188503_(100) < chance) {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent
    public void onCropGrowPre1(BlockEvent.CropGrowEvent.Pre event) {
        BlockPos pos = event.getPos().m_7495_();
        Level world = (Level)event.getLevel();
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == IUItem.humus.getBlock(0) && world.f_46441_.m_188501_() < 0.5f) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void loginPlayer(PlayerEvent.PlayerLoggedInEvent event) {
        RadiationSystem.rad_system.update(event.getEntity());
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        new PacketColorPickerAllLoggIn();
        new PacketRadiationUpdateValue(event.getEntity(), event.getEntity().getPersistentData().m_128459_("radiation"));
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            CompoundTag nbt = player.getPersistentData();
            nbt.m_128347_("radiation", 0.0);
        }
    }

    public void setFly(Player player, boolean fly, ItemStack stack) {
        player.m_150110_().f_35935_ = fly;
        player.m_150110_().f_35936_ = fly;
        player.getPersistentData().m_128379_("isFlyActive", fly);
        if (player.m_9236_().f_46443_ && !fly) {
            player.m_150110_().m_35943_(0.05f);
            player.f_19789_ = 0.0f;
        } else {
            boolean edit = player.getPersistentData().m_128471_("edit_fly");
            if (!edit) {
                int flyspeed;
                int n = flyspeed = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FLYSPEED, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.FLYSPEED, (ItemStack)stack).number : 0;
                if (player.m_9236_().f_46443_) {
                    player.m_150110_().m_35943_((float)((double)0.1f + 0.05 * (double)flyspeed));
                }
            } else if (player.m_9236_().f_46443_) {
                player.m_150110_().m_35943_(player.getPersistentData().m_128457_("fly_speed"));
            }
        }
    }

    public boolean canFly(ItemStack stack) {
        return stack.m_41720_() == IUItem.spectral_chestplate.getItem() || stack.m_41720_() instanceof ItemSpecialArmor && (((ItemSpecialArmor)stack.m_41720_()).getListCapability().contains((Object)EnumCapability.FLY) || ((ItemSpecialArmor)stack.m_41720_()).getListCapability().contains((Object)EnumCapability.JETPACK_FLY)) || stack.m_41720_() instanceof ItemAdvJetpack && UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FLY, stack);
    }

    @SubscribeEvent
    public void FlyUpdate(LivingEvent.LivingTickEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        CompoundTag nbtData = player.getPersistentData();
        if (!player.m_7500_()) {
            if (!((ItemStack)player.m_150109_().f_35975_.get(2)).m_41619_()) {
                if (this.canFly((ItemStack)player.m_150109_().f_35975_.get(2))) {
                    CompoundTag nbtData1 = ModUtils.nbt((ItemStack)player.m_150109_().f_35975_.get(2));
                    boolean jetpack = nbtData1.m_128471_("jetpack");
                    if (!jetpack) {
                        if (nbtData.m_128471_("isFlyActive")) {
                            nbtData.m_128379_("hasFly", true);
                            this.setFly(player, false, (ItemStack)player.m_150109_().f_35975_.get(2));
                        }
                    } else if (!player.m_20096_()) {
                        if (nbtData1.m_128471_("canFly")) {
                            this.setFly(player, true, (ItemStack)player.m_150109_().f_35975_.get(2));
                            nbtData1.m_128379_("canFly", false);
                            nbtData.m_128379_("canjump", false);
                        }
                    } else if (nbtData.m_128471_("isFlyActive")) {
                        this.setFly(player, false, (ItemStack)player.m_150109_().f_35975_.get(2));
                    }
                } else if (!((ItemStack)player.m_150109_().f_35975_.get(2)).m_41619_() && nbtData.m_128471_("isFlyActive")) {
                    this.setFly(player, false, (ItemStack)player.m_150109_().f_35975_.get(2));
                }
            } else if (nbtData.m_128471_("isFlyActive")) {
                this.setFly(player, false, (ItemStack)player.m_150109_().f_35975_.get(2));
            }
        } else if (nbtData.m_128471_("isFlyActive")) {
            this.setFly(player, false, (ItemStack)player.m_150109_().f_35975_.get(2));
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Level world = event.level;
            if (world.m_46467_() % 20L != 0L) {
                return;
            }
            Iterable iterable = ((LevelInvoker)world).getGetEntities().m_142273_();
            List<Entity> list = StreamSupport.stream(iterable.spliterator(), false).filter(entity -> entity instanceof ItemEntity).toList();
            for (Entity entity2 : list) {
                ItemEntity entityItem;
                ItemEntity itemEntity;
                if (!(entity2 instanceof ItemEntity) || (itemEntity = (ItemEntity)entity2).m_213877_() || !itemEntity.m_20069_() || (entityItem = this.checkAndTransform(world, itemEntity)) == null) continue;
                world.m_7967_((Entity)entityItem);
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        WorldData.onWorldUnload((Level)event.getLevel());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void addInformItem(ItemTooltipEvent event) {
        CapturedMobUtils capturedMobUtils;
        CompoundTag nbt;
        int n;
        Object blockItem;
        BlockState blockState;
        List<Component> list;
        ItemStack stack = event.getItemStack();
        if (event.getItemStack().m_41619_()) {
            return;
        }
        Item item = stack.m_41720_();
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = event.getEntity();
        if (item == IUItem.charged_redstone.getItem()) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("charged_redstone.info")));
        }
        if (item == IUItem.recipe_schedule.getItem()) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.receptor.info")));
        }
        if (item == IUItem.connect_item.getItem()) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.configure_cable.info")));
        }
        if (item == IUItem.crafting_elements.getStack(40)) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.dosimeter.info")));
        }
        if (item == IUItem.crafting_elements.getStack(143)) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.schedule_reactor.info")));
        }
        if (item == IUItem.veinsencor.getStack(0)) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.scanner_info")));
        }
        if (item == IUItem.efReader.getItem()) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.ef_meter.info")));
        }
        if (item == IUItem.facadeItem.getItem()) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.facade_item.info")));
        }
        if (item == IUItem.reactorData.getItem()) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.reactor_data.info")));
        }
        if (stack.m_41720_() instanceof BlockItem && !(list = ModUtils.getInformationFromOre(blockState = (blockItem = (BlockItem)stack.m_41720_()).m_40614_().m_49966_())).isEmpty()) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("veins_ores.info1")));
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("veins_ores.info")));
            event.getToolTip().addAll(list);
        }
        if (item instanceof IRadioactiveItemType || item instanceof ItemNuclearResource) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.radiation.warning")));
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.radioprotector.info")));
        }
        for (Map.Entry entry : BlockEntityPalletGenerator.integerMap.entrySet()) {
            if (!((ItemStack)entry.getKey()).m_150930_(stack.m_41720_())) continue;
            event.getToolTip().add(Component.m_237113_((String)(Localization.translate("iu.pellets.info") + entry.getValue())));
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.pellets.info1")));
        }
        if (item.equals((Object)IUItem.module_quickly.getItem())) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.info.module.speed")));
        }
        if (item.equals((Object)IUItem.module_stack.getItem())) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.info.module.stack")));
        }
        if (item.equals((Object)IUItem.module_storage.getItem())) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.info.module.sorting")));
        }
        if (item instanceof ItemCraftingElements && ((ISubEnum)((ItemCraftingElements)item).getElement()).getId() >= 206 && ((ISubEnum)((ItemCraftingElements)item).getElement()).getId() <= 216) {
            int meta = ((ISubEnum)((ItemCraftingElements)item).getElement()).getId() - 205;
            event.getToolTip().add(Component.m_237113_((String)(Localization.translate("iu.limiter.info9") + EnergyNetGlobal.instance.getPowerFromTier(meta) + " EF")));
        }
        if ((item instanceof ItemBaseCircuit && (((ISubEnum)((ItemBaseCircuit)item).getElement()).getId() == 9 || ((ISubEnum)((ItemBaseCircuit)item).getElement()).getId() == 10 || ((ISubEnum)((ItemBaseCircuit)item).getElement()).getId() == 11 || ((ISubEnum)((ItemBaseCircuit)item).getElement()).getId() == 21) || item instanceof ItemCraftingElements && (((ISubEnum)((ItemCraftingElements)item).getElement()).getId() == 272 || ((ISubEnum)((ItemCraftingElements)item).getElement()).getId() == 273)) && (n = (nbt = ModUtils.nbt(stack)).m_128451_("level")) != 0) {
            event.getToolTip().add(Component.m_237113_((String)(Localization.translate("circuit.level") + " " + n)));
        }
        if (item instanceof ItemAdditionModule && ((ISubEnum)((ItemAdditionModule)item).getElement()).getId() == 9) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("module.wireless")));
        }
        if (item.equals((Object)IUItem.upgrade_speed_creation.getItem()) || item.equals((Object)IUItem.autoheater.getItem()) || item instanceof ItemCoolingUpgrade || item.equals((Object)IUItem.module_quickly.getItem()) || item.equals((Object)IUItem.module_stack.getItem()) || item.equals((Object)IUItem.module_storage.getItem()) || item instanceof ItemAdditionModule && (((ISubEnum)((ItemAdditionModule)item).getElement()).getId() == 4 || ((ISubEnum)((ItemAdditionModule)item).getElement()).getId() == 10)) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("module.wireless")));
        }
        if (item instanceof ItemEntityModule && (capturedMobUtils = CapturedMobUtils.create(stack)) != null) {
            Entity entity = capturedMobUtils.getEntity(player.f_19853_, true);
            event.getToolTip().add(entity.m_7755_());
        }
        if (ListInformationUtils.mechanism_info != null && !ListInformationUtils.mechanism_info.isEmpty() && (item.equals((Object)IUItem.module_quickly.getItem()) || item.equals((Object)IUItem.module_stack.getItem()) || item.equals((Object)IUItem.module_storage.getItem()))) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("using_kit")));
            if (!Keyboard.isKeyDown(340)) {
                event.getToolTip().add(Component.m_237113_((String)ListInformationUtils.mechanism_info.get(ListInformationUtils.index)));
            } else {
                for (String string : ListInformationUtils.mechanism_info) {
                    event.getToolTip().add(Component.m_237113_((String)string));
                }
            }
        }
        if (item instanceof ItemCoolingUpgrade) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("using_kit")));
            List<String> list3 = ListInformationUtils.integerListMap.get(((ISubEnum)((ItemCoolingUpgrade)item).getElement()).getId());
            if (list3 != null) {
                if (!Keyboard.isKeyDown(340)) {
                    event.getToolTip().add(Component.m_237113_((String)list3.get(ListInformationUtils.index % list3.size())));
                } else {
                    for (String string : list3) {
                        event.getToolTip().add(Component.m_237113_((String)string));
                    }
                }
            }
        }
        if (item.equals((Object)IUItem.autoheater.getItem()) && ListInformationUtils.mechanism_info2.size() > 0) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("using_kit")));
            if (!Keyboard.isKeyDown(340)) {
                event.getToolTip().add(Component.m_237113_((String)ListInformationUtils.mechanism_info2.get(ListInformationUtils.index2)));
            } else {
                for (String string : ListInformationUtils.mechanism_info2) {
                    event.getToolTip().add(Component.m_237113_((String)string));
                }
            }
        }
        if (item.equals((Object)IUItem.upgrade_speed_creation.getItem()) && ListInformationUtils.mechanism_info1.size() > 0) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("using_kit")));
            if (!Keyboard.isKeyDown(340)) {
                event.getToolTip().add(new ArrayList<Component>(ListInformationUtils.mechanism_info1.values()).get(ListInformationUtils.index1));
            } else {
                for (Component component : ListInformationUtils.mechanism_info1.values()) {
                    event.getToolTip().add(component);
                }
            }
        }
        if (stack.m_41720_().equals((Object)IUItem.analyzermodule.getItem())) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.analyzermodule")));
        }
        if (stack.m_41720_().equals((Object)IUItem.quarrymodule.getItem())) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.quarrymodule")));
        }
        if (stack.m_41720_().equals((Object)IUItem.expmodule.getItem())) {
            event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.expierence_module.info")));
        }
        if (stack.m_41720_() instanceof ItemEntityModule) {
            int meta = ((ISubEnum)((ItemEntityModule)stack.m_41720_()).getElement()).getId();
            if (meta == 0) {
                event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.entitymodule")));
            }
            if (meta == 1) {
                event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.entitymodule1")));
            }
        }
        if (stack.m_41720_() instanceof ItemBaseModules) {
            EnumModule module = EnumModule.getFromID(((ISubEnum)((ItemBaseModules)stack.m_41720_()).getElement()).getId());
            if (module.type.equals((Object)EnumBaseType.PHASE)) {
                event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.phasemodule")));
            }
            if (module.type.equals((Object)EnumBaseType.MOON_LINSE)) {
                event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.moonlinse")));
            }
        }
        if (IUEventHandler.getUpgradeItem(stack) && UpgradeSystem.system.hasInMap(stack)) {
            List<UpgradeItemInform> lst = UpgradeSystem.system.getInformation(stack);
            int n2 = UpgradeSystem.system.getRemaining(stack);
            if (!lst.isEmpty()) {
                for (UpgradeItemInform upgradeItemInform : lst) {
                    event.getToolTip().add(Component.m_237113_((String)upgradeItemInform.getName()));
                }
            }
            if (n2 != 0) {
                event.getToolTip().add(Component.m_237113_((String)(Localization.translate("free_slot") + n2 + Localization.translate("free_slot1"))));
                if (Keyboard.isKeyDown(340)) {
                    event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.can_upgrade_item")));
                    UpgradeItem upgradeItem = (UpgradeItem)stack.m_41720_();
                    List<String> list2 = UpgradeSystem.system.getAvailableUpgrade(upgradeItem, stack);
                    list2.forEach(s -> event.getToolTip().add(Component.m_237113_((String)s)));
                }
            } else {
                event.getToolTip().add(Component.m_237113_((String)Localization.translate("not_free_slot")));
            }
        }
        if (stack.m_41720_() instanceof IRoversItem && SpaceUpgradeSystem.system.hasInMap(stack)) {
            List<SpaceUpgradeItemInform> lst = SpaceUpgradeSystem.system.getInformation(stack);
            int n3 = SpaceUpgradeSystem.system.getRemaining(stack);
            if (!lst.isEmpty()) {
                for (SpaceUpgradeItemInform spaceUpgradeItemInform : lst) {
                    event.getToolTip().add(Component.m_237113_((String)spaceUpgradeItemInform.getName()));
                }
            }
            if (n3 != 0) {
                event.getToolTip().add(Component.m_237113_((String)(Localization.translate("free_slot") + n3 + Localization.translate("free_slot1"))));
                if (Keyboard.isKeyDown(340)) {
                    event.getToolTip().add(Component.m_237113_((String)Localization.translate("iu.can_upgrade_item")));
                    IRoversItem iRoversItem = (IRoversItem)stack.m_41720_();
                    List<String> list3 = SpaceUpgradeSystem.system.getAvailableUpgrade(iRoversItem, stack);
                    list3.forEach(s -> event.getToolTip().add(Component.m_237113_((String)s)));
                }
            } else {
                event.getToolTip().add(Component.m_237113_((String)Localization.translate("not_free_slot")));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void addInfo(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (IUItem.machineRecipe == null) {
            IUItem.machineRecipe = Recipes.recipes.getRecipeStack("converter");
        }
        if (IUItem.fluidMatterRecipe == null) {
            IUItem.fluidMatterRecipe = Recipes.recipes.getRecipeStack("replicator");
        }
        try {
            RecipeOutput output1;
            if (this.tupleRecipe == null) {
                for (Map.Entry<ItemStack, BaseMachineRecipe> entry : IUItem.machineRecipe) {
                    if (!entry.getKey().m_150930_(stack.m_41720_())) continue;
                    this.tupleRecipe = new Tuple((Object)stack, (Object)entry.getValue());
                    if (!Keyboard.isKeyDown(340)) {
                        event.getToolTip().add(Component.m_130674_((String)Localization.translate("press.lshift")));
                    }
                    if (!Keyboard.isKeyDown(340)) break;
                    event.getToolTip().add(Component.m_130674_((String)Localization.translate("clonning")));
                    output1 = entry.getValue().output;
                    for (int i = 0; i < this.name.length; ++i) {
                        if (output1.metadata.m_128459_("quantitysolid_" + i) == 0.0) continue;
                        event.getToolTip().add(Component.m_130674_((String)(this.name[i] + Localization.translate(this.mattertype[i]) + ": " + output1.metadata.m_128459_("quantitysolid_" + i) + Localization.translate("matternumber"))));
                    }
                }
                if (this.tupleRecipe == null) {
                    this.tupleRecipe = new Tuple((Object)stack, null);
                }
            } else if (((ItemStack)this.tupleRecipe.m_14418_()).m_150930_(stack.m_41720_())) {
                if (this.tupleRecipe.m_14419_() != null) {
                    if (!Keyboard.isKeyDown(340)) {
                        event.getToolTip().add(Component.m_130674_((String)Localization.translate("press.lshift")));
                    }
                    if (Keyboard.isKeyDown(340)) {
                        event.getToolTip().add(Component.m_130674_((String)Localization.translate("clonning")));
                        RecipeOutput output12 = ((BaseMachineRecipe)this.tupleRecipe.m_14419_()).output;
                        for (int i = 0; i < this.name.length; ++i) {
                            if (output12.metadata.m_128459_("quantitysolid_" + i) == 0.0) continue;
                            event.getToolTip().add(Component.m_130674_((String)(this.name[i] + Localization.translate(this.mattertype[i]) + ": " + output12.metadata.m_128459_("quantitysolid_" + i) + Localization.translate("matternumber"))));
                        }
                    }
                }
            } else {
                boolean find = false;
                for (Map.Entry<ItemStack, BaseMachineRecipe> entry : IUItem.machineRecipe) {
                    if (!entry.getKey().m_150930_(stack.m_41720_())) continue;
                    this.tupleRecipe = new Tuple((Object)stack, (Object)entry.getValue());
                    find = true;
                    if (!Keyboard.isKeyDown(340)) {
                        event.getToolTip().add(Component.m_130674_((String)Localization.translate("press.lshift")));
                    }
                    if (!Keyboard.isKeyDown(340)) break;
                    event.getToolTip().add(Component.m_130674_((String)Localization.translate("clonning")));
                    RecipeOutput output13 = entry.getValue().output;
                    for (int i = 0; i < this.name.length; ++i) {
                        if (output13.metadata.m_128459_("quantitysolid_" + i) == 0.0) continue;
                        event.getToolTip().add(Component.m_130674_((String)(this.name[i] + Localization.translate(this.mattertype[i]) + ": " + output13.metadata.m_128459_("quantitysolid_" + i) + Localization.translate("matternumber"))));
                    }
                }
                if (!find) {
                    this.tupleRecipe = new Tuple((Object)stack, null);
                }
            }
            if (this.tupleReplicatorRecipe == null) {
                for (Map.Entry<ItemStack, BaseMachineRecipe> entry : IUItem.fluidMatterRecipe) {
                    if (!entry.getKey().m_150930_(stack.m_41720_())) continue;
                    if (!Keyboard.isKeyDown(340) && !event.getToolTip().contains(Component.m_130674_((String)Localization.translate("press.lshift")))) {
                        event.getToolTip().add(Component.m_130674_((String)Localization.translate("press.lshift")));
                    }
                    this.tupleReplicatorRecipe = new Tuple((Object)stack, (Object)entry.getValue());
                    if (!Keyboard.isKeyDown(340)) break;
                    output1 = entry.getValue().output;
                    double matter = output1.metadata.m_128459_("matter");
                    String usingMatter = ModUtils.getStringBukket(matter) + Localization.translate("iu.generic.text.bucketUnit");
                    event.getToolTip().add(Component.m_130674_((String)(Localization.translate("iu.replicator_using_matter") + ChatFormatting.DARK_PURPLE + usingMatter)));
                    break;
                }
                if (this.tupleReplicatorRecipe == null) {
                    this.tupleReplicatorRecipe = new Tuple((Object)stack, null);
                }
            } else if (((ItemStack)this.tupleReplicatorRecipe.m_14418_()).m_150930_(stack.m_41720_())) {
                if (this.tupleReplicatorRecipe.m_14419_() != null) {
                    if (!Keyboard.isKeyDown(340) && !event.getToolTip().contains(Component.m_130674_((String)Localization.translate("press.lshift")))) {
                        event.getToolTip().add(Component.m_130674_((String)Localization.translate("press.lshift")));
                    }
                    if (Keyboard.isKeyDown(340)) {
                        RecipeOutput output14 = ((BaseMachineRecipe)this.tupleReplicatorRecipe.m_14419_()).output;
                        double matter = output14.metadata.m_128459_("matter");
                        String usingMatter = ModUtils.getStringBukket(matter) + Localization.translate("iu.generic.text.bucketUnit");
                        event.getToolTip().add(Component.m_130674_((String)(Localization.translate("iu.replicator_using_matter") + ChatFormatting.DARK_PURPLE + usingMatter)));
                    }
                }
            } else {
                this.tupleReplicatorRecipe = null;
                for (Map.Entry<ItemStack, BaseMachineRecipe> entry : IUItem.fluidMatterRecipe) {
                    if (!entry.getKey().m_150930_(stack.m_41720_())) continue;
                    if (!Keyboard.isKeyDown(340) && !event.getToolTip().contains(Component.m_130674_((String)Localization.translate("press.lshift")))) {
                        event.getToolTip().add(Component.m_130674_((String)Localization.translate("press.lshift")));
                    }
                    this.tupleReplicatorRecipe = new Tuple((Object)stack, (Object)entry.getValue());
                    if (!Keyboard.isKeyDown(340)) break;
                    output1 = entry.getValue().output;
                    double matter = output1.metadata.m_128459_("matter");
                    String usingMatter = ModUtils.getStringBukket(matter) + Localization.translate("iu.generic.text.bucketUnit");
                    event.getToolTip().add(Component.m_130674_((String)(Localization.translate("iu.replicator_using_matter") + ChatFormatting.DARK_PURPLE + usingMatter)));
                    break;
                }
                if (this.tupleReplicatorRecipe == null) {
                    this.tupleReplicatorRecipe = new Tuple((Object)stack, null);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ItemEntity checkAndTransform(Level world, ItemEntity entityItem) {
        LevelEntityGetter<Entity> list1 = ((LevelInvoker)world).getGetEntities();
        ArrayList nearbyItems = Lists.newArrayList();
        list1.m_142232_(new AABB(entityItem.m_20185_() - 1.0, entityItem.m_20186_() - 1.0, entityItem.m_20189_() - 1.0, entityItem.m_20185_() + 1.0, entityItem.m_20186_() + 1.0, entityItem.m_20189_() + 1.0), p_151522_ -> {
            if (p_151522_ instanceof ItemEntity) {
                nearbyItems.add((ItemEntity)p_151522_);
            }
        });
        int redstoneNeeded = 4;
        int poloniumNeeded = 1;
        int electrumNeeded = 1;
        LinkedList<Object> redstoneItems = new LinkedList<Object>();
        LinkedList<Object> poloniumItems = new LinkedList<Object>();
        LinkedList<Object> electrumItems = new LinkedList<Object>();
        for (Object item : nearbyItems) {
            if (item.m_213877_()) continue;
            ItemStack stack = item.m_32055_();
            if (stack.m_41720_() == Items.f_42451_ && redstoneNeeded > 0) {
                redstoneItems.add(item);
                redstoneNeeded -= stack.m_41613_();
                continue;
            }
            if (stack.m_150930_((Item)IUItem.iudust.getStack(55)) && poloniumNeeded > 0) {
                poloniumItems.add(item);
                poloniumNeeded -= stack.m_41613_();
                continue;
            }
            if (!stack.m_204117_(electrumTag) || electrumNeeded <= 0) continue;
            electrumItems.add(item);
            electrumNeeded -= stack.m_41613_();
        }
        if (redstoneNeeded <= 0 && poloniumNeeded <= 0 && electrumNeeded <= 0) {
            int remainingRedstone = 4;
            for (Object item : redstoneItems) {
                ItemStack stack = item.m_32055_();
                if (stack.m_41613_() <= remainingRedstone) {
                    remainingRedstone -= stack.m_41613_();
                    item.m_142467_(Entity.RemovalReason.KILLED);
                    continue;
                }
                stack.m_41774_(remainingRedstone);
                break;
            }
            int remainingPolonium = 1;
            for (Object item : poloniumItems) {
                ItemStack itemStack = item.m_32055_();
                if (itemStack.m_41613_() <= remainingPolonium) {
                    remainingPolonium -= itemStack.m_41613_();
                    item.m_142467_(Entity.RemovalReason.KILLED);
                    continue;
                }
                itemStack.m_41774_(remainingPolonium);
                break;
            }
            int remainingElectrum = 1;
            for (ItemEntity itemEntity : electrumItems) {
                ItemStack stack = itemEntity.m_32055_();
                if (stack.m_41613_() <= remainingElectrum) {
                    remainingElectrum -= stack.m_41613_();
                    itemEntity.m_142467_(Entity.RemovalReason.KILLED);
                    continue;
                }
                stack.m_41774_(remainingElectrum);
                break;
            }
            ItemStack chargedRedstone = new ItemStack((ItemLike)IUItem.charged_redstone.getItem());
            return new ItemEntity(world, entityItem.m_20185_(), entityItem.m_20186_(), entityItem.m_20189_(), chargedRedstone);
        }
        return null;
    }
}

