/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei;

import com.denfop.recipes.ScrapboxRecipeManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;

public class ScrapboxRecipeHandler {
    private static final List<ScrapboxRecipeHandler> recipes = new ArrayList<ScrapboxRecipeHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final double need;

    public ScrapboxRecipeHandler(ItemStack input, ItemStack output, double need) {
        this.input = input;
        this.output = output;
        this.need = need;
    }

    public static List<ScrapboxRecipeHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ScrapboxRecipeHandler.initRecipes();
        }
        return recipes;
    }

    public static ScrapboxRecipeHandler addRecipe(ItemStack input, ItemStack output, double need) {
        ScrapboxRecipeHandler recipe = new ScrapboxRecipeHandler(input, output, need);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static ScrapboxRecipeHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (ScrapboxRecipeHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (Map.Entry<ItemStack, Float> itemStackFloatEntry : ScrapboxRecipeManager.instance.getDrops().entrySet()) {
            ScrapboxRecipeHandler.addRecipe(itemStackFloatEntry.getKey(), itemStackFloatEntry.getKey(), itemStackFloatEntry.getValue().floatValue());
        }
    }

    public double getNeed() {
        return this.need;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

