/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.deposits_molot;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.VeinType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DepositsMolotHandler {
    private static final List<DepositsMolotHandler> recipes = new ArrayList<DepositsMolotHandler>();
    private final VeinType veinType;
    private final MachineRecipe machineRecipe;

    public DepositsMolotHandler(MachineRecipe machineRecipe, VeinType veinType) {
        this.veinType = veinType;
        this.machineRecipe = machineRecipe;
    }

    public static List<DepositsMolotHandler> getRecipes() {
        if (recipes.isEmpty()) {
            DepositsMolotHandler.initRecipes();
        }
        return recipes;
    }

    public static DepositsMolotHandler addRecipe(MachineRecipe machineRecipe, VeinType veinType) {
        DepositsMolotHandler recipe = new DepositsMolotHandler(machineRecipe, veinType);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (VeinType vein : WorldBaseGen.veinTypes) {
            List<BaseMachineRecipe> recipe_list;
            IBaseRecipe recipe;
            MachineRecipe output;
            if (vein.getHeavyOre() == null || (output = Recipes.recipes.getRecipeMachineRecipeOutput(recipe = Recipes.recipes.getRecipe("handlerho"), recipe_list = Recipes.recipes.getRecipeList("handlerho"), false, Collections.singletonList(new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1)))) == null) continue;
            DepositsMolotHandler.addRecipe(output, vein);
        }
    }

    public List<ItemStack> getInputs() {
        return new ArrayList<ItemStack>(this.machineRecipe.getRecipe().output.items);
    }

    public MachineRecipe getMachineRecipe() {
        return this.machineRecipe;
    }

    public VeinType getVeinType() {
        return this.veinType;
    }
}

