/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.fluidseparator;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FluidSeparatorHandler {
    private static final List<FluidSeparatorHandler> recipes = new ArrayList<FluidSeparatorHandler>();
    private final FluidStack output1;
    private final FluidStack input;
    private final FluidStack output;

    public FluidSeparatorHandler(FluidStack input, FluidStack output, FluidStack output1) {
        this.input = input;
        this.output1 = output1;
        this.output = output;
    }

    public static List<FluidSeparatorHandler> getRecipes() {
        if (recipes.isEmpty()) {
            FluidSeparatorHandler.initRecipes();
        }
        return recipes;
    }

    public static FluidSeparatorHandler addRecipe(FluidStack input, FluidStack output, FluidStack output1) {
        FluidSeparatorHandler recipe = new FluidSeparatorHandler(input, output, output1);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static FluidSeparatorHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        for (BaseFluidMachineRecipe machineRecipe : Recipes.recipes.getRecipeFluid().getRecipeList("fluid_separator")) {
            FluidStack fluidStack = machineRecipe.getInput().getInputs().get(0);
            FluidStack fluidStack1 = machineRecipe.getOutput_fluid().get(0);
            FluidStack fluidStack2 = machineRecipe.getOutput_fluid().get(1);
            FluidSeparatorHandler.addRecipe(fluidStack, fluidStack1, fluidStack2);
        }
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public FluidStack getOutput1() {
        return this.output1;
    }
}

