/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.geothermal;

import com.denfop.blocks.FluidName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GeoThermalHandler {
    private static final List<GeoThermalHandler> recipes = new ArrayList<GeoThermalHandler>();
    private final FluidStack input;
    private final FluidStack output;

    public GeoThermalHandler(FluidStack input, FluidStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<GeoThermalHandler> getRecipes() {
        if (recipes.isEmpty()) {
            GeoThermalHandler.initRecipes();
        }
        return recipes;
    }

    public static GeoThermalHandler addRecipe(FluidStack input, FluidStack output) {
        GeoThermalHandler recipe = new GeoThermalHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        GeoThermalHandler.addRecipe(new FluidStack((Fluid)FluidName.fluidhot_coolant.getInstance().get(), 3), new FluidStack((Fluid)FluidName.fluidpetroleum.getInstance().get(), 1));
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }
}

