/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.macerator;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class MaceratorHandler {
    private static final List<MaceratorHandler> recipes = new ArrayList<MaceratorHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final BaseMachineRecipe container;

    public MaceratorHandler(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        this.input = input;
        this.output = output;
        this.container = container;
    }

    public static List<MaceratorHandler> getRecipes() {
        if (recipes.isEmpty()) {
            MaceratorHandler.initRecipes();
        }
        return recipes;
    }

    public static MaceratorHandler addRecipe(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        MaceratorHandler recipe = new MaceratorHandler(input, output, container);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static MaceratorHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (MaceratorHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("macerator")) {
            MaceratorHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container);
        }
    }

    public BaseMachineRecipe getContainer() {
        return this.container;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return is.m_41720_() == this.input.m_41720_();
    }
}

