/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.microchip;

import com.denfop.IUItem;
import com.denfop.blockentity.mechanism.BlockEntityMatterFactory;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.microchip.MicrochipHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class MicrochipCategory
extends ScreenMain
implements IRecipeCategory<MicrochipHandler> {
    private final JeiInform jeiInform;
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;

    public MicrochipCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((BlockEntityMatterFactory)BlockBaseMachine3Entity.matter_factory.getDummyTe()).getGuiContainer((Player)Minecraft.m_91087_().f_91074_));
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/GUICirsuit".toLowerCase() + ".png"), 3, 3, 140, 77);
        this.jeiInform = jeiInform;
        this.f_96539_ = Component.m_237113_((String)this.getTitles());
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(ItemStackHelper.fromData(IUItem.machines, 1, 6).m_41778_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public RecipeType<MicrochipHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    public void draw(MicrochipHandler recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        ++this.progress;
        ++this.energy;
        double energylevel = Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        double xScale = 24.0 * (double)this.progress / 100.0;
        double xScale1 = 10.0f * (float)this.progress / 100.0f;
        double xScale2 = 19.0f * (float)this.progress / 100.0f;
        if (xScale > 24.0) {
            this.progress = 0;
        }
        Minecraft.m_91087_().f_91062_.m_92883_(stack, recipe.getTemperature() + "\u00b0C", 70.0f, 80.0f, 0x404040);
        MicrochipCategory.bindTexture(this.getTexture());
        int temperature = 38 * recipe.getTemperature() / 5000;
        if (temperature > 0) {
            this.drawTexturedModalRect(stack, 67, 60, 176, 21, temperature + 1, 11);
        }
        this.drawTexturedModalRect(stack, 25, 9, 176, 34, (int)(xScale + 1.0), 32);
        this.drawTexturedModalRect(stack, 57, 13, 176, 65, (int)(xScale1 + 1.0), 21);
        this.drawTexturedModalRect(stack, 86, 19, 176, 86, (int)(xScale2 + 1.0), 7);
        this.drawTexturedModalRect(stack, 2, 73 - (int)energylevel, 176, 14 - (int)energylevel, 14, (int)energylevel);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MicrochipHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 7, 6).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 7, 27).addItemStack(recipe.getInput1());
        builder.addSlot(RecipeIngredientRole.INPUT, 40, 6).addItemStack(recipe.getInput2());
        builder.addSlot(RecipeIngredientRole.INPUT, 40, 26).addItemStack(recipe.getInput3());
        builder.addSlot(RecipeIngredientRole.INPUT, 68, 16).addItemStack(recipe.getInput4());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 109, 16).addItemStack(recipe.getOutput());
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(recipe.getContainer().input.getAllStackInputs());
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/GUICirsuit.png".toLowerCase());
    }
}

