/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.satelliteassembler;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class SatelliteAssemblerHandler {
    private static final List<SatelliteAssemblerHandler> recipes = new ArrayList<SatelliteAssemblerHandler>();
    private final List<ItemStack> input;
    ItemStack output;

    public SatelliteAssemblerHandler(List<ItemStack> input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<SatelliteAssemblerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            SatelliteAssemblerHandler.initRecipes();
        }
        return recipes;
    }

    public static SatelliteAssemblerHandler addRecipe(List<ItemStack> input, ItemStack output) {
        SatelliteAssemblerHandler recipe = new SatelliteAssemblerHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("satelliteassembler")) {
            SatelliteAssemblerHandler.addRecipe(container.input.getStackInputs(), container.getOutput().items.get(0));
        }
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }
}

