/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.worldcollector.aer;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class AerHandler {
    private static final List<AerHandler> recipes = new ArrayList<AerHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final double need;

    public AerHandler(ItemStack input, ItemStack output, double need) {
        this.input = input;
        this.output = output;
        this.need = need;
    }

    public static List<AerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            AerHandler.initRecipes();
        }
        return recipes;
    }

    public static AerHandler addRecipe(ItemStack input, ItemStack output, double need) {
        AerHandler recipe = new AerHandler(input, output, need);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static AerHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (AerHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("aercollector")) {
            AerHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container.getOutput().metadata.m_128459_("need"));
        }
    }

    public double getNeed() {
        return this.need;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

