/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.api.widget.ITypeSlot;
import com.denfop.blockentity.base.BlockEntityAutoDigger;
import com.denfop.blocks.ISubEnum;
import com.denfop.inventory.Inventory;
import com.denfop.items.modules.EnumQuarryModules;
import com.denfop.items.modules.EnumQuarryType;
import com.denfop.items.modules.ItemQuarryModule;
import net.minecraft.world.item.ItemStack;

public class InventoryDigger
extends Inventory
implements ITypeSlot {
    public final BlockEntityAutoDigger tile;
    public int stackSizeLimit;

    public InventoryDigger(BlockEntityAutoDigger base1) {
        super(base1, Inventory.TypeItemSlot.INPUT, 3);
        this.tile = base1;
        this.stackSizeLimit = 1;
    }

    @Override
    public void update() {
        this.tile.consume = this.tile.energyconsume;
        this.tile.col = 1;
        this.tile.chance = 0;
        this.tile.furnace = false;
        this.tile.comb_mac_enabled = false;
        this.tile.mac_enabled = false;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_()) continue;
            ItemStack type1 = this.get(i);
            EnumQuarryModules module = EnumQuarryModules.getFromID(((ISubEnum)((ItemQuarryModule)type1.m_41720_()).getElement()).getId());
            EnumQuarryType type = module.type;
            switch (type) {
                case SPEED: {
                    break;
                }
                case DEPTH: {
                    this.tile.col = module.efficiency * module.efficiency;
                    break;
                }
                case LUCKY: {
                    this.tile.chance = module.efficiency;
                    break;
                }
                case FURNACE: {
                    this.tile.furnace = true;
                    break;
                }
                case COMB_MAC: {
                    this.tile.comb_mac_enabled = true;
                    break;
                }
                case MACERATOR: {
                    this.tile.mac_enabled = true;
                }
            }
            this.tile.consume += this.tile.energyconsume * module.cost;
        }
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        this.tile.consume = this.tile.energyconsume;
        this.tile.col = 1;
        this.tile.chance = 0;
        this.tile.furnace = false;
        this.tile.comb_mac_enabled = false;
        this.tile.mac_enabled = false;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_()) continue;
            ItemStack type1 = this.get(i);
            EnumQuarryModules module = EnumQuarryModules.getFromID(((ISubEnum)((ItemQuarryModule)type1.m_41720_()).getElement()).getId());
            EnumQuarryType type = module.type;
            switch (type) {
                case SPEED: {
                    break;
                }
                case DEPTH: {
                    this.tile.col = module.efficiency * module.efficiency;
                    break;
                }
                case LUCKY: {
                    this.tile.chance = module.efficiency;
                    break;
                }
                case FURNACE: {
                    this.tile.furnace = true;
                    break;
                }
                case COMB_MAC: {
                    this.tile.comb_mac_enabled = true;
                    break;
                }
                case MACERATOR: {
                    this.tile.mac_enabled = true;
                }
            }
            this.tile.consume += this.tile.energyconsume * module.cost;
        }
        this.tile.inputslot.update();
        return content;
    }

    @Override
    public boolean m_7013_(int index, ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ItemQuarryModule && EnumQuarryModules.getFromID((int)((ISubEnum)((ItemQuarryModule)itemStack.m_41720_()).getElement()).getId()).type != EnumQuarryType.WHITELIST && EnumQuarryModules.getFromID((int)((ISubEnum)((ItemQuarryModule)itemStack.m_41720_()).getElement()).getId()).type != EnumQuarryType.BLACKLIST;
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    @Override
    public EnumTypeSlot getTypeSlot(int slotid) {
        return EnumTypeSlot.QUARRY1;
    }
}

