/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.api.widget.ITypeSlot;
import com.denfop.blockentity.base.BlockEntityCombinerMatter;
import com.denfop.blocks.blockitem.ItemBlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachineEntity;
import com.denfop.blocks.mechanism.BlockSimpleMachineEntity;
import com.denfop.blocks.mechanism.BlocksPhotonicMachine;
import com.denfop.inventory.Inventory;
import net.minecraft.world.item.ItemStack;

public class InventoryMatter
extends Inventory
implements ITypeSlot {
    private final BlockEntityCombinerMatter tile;
    private int stackSizeLimit = 4;

    public InventoryMatter(BlockEntityCombinerMatter base1) {
        super(base1, Inventory.TypeItemSlot.INPUT, 9);
        this.tile = base1;
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        return EnumTypeSlot.BLOCKS;
    }

    @Override
    public void update() {
        this.tile.energy.setCapacity(this.getMaxEnergy(this));
        this.tile.fluidTank.setCapacity(this.getFluidTank(this));
        this.tile.energycost = this.getcostEnergy(this);
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        this.tile.energy.setCapacity(this.getMaxEnergy(this));
        this.tile.fluidTank.setCapacity(this.getFluidTank(this));
        this.tile.energycost = this.getcostEnergy(this);
        return content;
    }

    @Override
    public boolean m_7013_(int index, ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ItemBlockTileEntity && ((ItemBlockTileEntity)itemStack.m_41720_()).getTeBlock(itemStack).getIDBlock() == BlockBaseMachineEntity.adv_matter.getIDBlock() && ((ItemBlockTileEntity)itemStack.m_41720_()).getTeBlock(itemStack).getId() <= 3 || itemStack.m_41720_() instanceof ItemBlockTileEntity && ((ItemBlockTileEntity)itemStack.m_41720_()).getTeBlock(itemStack).getIDBlock() == BlockSimpleMachineEntity.generator_matter.getIDBlock() && ((ItemBlockTileEntity)itemStack.m_41720_()).getTeBlock(itemStack).getId() == 6 || itemStack.m_41720_() instanceof ItemBlockTileEntity && ((ItemBlockTileEntity)itemStack.m_41720_()).getTeBlock(itemStack).getIDBlock() == BlockBaseMachineEntity.imp_matter.getIDBlock() || itemStack.m_41720_() instanceof ItemBlockTileEntity && ((ItemBlockTileEntity)itemStack.m_41720_()).getTeBlock(itemStack).getIDBlock() == BlockBaseMachineEntity.per_matter.getIDBlock() || itemStack.m_41720_() instanceof ItemBlockTileEntity && ((ItemBlockTileEntity)itemStack.m_41720_()).getTeBlock(itemStack).getIDBlock() == BlocksPhotonicMachine.photonic_gen_matter.getIDBlock() && ((ItemBlockTileEntity)itemStack.m_41720_()).getTeBlock(itemStack).getId() == 12;
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    public double getMattercostenergy(ItemStack stack) {
        int count = ((ItemBlockTileEntity)stack.m_41720_()).getTeBlock(stack).getId();
        switch (count) {
            case 1: {
                return 900000.0;
            }
            case 2: {
                return 800000.0;
            }
            case 3: {
                return 700000.0;
            }
            case 12: {
                return 600000.0;
            }
        }
        return 1000000.0;
    }

    public double getMatterenergy(ItemStack stack) {
        int count = ((ItemBlockTileEntity)stack.m_41720_()).getTeBlock(stack).getId();
        switch (count) {
            case 1: {
                return 8000000.0;
            }
            case 2: {
                return 6.4E7;
            }
            case 3: {
                return 2.56E8;
            }
            case 12: {
                return 5.12E8;
            }
        }
        return 5000000.0;
    }

    public double getMaxEnergy(InventoryMatter inputSlot) {
        double maxEnergy = 0.0;
        for (int i = 0; i < 9; ++i) {
            if (inputSlot.get(i).m_41619_()) continue;
            maxEnergy += this.getMatterenergy(inputSlot.get(i)) * (double)inputSlot.get(i).m_41613_();
        }
        return maxEnergy;
    }

    public double getcostEnergy(InventoryMatter inputSlot) {
        double cost = 0.0;
        int k = 0;
        for (int i = 0; i < 9; ++i) {
            if (inputSlot.get(i).m_41619_()) continue;
            cost += this.getMattercostenergy(inputSlot.get(i)) * (double)inputSlot.get(i).m_41613_();
            k += inputSlot.get(i).m_41613_();
        }
        return cost / (double)k;
    }

    public int getFluidTank(InventoryMatter inputSlot) {
        int count = 0;
        for (int i = 0; i < 9; ++i) {
            if (inputSlot.get(i).m_41619_()) continue;
            count += this.getMattertank(inputSlot.get(i)) * inputSlot.get(i).m_41613_();
        }
        return 1000 * count;
    }

    private int getMattertank(ItemStack stack) {
        int count = ((ItemBlockTileEntity)stack.m_41720_()).getTeBlock(stack).getId();
        switch (count) {
            case 1: {
                return 12;
            }
            case 2: {
                return 14;
            }
            case 3: {
                return 16;
            }
            case 12: {
                return 16;
            }
        }
        return 10;
    }
}

