/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.api.recipe.IRecipeInputStack;
import com.denfop.api.recipe.RecipeInputStack;
import com.denfop.blockentity.base.BlockEntityScanner;
import com.denfop.inventory.Inventory;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class InventoryScannable
extends Inventory {
    private final IBaseRecipe recipe;
    private final List<IRecipeInputStack> accepts;
    private final BlockEntityScanner tile;
    private final List<BaseMachineRecipe> recipes;

    public InventoryScannable(BlockEntityScanner base1, int count) {
        super(base1, Inventory.TypeItemSlot.INPUT, count);
        this.setStackSizeLimit(1);
        this.tile = base1;
        this.recipe = Recipes.recipes.getRecipe("replicator");
        this.accepts = Recipes.recipes.getMap_recipe_managers_itemStack(this.recipe.getName());
        this.recipes = Recipes.recipes.getRecipeList(this.recipe.getName());
    }

    @Override
    public boolean m_7013_(int index, ItemStack stack) {
        return this.accepts.contains(new RecipeInputStack(stack)) && this.tile.state != BlockEntityScanner.State.COMPLETED;
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        if (content.m_41619_()) {
            this.tile.recipe = null;
        } else {
            this.tile.recipe = Recipes.recipes.getRecipeOutput(this.recipe, this.recipes, false, content);
            this.tile.pattern = this.tile.recipe.output.items.get(0);
        }
        return content;
    }
}

