/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.blockentity.bee.FrameAttributeLevel;
import com.denfop.blockentity.bee.FrameItem;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.ItemMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemFrame<T extends Enum<T>>
extends ItemMain<T>
implements FrameItem {
    public ItemFrame(T element) {
        super(new Item.Properties().m_41491_(IUCore.ItemTab).m_41487_(1), element);
    }

    @Override
    public FrameAttributeLevel getAttribute(int meta) {
        return FrameAttributeLevel.values()[((ISubEnum)this.getElement()).getId()];
    }

    @Override
    public int getCustomDamage(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0;
        }
        assert (stack.m_41783_() != null);
        return stack.m_41783_().m_128451_("damage");
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.m_237113_((String)(Localization.translate("iu.reactoritem.durability") + " " + (this.getMaxCustomDamage(p_41421_) - this.getCustomDamage(p_41421_)) + "/" + this.getMaxCustomDamage(p_41421_))));
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return true;
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return Math.round(13.0f - (float)((double)this.getCustomDamage(stack) * 13.0 / (double)this.getMaxCustomDamage(stack)));
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)((float)(Math.max(0.0, 1.0 - (double)this.getCustomDamage(stack) / (double)this.getMaxCustomDamage(stack)) / 3.0)), (float)1.0f, (float)1.0f);
    }

    @Override
    public int getMaxCustomDamage(ItemStack var1) {
        return switch (((ISubEnum)this.getElement()).getId() % 3) {
            case 0 -> 72000;
            case 1 -> 108000;
            case 2 -> 216000;
            default -> 72000;
        };
    }

    @Override
    public void setCustomDamage(ItemStack stack, int damage) {
        CompoundTag nbt = ModUtils.nbt(stack);
        if (damage > this.getMaxCustomDamage(stack)) {
            damage = this.getMaxCustomDamage(stack);
        }
        nbt.m_128405_("damage", damage);
    }

    @Override
    public boolean applyCustomDamage(ItemStack stack, int damage, LivingEntity src) {
        int damage1 = this.getCustomDamage(stack) - damage;
        if (damage1 <= 0) {
            damage1 = 0;
        }
        this.setCustomDamage(stack, damage1);
        return this.getMaxCustomDamage(stack) - damage1 == 0;
    }

    public static enum Types implements ISubEnum
    {
        slow_aging_1,
        slow_aging_2,
        slow_aging_3,
        producing_1,
        producing_2,
        producing_3,
        speed_crop_1,
        speed_crop_2,
        speed_crop_3,
        speed_birth_rate_1,
        speed_birth_rate_2,
        speed_birth_rate_3,
        chance_crossing_1,
        chance_crossing_2,
        chance_crossing_3,
        storage_jelly_1,
        storage_jelly_2,
        storage_jelly_3,
        storage_food_1,
        storage_food_2,
        storage_food_3,
        chance_healing_1,
        chance_healing_2,
        chance_healing_3;

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        private Types() {
            this.ID = this.ordinal();
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "frame";
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

