/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.items.CapabilityFluidHandlerItem;
import com.denfop.items.ItemFluidContainer;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.KeyboardIU;
import com.denfop.utils.Localization;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemReinforcedFluidCell
extends ItemFluidContainer {
    public ItemReinforcedFluidCell() {
        super(new Item.Properties().setNoRepair().m_41487_(1).m_41491_(IUCore.fluidCellTab), 10000);
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return true;
    }

    public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.m_220152_(p_41391_)) {
            p_41392_.addAll(this.getAllStacks());
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, list, tooltipFlag);
        if (!KeyboardIU.isKeyDown(340)) {
            list.add((Component)Component.m_237113_((String)Localization.translate("press.lshift")));
        }
        if (KeyboardIU.isKeyDown(340)) {
            list.add((Component)Component.m_237113_((String)Localization.translate("iu.fluid_cell.info")));
        }
    }

    @Override
    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, CompoundTag nbt) {
        return new CapabilityFluidHandlerItem(stack, 10000){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && ItemReinforcedFluidCell.this.canfill(fluid.getFluid());
            }

            public boolean canDrainFluidType(FluidStack fluid) {
                return fluid != null && ItemReinforcedFluidCell.this.canfill(fluid.getFluid());
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
                if (resource == null) {
                    return 0;
                }
                return super.fill(resource, doFill);
            }

            @NotNull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
                return super.drain(maxDrain, doDrain);
            }

            @NotNull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
                if (resource == FluidStack.EMPTY) {
                    return FluidStack.EMPTY;
                }
                return super.drain(resource, doDrain);
            }

            @NotNull
            public ItemStack getContainer() {
                return this.getFluid() == FluidStack.EMPTY ? new ItemStack((ItemLike)this.container.m_41720_()) : this.container;
            }
        };
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        BlockHitResult blockhitresult;
        ItemStack itemstack = player.m_21120_(hand);
        IFluidHandlerItem fs = (IFluidHandlerItem)itemstack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse(null);
        if (fs == null) {
            fs = (IFluidHandlerItem)this.initCapabilities(itemstack, itemstack.m_41784_());
        }
        if ((blockhitresult = ItemReinforcedFluidCell.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)(fs.getFluidInTank(0).getFluid() == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE))).m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.m_82425_();
        Direction direction = blockhitresult.m_82434_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        if (world.m_7966_(player, blockpos) && player.m_36204_(blockpos1, direction, itemstack)) {
            BlockState state;
            BlockState blockState = state = fs.getFluidInTank(0).isEmpty() ? world.m_8055_(blockpos) : world.m_8055_(blockpos1);
            if (fs.getFluidInTank(0).getFluid() != Fluids.f_76191_ && !state.m_60767_().m_76332_() && fs.getFluidInTank(0).getAmount() >= 1000) {
                BlockPos blockpos2;
                Fluid fluid = fs.getFluidInTank(0).getFluid();
                boolean flag1 = world.m_8055_(blockpos).m_60722_(Fluids.f_76191_);
                BlockPos blockPos = blockpos2 = flag1 && blockhitresult.m_82434_() == Direction.UP ? blockpos : blockpos.m_121955_(blockhitresult.m_82434_().m_122436_());
                if (this.tryPlaceContainedLiquid(new FluidStack(fluid, 1000), player, world, blockpos2)) {
                    fs.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)world.f_46443_);
                }
            } else {
                BlockState block = state;
                if (block.m_60767_().m_76332_()) {
                    FluidState fluidState = block.m_60734_().m_5888_(block);
                    if (!fluidState.m_76170_()) {
                        return InteractionResultHolder.m_19100_((Object)itemstack);
                    }
                    FluidStack ret = new FluidStack(fluidState.m_76152_(), 1000);
                    FluidHandlerFix.getFluidHandler(itemstack).fill(ret, IFluidHandler.FluidAction.EXECUTE);
                    world.m_7731_(blockpos1, Blocks.f_50016_.m_49966_(), 3);
                    return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)world.f_46443_);
                }
            }
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public boolean tryPlaceContainedLiquid(FluidStack fs, @javax.annotation.Nullable Player player, Level worldIn, BlockPos posIn) {
        Block containedBlock = fs.getFluid() == Fluids.f_76193_ ? Blocks.f_49990_ : (fs.getFluid() == Fluids.f_76195_ ? Blocks.f_49991_ : fs.getFluid().m_76145_().m_76188_().m_60734_());
        if (containedBlock == Blocks.f_50016_) {
            return false;
        }
        BlockState iblockstate = worldIn.m_8055_(posIn);
        boolean flag1 = iblockstate.m_60722_(Fluids.f_76191_);
        if (iblockstate.m_60767_().m_76332_()) {
            return false;
        }
        if (!iblockstate.m_60795_() && !flag1) {
            return false;
        }
        if (worldIn.m_46472_() == Level.f_46429_ && containedBlock == Blocks.f_49990_) {
            int l = posIn.m_123341_();
            int i = posIn.m_123342_();
            int j = posIn.m_123343_();
            worldIn.m_5594_(player, posIn, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (worldIn.f_46441_.m_188501_() - worldIn.f_46441_.m_188501_()) * 0.8f);
            for (int k = 0; k < 8; ++k) {
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!worldIn.f_46443_ && flag1 && !iblockstate.m_60767_().m_76332_()) {
                worldIn.m_46961_(posIn, true);
            }
            SoundEvent soundevent = containedBlock == Blocks.f_49991_ ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
            worldIn.m_5594_(player, posIn, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            worldIn.m_7731_(posIn, fs.getFluid().m_76145_().m_76188_(), 11);
        }
        fs.grow(-1000);
        return true;
    }
}

