/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.api.steam.ISteamBlade;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemSteamRod
extends ItemDamage
implements ISteamBlade {
    private final double percent;
    private final int level;
    private final ResourceLocation resourceLocation;

    public ItemSteamRod(int level, double percent, int damage, ResourceLocation resourceLocation) {
        super(new Item.Properties().m_41491_(IUCore.ItemTab).m_41487_(1), damage);
        this.percent = percent;
        this.level = level;
        this.resourceLocation = resourceLocation;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public double getCoef() {
        return this.percent;
    }

    @Override
    public boolean damageBlade(ItemStack stack) {
        return this.applyCustomDamage(stack, 1, null);
    }

    @Override
    public ResourceLocation getTexture() {
        return this.resourceLocation;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        double hours = 0.0;
        double minutes = 0.0;
        double seconds = 0.0;
        List<Double> time = ModUtils.Time(this.getMaxCustomDamage(stack) - this.getCustomDamage(stack));
        if (time.size() > 0) {
            hours = time.get(0);
            minutes = time.get(1);
            seconds = time.get(2);
        }
        String time1 = hours > 0.0 ? ModUtils.getString(hours) + Localization.translate("iu.hour") : "";
        String time2 = minutes > 0.0 ? ModUtils.getString(minutes) + Localization.translate("iu.minutes") : "";
        String time3 = seconds > 0.0 ? ModUtils.getString(seconds) + Localization.translate("iu.seconds") : "";
        tooltip.add((Component)Component.m_237113_((String)(Localization.translate("iu.timetoend") + time1 + time2 + time3)));
        tooltip.add((Component)Component.m_237115_((String)"iu.reactoritem.durability").m_130946_(" " + (this.getMaxCustomDamage(stack) - this.getCustomDamage(stack)) + "/" + this.getMaxCustomDamage(stack)));
        tooltip.add((Component)Component.m_237115_((String)"reactor.component_level").m_130946_(String.valueOf(this.level + 1)));
    }
}

