/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.upgrades.EnumBlockEntityUpgrade;
import com.denfop.api.upgrades.UpgradeItem;
import com.denfop.blocks.ISubEnum;
import com.denfop.containermenu.ContainerMenuUpgrade;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.ItemMain;
import com.denfop.items.ItemStackUpgradeModules;
import com.denfop.items.bags.BagsDescription;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.IUpdatableItemStackEvent;
import com.denfop.utils.ModUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class ItemUpgradeModule<T extends Enum<T>>
extends ItemMain<T>
implements UpgradeItem,
IItemStackInventory,
IUpdatableItemStackEvent {
    public ItemUpgradeModule(T element) {
        super(new Item.Properties().m_41491_(IUCore.UpgradeTab), element);
    }

    public static Type getType(int meta) {
        if (meta < 0 || meta >= Type.Values.length) {
            return null;
        }
        return Type.Values[meta];
    }

    private static Direction getDirection(ItemStack stack) {
        byte rawDir = ModUtils.nbt(stack).m_128445_("dir");
        if (rawDir < 1 || rawDir > 6) {
            return null;
        }
        return Direction.values()[rawDir - 1];
    }

    private static String getSideName(ItemStack stack) {
        Direction dir = ItemUpgradeModule.getDirection(stack);
        if (dir == null) {
            return "iu.tooltip.upgrade.ejector.anyside";
        }
        switch (dir) {
            case WEST: {
                return "iu.dir.west";
            }
            case EAST: {
                return "iu.dir.east";
            }
            case DOWN: {
                return "iu.dir.bottom";
            }
            case UP: {
                return "iu.dir.top";
            }
            case NORTH: {
                return "iu.dir.north";
            }
            case SOUTH: {
                return "iu.dir.south";
            }
        }
        throw new RuntimeException("invalid dir: " + dir);
    }

    @Override
    public CustomWorldContainer getInventory(Player var1, ItemStack var2) {
        if (((ISubEnum)this.getElement()).getId() < 11) {
            return null;
        }
        return new ItemStackUpgradeModules(var1, var2);
    }

    public void save(ItemStack stack, Player player) {
        CompoundTag nbt = ModUtils.nbt(stack);
        nbt.m_128379_("open", true);
        nbt.m_128405_("slot_inventory", player.m_150109_().f_35977_);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer buffer, ItemStack stack) {
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        ItemStackUpgradeModules toolbox;
        int slotId;
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128471_("open") && (slotId = nbt.m_128451_("slot_inventory")) != itemSlot && !world.f_46443_ && !stack.m_41619_() && player.f_36096_ instanceof ContainerMenuUpgrade && (toolbox = (ItemStackUpgradeModules)((ContainerMenuUpgrade)player.f_36096_).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.m_6915_();
            nbt.m_128379_("open", false);
        }
    }

    @Override
    public void updateEvent(int event, ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        byte event1 = (byte)event;
        nbt.m_128344_("dir", event1);
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, @Nonnull Player player) {
        ItemStackUpgradeModules toolbox;
        if (!player.f_19853_.f_46443_ && !stack.m_41619_() && player.f_36096_ instanceof ContainerMenuUpgrade && (toolbox = (ItemStackUpgradeModules)((ContainerMenuUpgrade)player.f_36096_).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.m_6915_();
        }
        return true;
    }

    @Override
    public boolean isSuitableFor(ItemStack stack, Set<EnumBlockEntityUpgrade> types) {
        Type type = ItemUpgradeModule.getType(((ISubEnum)this.getElement()).getId());
        if (type == null) {
            return false;
        }
        switch (type) {
            case overclocker: 
            case Overclocker1: 
            case Overclocker2: {
                return types.contains((Object)EnumBlockEntityUpgrade.Processing);
            }
            case transformer: 
            case transformer1: 
            case transformer_simple: {
                return types.contains((Object)EnumBlockEntityUpgrade.Transformer);
            }
            case storage: 
            case adv_storage: 
            case imp_storage: 
            case per_storage: 
            case energy_storage: {
                return types.contains((Object)EnumBlockEntityUpgrade.EnergyStorage);
            }
            case ejector: {
                return types.contains((Object)EnumBlockEntityUpgrade.ItemExtract);
            }
            case pulling: {
                return types.contains((Object)EnumBlockEntityUpgrade.ItemInput);
            }
            case fluid_ejector: {
                return types.contains((Object)EnumBlockEntityUpgrade.FluidExtract);
            }
            case fluid_pulling: {
                return types.contains((Object)EnumBlockEntityUpgrade.FluidInput);
            }
        }
        return false;
    }

    @Override
    public int getExtraTier(ItemStack itemStack) {
        Type type = ItemUpgradeModule.getType(((ISubEnum)this.getElement()).getId());
        if (type == null) {
            return 0;
        }
        switch (type) {
            case transformer_simple: {
                return 1;
            }
            case transformer: {
                return 2;
            }
            case transformer1: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public double getProcessTimeMultiplier(ItemStack itemStack) {
        Type type = ItemUpgradeModule.getType(((ISubEnum)this.getElement()).getId());
        if (type == null) {
            return 1.0;
        }
        switch (type) {
            case overclocker: {
                return 0.8;
            }
            case Overclocker1: {
                return 0.6;
            }
            case Overclocker2: {
                return 0.4;
            }
        }
        return 1.0;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        if (!player.m_9236_().f_46443_) {
            this.save(stack, player);
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer();
            growingBuffer.writeByte(1);
            growingBuffer.flip();
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getInventory(player, player.m_21120_(hand)), buf -> buf.writeBytes((ByteBuf)growingBuffer));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        Type type = ItemUpgradeModule.getType(((ISubEnum)this.getElement()).getId());
        if (type == null) {
            return;
        }
        super.m_7373_(stack, world, tooltip, flag);
        switch (type) {
            case overclocker: 
            case Overclocker1: 
            case Overclocker2: {
                tooltip.add((Component)Component.m_237110_((String)"iu.tooltip.upgrade.overclocker.time", (Object[])new Object[]{String.format("%.2f", 100.0 * Math.pow(this.getProcessTimeMultiplier(stack), stack.m_41613_()))}));
                tooltip.add((Component)Component.m_237110_((String)"iu.tooltip.upgrade.overclocker.power", (Object[])new Object[]{String.format("%.2f", 100.0 * Math.pow(this.getEnergyDemandMultiplier(stack), stack.m_41613_()))}));
                break;
            }
            case ejector: 
            case fluid_ejector: {
                String side = ItemUpgradeModule.getSideName(stack);
                tooltip.add((Component)Component.m_237110_((String)"iu.tooltip.upgrade.ejector", (Object[])new Object[]{Component.m_237115_((String)side)}));
                if (type != Type.ejector) break;
                CompoundTag nbt = stack.m_41784_();
                ArrayList<BagsDescription> bags = new ArrayList<BagsDescription>();
                ListTag contentList = nbt.m_128437_("Items", 10);
                for (int i = 0; i < contentList.size(); ++i) {
                    ItemStack stack1;
                    CompoundTag slotNbt = contentList.m_128728_(i);
                    byte slot = slotNbt.m_128445_("Slot");
                    if (slot < 0 || slot >= 6 || (stack1 = ItemStack.m_41712_((CompoundTag)slotNbt)).m_41619_()) continue;
                    bags.add(new BagsDescription(stack1));
                }
                for (BagsDescription description : bags) {
                    tooltip.add((Component)Component.m_237113_((String)description.getStack().m_41786_().getString()).m_130940_(ChatFormatting.GREEN));
                }
                break;
            }
            case pulling: 
            case fluid_pulling: {
                String side = ItemUpgradeModule.getSideName(stack);
                tooltip.add((Component)Component.m_237110_((String)"iu.tooltip.upgrade.pulling", (Object[])new Object[]{Component.m_237115_((String)side)}));
                if (type != Type.pulling) break;
                CompoundTag nbt = stack.m_41784_();
                ArrayList<BagsDescription> bags = new ArrayList<BagsDescription>();
                ListTag contentList = nbt.m_128437_("Items", 10);
                for (int i = 0; i < contentList.size(); ++i) {
                    ItemStack stack1;
                    CompoundTag slotNbt = contentList.m_128728_(i);
                    byte slot = slotNbt.m_128445_("Slot");
                    if (slot < 0 || slot >= 6 || (stack1 = ItemStack.m_41712_((CompoundTag)slotNbt)).m_41619_()) continue;
                    bags.add(new BagsDescription(stack1));
                }
                for (BagsDescription description : bags) {
                    tooltip.add((Component)Component.m_237113_((String)description.getStack().m_41786_().getString()).m_130940_(ChatFormatting.GREEN));
                }
                break;
            }
            case transformer: 
            case transformer1: 
            case transformer_simple: {
                tooltip.add((Component)Component.m_237110_((String)"iu.tooltip.upgrade.transformer", (Object[])new Object[]{this.getExtraTier(stack) * stack.m_41613_()}));
                break;
            }
            case storage: 
            case adv_storage: 
            case imp_storage: 
            case per_storage: 
            case energy_storage: {
                tooltip.add((Component)Component.m_237110_((String)"iu.tooltip.upgrade.storage", (Object[])new Object[]{this.getExtraEnergyStorage(stack) * (double)ModUtils.getSize(stack)}));
            }
        }
    }

    @Override
    public double getExtraEnergyStorage(ItemStack stack) {
        Types type = (Types)this.getElement();
        if (type == null) {
            return 0.0;
        }
        switch (type) {
            case energy_storage: {
                return 10000.0;
            }
            case storageUpgrade: {
                return 100000.0;
            }
            case adv_storageUpgrade: {
                return 1000000.0;
            }
            case imp_storageUpgrade: {
                return 1.0E7;
            }
            case per_storageUpgrade: {
                return 1.0E8;
            }
        }
        return 0.0;
    }

    @Override
    public double getEnergyDemandMultiplier(ItemStack itemStack) {
        Type type = ItemUpgradeModule.getType(((ISubEnum)this.getElement()).getId());
        if (type == null) {
            return 1.0;
        }
        switch (type) {
            case overclocker: {
                return 1.11;
            }
            case Overclocker1: {
                return 1.3;
            }
            case Overclocker2: {
                return 1.5;
            }
        }
        return 1.0;
    }

    public static enum Type {
        Overclocker1,
        Overclocker2,
        transformer,
        transformer1,
        storage,
        adv_storage,
        imp_storage,
        per_storage,
        overclocker,
        transformer_simple,
        energy_storage,
        ejector,
        pulling,
        fluid_ejector,
        fluid_pulling;

        public static final Type[] Values;

        static {
            Values = Type.values();
        }
    }

    public static enum Types implements ISubEnum
    {
        overclockerUpgrade1(0),
        overclockerUpgrade2(1),
        transformerUpgrade1(2),
        transformerUpgrade2(3),
        storageUpgrade(4),
        adv_storageUpgrade(5),
        imp_storageUpgrade(6),
        per_storageUpgrade(7),
        overclocker(8),
        transformer(9),
        energy_storage(10),
        ejector(11),
        pulling(12),
        fluid_ejector(13),
        fluid_pulling(14);

        private final String name = this.name().toLowerCase();
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "upgrades";
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

