/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.api.item.armor.HazmatLike;
import com.denfop.damagesource.IUDamageSource;
import com.denfop.items.armour.ISpecialArmor;
import com.denfop.items.armour.ItemArmorUtility;
import com.denfop.items.armour.material.ArmorMaterials;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemAdvArmorHazmat
extends ItemArmorUtility
implements HazmatLike,
ISpecialArmor {
    public ItemAdvArmorHazmat(String name, EquipmentSlot type) {
        super(ArmorMaterials.HAZMAT, name, type);
        if (type == EquipmentSlot.FEET) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        this.armorName = name;
    }

    public static boolean hasCompleteHazmat(LivingEntity living) {
        ItemStack stack;
        EquipmentSlot slot2;
        HazmatLike hazmat;
        Iterator var1 = Arrays.stream(EquipmentSlot.values()).filter(slot -> slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND).iterator();
        do {
            if (!var1.hasNext()) {
                return true;
            }
            slot2 = (EquipmentSlot)var1.next();
            stack = living.m_6844_(slot2);
            if (!(stack.m_41720_() instanceof HazmatLike)) {
                return false;
            }
            hazmat = (HazmatLike)stack.m_41720_();
            if (hazmat.addsProtection(living, slot2, stack)) continue;
            return false;
        } while (!hazmat.fullyProtects(living, slot2, stack));
        return true;
    }

    public static boolean hazmatAbsorbs(DamageSource source) {
        return source == DamageSource.f_19305_ || source == DamageSource.f_19310_ || source == DamageSource.f_19308_ || source == DamageSource.f_19309_ || source == DamageSource.f_19307_ || source == IUDamageSource.radiation;
    }

    @Override
    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)Registry.f_122827_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        int suffix1 = this.f_40377_ == EquipmentSlot.LEGS ? 2 : 1;
        return "industrialupgrade:textures/armor/" + this.armorName + "_" + suffix1 + ".png";
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(LivingEntity player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (this.f_40377_ == EquipmentSlot.HEAD && ItemAdvArmorHazmat.hazmatAbsorbs(source) && ItemAdvArmorHazmat.hasCompleteHazmat(player)) {
            if (source == DamageSource.f_19305_ || source == DamageSource.f_19308_ || source == DamageSource.f_19309_) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 60, 1));
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, Integer.MAX_VALUE);
        }
        return this.f_40377_ == EquipmentSlot.FEET && source == DamageSource.f_19315_ ? new ISpecialArmor.ArmorProperties(10, damage < 8.0 ? 1.0 : 0.875, (armor.m_41776_() - armor.m_41773_() + 2) * 2 * 25) : new ISpecialArmor.ArmorProperties(0, 0.05, (armor.m_41776_() - armor.m_41773_() + 2) / 2 * 25);
    }

    @Override
    public void damageArmor(LivingEntity entity, ItemStack stack, DamageSource source, float damage, int slot) {
        if (!ItemAdvArmorHazmat.hazmatAbsorbs(source) || !ItemAdvArmorHazmat.hasCompleteHazmat(entity)) {
            int damageTotal = (int)(damage * 2.0f);
            if (this.f_40377_ == EquipmentSlot.FEET && source == DamageSource.f_19315_) {
                damageTotal = (int)((damage + 1.0f) / 2.0f);
            }
            if (entity instanceof ServerPlayer) {
                stack.m_220157_(damageTotal, entity.m_217043_(), (ServerPlayer)entity);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (!event.getEntity().m_9236_().m_5776_() && event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            ItemStack armor = (ItemStack)player.m_150109_().f_35975_.get(0);
            if (armor.m_41720_() == this) {
                int fallDamage = (int)event.getDistance() - 3;
                if (fallDamage >= 8) {
                    return;
                }
                int armorDamage = (fallDamage + 1) / 2;
                if (armorDamage <= armor.m_41776_() - armor.m_41773_() && armorDamage >= 0) {
                    armor.m_220157_(armorDamage, event.getEntity().m_217043_(), player);
                    event.setCanceled(true);
                }
            }
        }
    }

    public boolean isRepairable() {
        return true;
    }

    @Override
    public int getArmorDisplay(Player player, ItemStack armor, int slot) {
        return 1;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.f_46443_ && this.f_40377_ == EquipmentSlot.HEAD && player.m_6060_() && ItemAdvArmorHazmat.hasCompleteHazmat((LivingEntity)player)) {
            if (this.isInLava(player)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 20, 0, true, true));
            }
            player.m_20095_();
        }
    }

    public boolean isInLava(Player player) {
        int x = (int)Math.floor(player.m_20185_());
        int y = (int)Math.floor(player.m_20186_() + 0.02);
        int z = (int)Math.floor(player.m_20189_());
        BlockState state = player.m_9236_().m_8055_(new BlockPos(x, y, z));
        if (state.m_60734_() instanceof LiquidBlock && (state.m_60767_() == Material.f_76307_ || state.m_60767_() == Material.f_76309_)) {
            Integer level = (Integer)state.m_61143_((Property)LiquidBlock.f_54688_);
            if (level > 8) {
                level = 0;
            }
            float height = (float)(y + 1) - (float)level.intValue() / 9.0f;
            return player.m_20186_() < (double)height;
        }
        return false;
    }

    @Override
    public boolean addsProtection(LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getLevel() {
        return 2;
    }
}

