/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IUCore;
import com.denfop.api.item.energy.EnergyItem;
import com.denfop.items.BaseEnergyItem;
import com.denfop.items.IProperties;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemBattery
extends BaseEnergyItem
implements IProperties {
    private static final int maxLevel = 4;
    public final boolean wirelessCharge;

    public ItemBattery(double maxCharge, double transferLimit, int tier, boolean wirelessCharge) {
        super(maxCharge, transferLimit, tier);
        this.wirelessCharge = wirelessCharge;
        IUCore.proxy.addProperties(this);
    }

    public ItemBattery(double maxCharge, double transferLimit, int tier) {
        super(maxCharge, transferLimit, tier);
        this.wirelessCharge = false;
        IUCore.proxy.addProperties(this);
    }

    @Override
    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)Registry.f_122827_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (this.wirelessCharge) {
            int mode = ModUtils.NBTGetInteger(stack, "mode");
            if (mode > 4 || mode < 0) {
                mode = 0;
            }
            tooltip.add((Component)Component.m_237115_((String)"message.text.mode").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("message.battery.mode." + mode))).m_130940_(ChatFormatting.GREEN));
            if (!Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237115_((String)"press.lshift"));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"iu.changemode_key").m_7220_((Component)Component.m_237115_((String)"iu.changemode_rcm1")));
            }
        }
        super.m_7373_(stack, world, tooltip, flag);
    }

    @Override
    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_220152_(tab)) {
            ItemStack chargedItem = new ItemStack((ItemLike)this);
            ElectricItem.manager.charge(chargedItem, Double.MAX_VALUE, Integer.MAX_VALUE, true, false);
            items.add((Object)chargedItem);
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int slot, boolean isSelected) {
        Player player;
        block13: {
            block12: {
                if (!(entity instanceof Player)) break block12;
                player = (Player)entity;
                if (!world.f_46443_ && this.wirelessCharge) break block13;
            }
            return;
        }
        int mode = ModUtils.NBTGetInteger(itemStack, "mode");
        if (mode < 1 || mode > 4) {
            return;
        }
        if (world.m_46467_() % (long)(mode == 4 ? 40 : 10) == 0L) {
            boolean transferred = false;
            switch (mode) {
                case 1: {
                    transferred = this.chargeItems((Iterable<ItemStack>)player.m_150109_().f_35974_, itemStack);
                    break;
                }
                case 2: {
                    transferred = this.chargeItems((Iterable<ItemStack>)player.m_150109_().f_35974_, itemStack);
                    break;
                }
                case 3: {
                    transferred = this.chargeItems((Iterable<ItemStack>)player.m_150109_().f_35975_, itemStack);
                    break;
                }
                case 4: {
                    transferred = this.chargeItems((Iterable<ItemStack>)player.m_150109_().f_35975_, itemStack);
                    if (world.m_46467_() % 40L != 0L) break;
                    transferred |= this.chargeItems((Iterable<ItemStack>)player.m_150109_().f_35974_, itemStack);
                }
            }
            if (transferred) {
                player.f_36096_.m_38946_();
            }
        }
    }

    private boolean chargeItems(Iterable<ItemStack> inventory, ItemStack battery) {
        boolean transferred = false;
        for (ItemStack stack : inventory) {
            double transfer;
            if (stack.m_41619_() || !(stack.m_41720_() instanceof EnergyItem) || stack.m_41720_() instanceof ItemBattery || !((transfer = ElectricItem.manager.discharge(battery, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) > 0.0) || !((transfer = ElectricItem.manager.charge(stack, transfer, Integer.MAX_VALUE, true, false)) > 0.0)) continue;
            ElectricItem.manager.discharge(battery, transfer, Integer.MAX_VALUE, true, true, false);
            transferred = true;
        }
        return transferred;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack;
        if (!world.f_46443_ && this.wirelessCharge) {
            stack = player.m_21120_(hand);
            int mode = ModUtils.NBTGetInteger(stack, "mode");
            mode = (mode + 1) % 5;
            ModUtils.NBTSetInteger(stack, "mode", mode);
            player.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.GREEN + Localization.translate("message.text.mode") + ": " + Localization.translate("message.battery.mode." + mode))), true);
        }
        stack = player.m_21120_(hand);
        if (!world.f_46443_ && ModUtils.getSize(stack) == 1) {
            if (ElectricItem.manager.getCharge(stack) > 0.0) {
                boolean transferred = false;
                for (int i = 0; i < 9; ++i) {
                    double transfer;
                    ItemStack target = (ItemStack)player.m_150109_().f_35974_.get(i);
                    if (target.m_41619_() || !(target.m_41720_() instanceof EnergyItem) || target == stack || ElectricItem.manager.discharge(target, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, true, true) > 0.0 || !((transfer = ElectricItem.manager.discharge(stack, 2.0 * this.transferLimit, Integer.MAX_VALUE, true, true, true)) > 0.0) || !((transfer = ElectricItem.manager.charge(target, transfer, this.tier, true, false)) > 0.0)) continue;
                    ElectricItem.manager.discharge(stack, transfer, Integer.MAX_VALUE, true, true, false);
                    transferred = true;
                }
                if (transferred) {
                    player.f_36096_.m_38946_();
                }
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public String[] properties() {
        return new String[]{"level"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack stack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        double damage = ElectricItem.manager.getCharge(stack);
        double maxDamage = ElectricItem.manager.getMaxCharge(stack);
        return (float)((double)((int)(4.0 * damage / maxDamage)) * 0.25);
    }
}

