/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IUCore;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.item.upgrade.EnumUpgrades;
import com.denfop.api.item.upgrade.UpgradeItem;
import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.api.item.upgrade.event.EventItemLoad;
import com.denfop.items.BaseEnergyItem;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.energy.ContainerMenuMagnet;
import com.denfop.items.energy.ItemStackMagnet;
import com.denfop.mixin.invoker.LevelInvoker;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.IUpdatableItemStackEvent;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.KeyboardIU;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ItemMagnet
extends BaseEnergyItem
implements IItemStackInventory,
IUpdatableItemStackEvent,
UpgradeItem {
    private final int radius;

    public ItemMagnet(double maxCharge, double transferLimit, int tier, int radius) {
        super(maxCharge, transferLimit, tier);
        this.radius = radius;
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe(this, EnumUpgrades.MAGNET.list));
    }

    @Override
    public void updateField(String name, CustomPacketBuffer buffer, ItemStack stack) {
    }

    @Override
    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)Registry.f_122827_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu.energy." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public void updateEvent(int event, ItemStack stack) {
        CompoundTag nbt;
        nbt.m_128379_("white", !(nbt = ModUtils.nbt(stack)).m_128471_("white"));
    }

    public void m_6883_(ItemStack itemStack, Level p_77663_2_, Entity p_77663_3_, int slotIndex, boolean isCurrentItem) {
        ItemStackMagnet toolbox;
        int slotId;
        if (!(p_77663_3_ instanceof Player)) {
            return;
        }
        if (p_77663_2_.f_46443_) {
            return;
        }
        CompoundTag nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.m_128379_("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(p_77663_2_, this, itemStack));
        }
        Player player = (Player)p_77663_3_;
        int mode = ModUtils.NBTGetInteger(itemStack, "mode");
        if (mode != 0) {
            int radius1 = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SIZE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SIZE, (ItemStack)itemStack).number : 0;
            double energy = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, itemStack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)itemStack).number * 0.25 : 0.0);
            int radius = this.radius + radius1;
            AABB axisalignedbb = new AABB(player.m_20185_() - (double)radius, player.m_20186_() - (double)radius, player.m_20189_() - (double)radius, player.m_20185_() + (double)radius, p_77663_3_.m_20186_() + (double)radius, p_77663_3_.m_20189_() + (double)radius);
            LevelEntityGetter<Entity> list1 = ((LevelInvoker)p_77663_2_).getGetEntities();
            ArrayList list = Lists.newArrayList();
            list1.m_142232_(axisalignedbb, p_151522_ -> {
                if (p_151522_ instanceof ItemEntity) {
                    list.add(p_151522_);
                }
            });
            ItemStackMagnet inventory = (ItemStackMagnet)this.getInventory(player, itemStack);
            for (Entity entityinlist : list) {
                boolean zcoord;
                if (!(entityinlist instanceof ItemEntity)) continue;
                ItemEntity item = (ItemEntity)entityinlist;
                if (!ElectricItem.manager.canUse(itemStack, 200.0 * energy) || !this.canInsert(itemStack, ((ItemEntity)entityinlist).m_32055_(), inventory)) continue;
                if (mode == 1) {
                    item.m_19890_(p_77663_3_.m_20182_().f_82479_, p_77663_3_.m_20182_().f_82480_, p_77663_3_.m_20182_().f_82481_, 0.0f, 0.0f);
                    if (!player.m_9236_().f_46443_) {
                        ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundTeleportEntityPacket((Entity)item));
                    }
                    item.m_32010_(0);
                    ElectricItem.manager.use(itemStack, 200.0 * energy, (LivingEntity)player);
                    continue;
                }
                if (mode != 2) continue;
                boolean xcoord = item.m_20182_().f_82479_ + 2.0 >= p_77663_3_.m_20182_().f_82479_ && item.m_20182_().f_82479_ - 2.0 <= p_77663_3_.m_20182_().f_82479_;
                boolean bl = zcoord = item.m_20182_().f_82481_ + 2.0 >= p_77663_3_.m_20182_().f_82481_ && item.m_20182_().f_82481_ - 2.0 <= p_77663_3_.m_20182_().f_82481_;
                if (xcoord || zcoord) continue;
                item.m_20248_(p_77663_3_.m_20182_().f_82479_, p_77663_3_.m_20182_().f_82480_ - 1.0, p_77663_3_.m_20182_().f_82481_);
                item.m_32010_(10);
            }
        }
        ItemStack stack = itemStack;
        if (nbt.m_128471_("open") && (slotId = nbt.m_128451_("slot_inventory")) != slotIndex && !p_77663_2_.f_46443_ && !stack.m_41619_() && player.f_36096_ instanceof ContainerMenuMagnet && (toolbox = (ItemStackMagnet)((ContainerMenuMagnet)player.f_36096_).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.m_6915_();
            nbt.m_128379_("open", false);
        }
    }

    private boolean canInsert(ItemStack itemstack, ItemStack itemStack1, ItemStackMagnet inventory) {
        CompoundTag nbt = ModUtils.nbt(itemstack);
        boolean white = nbt.m_128471_("white");
        boolean can = false;
        if (white) {
            for (ItemStack stack1 : inventory.list) {
                if (stack1.m_41619_() || !stack1.m_150930_(itemStack1.m_41720_())) continue;
                can = true;
                break;
            }
        } else {
            for (ItemStack stack1 : inventory.list) {
                if (!stack1.m_41619_() && stack1.m_150930_(itemStack1.m_41720_())) {
                    can = false;
                    break;
                }
                can = true;
            }
        }
        return can;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player player, InteractionHand hand) {
        if (IUCore.keyboard.isChangeKeyDown(player) && !p_41432_.f_46443_) {
            int mode = ModUtils.NBTGetInteger(player.m_21120_(hand), "mode");
            if (++mode > 2 || mode < 0) {
                mode = 0;
            }
            ModUtils.NBTSetInteger(player.m_21120_(hand), "mode", mode);
            IUCore.proxy.messagePlayer(player, ChatFormatting.GREEN + Localization.translate("message.text.mode") + ": " + Localization.translate("message.magnet.mode." + mode));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
        }
        if (!p_41432_.f_46443_) {
            this.save(player.m_21120_(hand), player);
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer();
            growingBuffer.writeByte(1);
            growingBuffer.flip();
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getInventory(player, player.m_21120_(hand)), buf -> buf.writeBytes((ByteBuf)growingBuffer));
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    public void save(ItemStack stack, Player player) {
        CompoundTag nbt = ModUtils.nbt(stack);
        nbt.m_128379_("open", true);
        nbt.m_128405_("slot_inventory", player.m_150109_().f_35977_);
    }

    @Override
    public CustomWorldContainer getInventory(Player player, ItemStack stack) {
        return new ItemStackMagnet(player, stack, 0);
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, @Nonnull Player player) {
        ItemStackMagnet toolbox;
        if (!player.f_19853_.f_46443_ && !stack.m_41619_() && player.f_36096_ instanceof ContainerMenuMagnet && (toolbox = (ItemStackMagnet)((ContainerMenuMagnet)player.f_36096_).base).isThisContainer(stack)) {
            toolbox.saveAndThrow(stack);
            player.m_6915_();
        }
        return true;
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        int mode = ModUtils.NBTGetInteger(p_41421_, "mode");
        if (mode > 2 || mode < 0) {
            mode = 0;
        }
        p_41423_.add((Component)Component.m_237113_((String)(ChatFormatting.GREEN + Localization.translate("message.text.mode") + ": " + Localization.translate("message.magnet.mode." + mode))));
        int radius1 = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SIZE, p_41421_) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SIZE, (ItemStack)p_41421_).number : 0;
        p_41423_.add((Component)Component.m_237113_((String)(Localization.translate("iu.magnet.info") + (this.radius + radius1) + "x" + (this.radius + radius1))));
        if (!KeyboardIU.isKeyDown(340)) {
            p_41423_.add((Component)Component.m_237113_((String)Localization.translate("press.lshift")));
        }
        if (KeyboardIU.isKeyDown(340)) {
            p_41423_.add((Component)Component.m_237113_((String)(Localization.translate("iu.changemode_key") + Localization.translate("iu.changemode_rcm1"))));
        }
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return false;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.MAGNET.list;
    }
}

