/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.blocks.FluidName;
import com.denfop.items.CapabilityFluidHandlerItem;
import com.denfop.items.ItemFluidContainer;
import com.denfop.utils.Localization;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class ItemSprayer
extends ItemFluidContainer {
    public ItemSprayer() {
        super(8000, 1);
    }

    private static boolean canPlaceFoam(Level world, BlockPos pos, Target target) {
        if (target == Target.Any) {
            return world.m_8055_(pos).m_60767_().m_76336_();
        }
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, list, tooltipFlag);
        list.add((Component)Component.m_237113_((String)Localization.translate("iu.sprayer.info")));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_ && IUCore.keyboard.isChangeKeyDown(player)) {
            ItemStack stack = player.m_21120_(hand);
            CompoundTag nbtData = stack.m_41784_();
            int mode = nbtData.m_128451_("mode");
            mode = mode == 0 ? 1 : 0;
            nbtData.m_128405_("mode", mode);
            String sMode = mode == 0 ? "iu.tooltip.mode.normal" : "iu.tooltip.mode.single";
            player.m_5661_((Component)Component.m_237110_((String)"iu.tooltip.mode", (Object[])new Object[]{sMode}), true);
        }
        return super.m_7203_(world, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Target target;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        int maxFoamBlocks = 0;
        IFluidHandlerItem fs = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse((Object)((CapabilityFluidHandlerItem)this.initCapabilities(stack, stack.m_41783_())));
        FluidStack fluid = fs.getFluidInTank(0);
        if (!fluid.isEmpty() && fluid.getAmount() > 0) {
            maxFoamBlocks += fluid.getAmount() / this.getFluidPerFoam();
        }
        if (maxFoamBlocks == 0) {
            return InteractionResult.FAIL;
        }
        maxFoamBlocks = Math.min(maxFoamBlocks, this.getMaxFoamBlocks(stack));
        Target target2 = target = ItemSprayer.canPlaceFoam(world, pos, Target.Scaffold) ? Target.Scaffold : Target.Any;
        if (target == Target.Any) {
            pos = pos.m_121945_(side);
        }
        Vec3 viewVec = player.m_20154_();
        Direction playerViewFacing = Direction.m_122366_((double)viewVec.f_82479_, (double)viewVec.f_82480_, (double)viewVec.f_82481_);
        int amount = this.sprayFoam(world, pos, playerViewFacing.m_122424_(), target, maxFoamBlocks);
        if ((amount *= this.getFluidPerFoam()) > 0) {
            fs.drain(amount, IFluidHandler.FluidAction.EXECUTE);
            player.m_150109_().m_6836_(player.m_150109_().f_35977_, fs.getContainer());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int sprayFoam(Level world, BlockPos pos, Direction excludedDir, Target target, int maxFoamBlocks) {
        BlockPos cPos;
        if (!ItemSprayer.canPlaceFoam(world, pos, target)) {
            return 0;
        }
        ArrayDeque<BlockPos> toCheck = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        toCheck.add(pos);
        while ((cPos = (BlockPos)toCheck.poll()) != null && positions.size() < maxFoamBlocks) {
            if (!ItemSprayer.canPlaceFoam(world, cPos, target) || !positions.add(cPos)) continue;
            for (Direction dir : Direction.values()) {
                if (dir == excludedDir) continue;
                toCheck.add(cPos.m_121945_(dir));
            }
        }
        int failedPlacements = 0;
        for (BlockPos targetPos : positions) {
            if (world.m_7731_(targetPos, IUItem.foam.getDefaultState(), 3)) continue;
            ++failedPlacements;
        }
        return positions.size() - failedPlacements;
    }

    protected int getMaxFoamBlocks(ItemStack stack) {
        CompoundTag nbtData = stack.m_41784_();
        return nbtData.m_128451_("mode") == 0 ? 10 : 1;
    }

    protected int getFluidPerFoam() {
        return 100;
    }

    public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.m_220152_(p_41391_)) {
            p_41392_.add((Object)new ItemStack((ItemLike)this));
            p_41392_.add((Object)this.getItemStack((Fluid)FluidName.fluidconstruction_foam.getInstance().get()));
        }
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return fluid == FluidName.fluidconstruction_foam.getInstance().get();
    }

    private static enum Target {
        Any,
        Scaffold;

    }
}

