/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IUCore;
import com.denfop.items.energy.IUTiers;
import com.denfop.items.energy.ItemToolIU;
import com.denfop.items.energy.instruments.EnumTypeInstruments;
import com.denfop.utils.ExperienceUtils;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.denfop.utils.RetraceDiggingUtils;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class ItemSteelHammer
extends ItemToolIU {
    private final Set<BlockState> mineableBlocks;
    private final List<TagKey<Block>> item_tools;
    private final Set<Material> materials = EnumTypeInstruments.DRILL.getMaterials();

    public ItemSteelHammer() {
        super(2.0f, 8.0f, (TagKey<Block>)BlockTags.f_144282_, new Item.Properties().m_41491_(IUCore.EnergyTab).m_41487_(1).setNoRepair().m_41503_(IUTiers.IRON.m_6609_()), IUTiers.IRON);
        this.mineableBlocks = EnumTypeInstruments.DRILL.getMineableBlocks();
        this.item_tools = EnumTypeInstruments.DRILL.getListItems();
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(toolAction);
    }

    @Override
    public boolean m_8120_(ItemStack p_41456_) {
        return true;
    }

    @Override
    public int m_6473_() {
        return Tiers.IRON.m_6601_();
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237113_((String)Localization.translate("iu.hammer.info")));
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack stack, @Nonnull BlockPos pos, @Nonnull Player player) {
        Level world = player.f_19853_;
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        BlockHitResult mop = RetraceDiggingUtils.retrace(player);
        if (state.m_60795_()) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        byte aoe = 0;
        if (player.m_6144_() && mop.m_6662_() != HitResult.Type.MISS) {
            return this.breakBlock(world, block, mop, aoe, player, pos, stack);
        }
        return this.breakBlock(world, block, mop, (byte)(1 + aoe), player, pos, stack);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (this.mineableBlocks.contains(state)) {
            return true;
        }
        if (this.materials.contains(state.m_60767_())) {
            return true;
        }
        for (TagKey<Block> blockTagKey : this.item_tools) {
            if (!state.m_204336_(blockTagKey)) continue;
            return true;
        }
        return false;
    }

    public boolean m_8096_(BlockState p_150816_) {
        for (TagKey<Block> blockTagKey : this.item_tools) {
            if (!p_150816_.m_204336_(blockTagKey)) continue;
            return true;
        }
        return super.m_8096_(p_150816_);
    }

    private int getExperience(BlockState state, Level world, BlockPos pos_block, int fortune, ItemStack stack, Block localBlock) {
        int col = localBlock.getExpDrop(state, (LevelReader)world, world.f_46441_, pos_block, fortune, 0);
        return col;
    }

    public boolean breakBlock(Level level, Block block, BlockHitResult mop, byte modeItem, Player player, BlockPos pos, ItemStack stack) {
        if (stack.m_41773_() <= 0) {
            return false;
        }
        byte xRange = modeItem;
        byte yRange = modeItem;
        byte zRange = modeItem;
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        byte digDepth = 0;
        switch (mop.m_82434_()) {
            case DOWN: 
            case UP: {
                yRange = digDepth;
                break;
            }
            case NORTH: 
            case SOUTH: {
                zRange = digDepth;
                break;
            }
            case WEST: 
            case EAST: {
                xRange = digDepth;
            }
        }
        boolean silkTouch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) > 0;
        int fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack);
        fortune = Math.min(3, fortune);
        int yOffset = yRange > 0 ? yRange - 1 : 0;
        boolean breakBlocks = false;
        if (!player.m_150110_().f_35937_) {
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                for (int yPos = y - yRange + yOffset; yPos <= y + yRange + yOffset; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange && stack.m_41773_() > 0; ++zPos) {
                        BlockPos blockPos = new BlockPos(xPos, yPos, zPos);
                        BlockState state = level.m_8055_(blockPos);
                        Block localBlock = state.m_60734_();
                        if (localBlock == Blocks.f_50016_ || !this.isCorrectToolForDrops(stack, state) || !(state.m_60800_((BlockGetter)level, blockPos) >= 0.0f)) continue;
                        if (state.m_60800_((BlockGetter)level, blockPos) > 0.0f) {
                            boolean bl = breakBlocks = breakBlocks || this.m_6813_(stack, level, state, blockPos, (LivingEntity)player);
                        }
                        if (silkTouch) continue;
                        ExperienceUtils.addPlayerXP(player, this.getExperience(state, level, blockPos, fortune, stack, localBlock));
                    }
                }
            }
        } else if (stack.m_41773_() > 0) {
            BlockState state = level.m_8055_(pos);
            Block localBlock = state.m_60734_();
            if (localBlock != Blocks.f_50016_ && this.isCorrectToolForDrops(stack, state) && state.m_60800_((BlockGetter)level, pos) >= 0.0f || block == Blocks.f_50226_) {
                if (state.m_60800_((BlockGetter)level, pos) >= 0.0f) {
                    boolean bl = breakBlocks = breakBlocks || this.m_6813_(stack, level, state, pos, (LivingEntity)player);
                }
                if (!silkTouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, level, pos, fortune, stack, localBlock));
                }
            } else if (state.m_60800_((BlockGetter)level, pos) >= 0.0f) {
                return this.m_6813_(stack, level, state, pos, (LivingEntity)player);
            }
        }
        if (breakBlocks) {
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return state.m_204336_(BlockTags.f_144282_) || state.m_204336_(BlockTags.f_144283_) ? this.f_40980_ : 1.0f;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        Block block = state.m_60734_();
        if (state.m_60795_()) {
            return false;
        }
        if (block instanceof LiquidBlock || state.m_60800_((BlockGetter)world, pos) == -1.0f && !player.m_7500_()) {
            return false;
        }
        if (!world.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)world;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (ForgeHooks.onBlockBreakEvent((Level)serverWorld, (GameType)serverPlayer.f_8941_.m_9290_(), (ServerPlayer)serverPlayer, (BlockPos)pos) == -1) {
                return false;
            }
            BlockEntity blockEntity = world.m_7702_(pos);
            if (block.onDestroyedByPlayer(state, world, pos, (Player)((ServerPlayer)entity), true, world.m_6425_(pos))) {
                block.m_6786_((LevelAccessor)world, pos, state);
                block.m_6240_(world, (Player)((ServerPlayer)entity), pos, state, blockEntity, stack);
                List items = world.m_45976_(ItemEntity.class, new AABB(pos.m_7918_(-1, -1, -1), pos.m_7918_(1, 1, 1)));
                serverPlayer.m_36399_(-0.025f);
                if (ModUtils.getOre(block)) {
                    for (ItemEntity item : items) {
                        if (world.f_46443_) continue;
                        item.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                        item.m_32010_(0);
                    }
                } else if (ModUtils.nbt(stack).m_128471_("black")) {
                    for (ItemEntity item : items) {
                        if (world.f_46443_) continue;
                        item.m_146870_();
                    }
                }
            }
        } else {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (block.onDestroyedByPlayer(state, world, pos, (Player)entity, true, world.m_6425_(pos))) {
                block.m_6786_((LevelAccessor)world, pos, state);
                block.m_6240_(world, (Player)entity, pos, state, blockEntity, stack);
            }
        }
        return true;
    }
}

