/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.relocator;

import com.denfop.items.relocator.Point;
import com.denfop.network.packet.PacketSynhronyzationRelocator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RelocatorNetwork {
    public static RelocatorNetwork instance;
    Map<ResourceKey<Level>, Map<UUID, List<Point>>> worldDataPoints = new ConcurrentHashMap<ResourceKey<Level>, Map<UUID, List<Point>>>();

    public static void init() {
        if (instance == null) {
            instance = new RelocatorNetwork();
        }
    }

    public Map<ResourceKey<Level>, Map<UUID, List<Point>>> getWorldDataPoints() {
        return this.worldDataPoints;
    }

    public void addPoint(Player player, Point point) {
        Map map = this.worldDataPoints.computeIfAbsent((ResourceKey<Level>)player.m_9236_().m_46472_(), k -> new ConcurrentHashMap());
        List list = map.computeIfAbsent(player.m_20148_(), k -> new LinkedList());
        list.add(point);
        new PacketSynhronyzationRelocator(player, list);
    }

    public void addPoints(Player player, ResourceKey<Level> levelKey, List<Point> points) {
        Map map = this.worldDataPoints.computeIfAbsent(levelKey, k -> new ConcurrentHashMap());
        map.put(player.m_20148_(), points);
    }

    public void addPoints(Player player, List<Point> points) {
        Map map = this.worldDataPoints.computeIfAbsent((ResourceKey<Level>)player.m_9236_().m_46472_(), k -> new ConcurrentHashMap());
        map.put(player.m_20148_(), points);
    }

    public void removePoint(Player player, Point point) {
        Map map = this.worldDataPoints.computeIfAbsent((ResourceKey<Level>)player.m_9236_().m_46472_(), k -> new HashMap());
        List list = map.computeIfAbsent(player.m_20148_(), k -> new LinkedList());
        list.removeIf(point1 -> point1.getName().equals(point.getName()));
        new PacketSynhronyzationRelocator(player, list);
    }

    public void teleportPlayer(Player player, Point point) {
        if (!player.m_9236_().m_5776_()) {
            double x = (double)point.getPos().m_123341_() + 0.5;
            double y = point.getPos().m_123342_();
            double z = (double)point.getPos().m_123343_() + 0.5;
            player.m_6021_(x, y, z);
            player.f_19789_ = 0.0f;
        }
    }

    public List<Point> getPoints(Player player) {
        Map map = this.worldDataPoints.computeIfAbsent((ResourceKey<Level>)player.m_9236_().m_46472_(), k -> new HashMap());
        return map.computeIfAbsent(player.m_20148_(), k -> new LinkedList());
    }

    public void onUnload() {
        this.worldDataPoints.clear();
    }
}

