/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.mixin;

import com.denfop.blockentity.base.BlockEntityBase;
import com.mojang.logging.LogUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class MixinServerGamePacketListenerImpl {
    @Shadow
    static final Logger f_9744_ = LogUtils.getLogger();
    @Shadow
    public ServerPlayer f_9743_;
    @Shadow
    private Vec3 f_9766_;

    private static boolean wasBlockPlacementAttempt(ServerPlayer pPlayer, ItemStack pStack) {
        if (pStack.m_41619_()) {
            return false;
        }
        Item item = pStack.m_41720_();
        return (item instanceof BlockItem || item instanceof BucketItem) && !pPlayer.m_36335_().m_41519_(item);
    }

    private ServerGamePacketListenerImpl getSelf() {
        return (ServerGamePacketListenerImpl)this;
    }

    @Inject(method={"handleUseItemOn"}, at={@At(value="HEAD")})
    private void onHandleUseItemOn(ServerboundUseItemOnPacket pPacket, CallbackInfo ci) {
        PacketUtils.m_131359_((Packet)pPacket, (PacketListener)this.getSelf(), (ServerLevel)this.f_9743_.m_9236_());
        this.f_9743_.f_8906_.m_215201_(pPacket.m_238008_());
        ServerLevel serverlevel = this.f_9743_.m_9236_();
        InteractionHand interactionhand = pPacket.m_134703_();
        ItemStack itemstack = this.f_9743_.m_21120_(interactionhand);
        BlockHitResult blockhitresult = pPacket.m_134706_();
        Vec3 vec3 = blockhitresult.m_82450_();
        BlockPos blockpos = blockhitresult.m_82425_();
        Vec3 vec31 = Vec3.m_82512_((Vec3i)blockpos);
        if (this.f_9743_.canInteractWith(blockpos, 3.0)) {
            Vec3 vec32 = vec3.m_82546_(vec31);
            double d0 = 1.0000001;
            BlockEntity blockEntity = this.f_9743_.m_9236_().m_7702_(blockpos);
            if (blockEntity instanceof BlockEntityBase) {
                BlockEntityBase base = (BlockEntityBase)blockEntity;
                AABB aabb = base.getAabb(false);
                if (aabb.f_82291_ > 1.0 || aabb.f_82292_ > 1.0 && aabb.f_82293_ > 1.0) {
                    if ((Math.abs(vec32.m_7096_()) > 1.0 || Math.abs(vec32.m_7098_()) > 1.0 || Math.abs(vec32.m_7094_()) > 1.0) && Math.abs(vec32.m_7096_()) <= aabb.f_82291_ && Math.abs(vec32.m_7098_()) <= aabb.f_82292_ && Math.abs(vec32.m_7094_()) <= aabb.f_82293_) {
                        Direction direction = blockhitresult.m_82434_();
                        this.f_9743_.m_9243_();
                        int i = this.f_9743_.f_19853_.m_151558_();
                        if (blockpos.m_123342_() < i) {
                            if (this.f_9766_ == null && serverlevel.m_7966_((Player)this.f_9743_, blockpos)) {
                                InteractionResult interactionresult = this.f_9743_.f_8941_.m_7179_(this.f_9743_, (Level)serverlevel, itemstack, interactionhand, blockhitresult);
                                if (direction == Direction.UP && !interactionresult.m_19077_() && blockpos.m_123342_() >= i - 1 && MixinServerGamePacketListenerImpl.wasBlockPlacementAttempt(this.f_9743_, itemstack)) {
                                    MutableComponent component = Component.m_237110_((String)"build.tooHigh", (Object[])new Object[]{i - 1}).m_130940_(ChatFormatting.RED);
                                    this.f_9743_.m_240418_((Component)component, true);
                                } else if (interactionresult.m_19080_()) {
                                    this.f_9743_.m_21011_(interactionhand, true);
                                }
                            }
                        } else {
                            MutableComponent component1 = Component.m_237110_((String)"build.tooHigh", (Object[])new Object[]{i - 1}).m_130940_(ChatFormatting.RED);
                            this.f_9743_.m_240418_((Component)component1, true);
                        }
                        this.f_9743_.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)serverlevel, blockpos));
                        this.f_9743_.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)serverlevel, blockpos.m_121945_(direction)));
                    } else {
                        f_9744_.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.f_9743_.m_36316_().getName(), vec3, blockpos});
                    }
                }
            }
        }
    }
}

