/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.datagen.loader.VeinDataLoader;
import com.denfop.items.ItemVeinSensor;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.TypeVein;
import com.denfop.world.vein.VeinType;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class PacketUpdateVeinData
implements IPacket {
    public PacketUpdateVeinData() {
    }

    public PacketUpdateVeinData(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer();
        buffer.writeByte(this.getId());
        buffer.writeString(player.m_7755_().getString());
        buffer.writeInt(ItemVeinSensor.dataColors.size());
        for (Map.Entry<BlockState, Integer> entry : ItemVeinSensor.dataColors.entrySet()) {
            try {
                EncoderHandler.encode(buffer, entry.getKey().m_60734_());
                EncoderHandler.encode(buffer, entry.getValue());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        buffer.writeInt(VeinDataLoader.VEIN_DATA.size());
        for (Map.Entry<Object, Object> entry : VeinDataLoader.VEIN_DATA.entrySet()) {
            try {
                EncoderHandler.encode(buffer, entry.getKey());
                EncoderHandler.encode(buffer, ((VeinType)entry.getValue()).getDeposits().m_60734_());
                EncoderHandler.encode(buffer, ((VeinType)entry.getValue()).getOres().size());
                for (int i = 0; i < ((VeinType)entry.getValue()).getOres().size(); ++i) {
                    ChanceOre chanceOre = ((VeinType)entry.getValue()).getOres().get(i);
                    EncoderHandler.encode(buffer, chanceOre.getBlock().m_60734_());
                    EncoderHandler.encode(buffer, chanceOre.getChance());
                    EncoderHandler.encode(buffer, chanceOre.getMeta());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        IUCore.network.getServer().sendPacket(buffer, player);
    }

    @Override
    public byte getId() {
        return 75;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        if (!entityPlayer.m_7755_().getString().equals(customPacketBuffer.readString())) {
            return;
        }
        try {
            int i;
            int size = customPacketBuffer.readInt();
            for (i = 0; i < size; ++i) {
                Block block = (Block)DecoderHandler.decode(customPacketBuffer);
                Integer id = (Integer)DecoderHandler.decode(customPacketBuffer);
                if (ItemVeinSensor.dataColors.containsKey(block.m_49966_())) continue;
                ItemVeinSensor.dataColors.put(block.m_49966_(), id);
            }
            size = customPacketBuffer.readInt();
            for (i = 0; i < size; ++i) {
                ResourceLocation resourceLocation = (ResourceLocation)DecoderHandler.decode(customPacketBuffer);
                Block block = (Block)DecoderHandler.decode(customPacketBuffer);
                int size1 = (Integer)DecoderHandler.decode(customPacketBuffer);
                LinkedList<ChanceOre> list = new LinkedList<ChanceOre>();
                for (int i1 = 0; i1 < size1; ++i1) {
                    Block block1 = (Block)DecoderHandler.decode(customPacketBuffer);
                    int chance = (Integer)DecoderHandler.decode(customPacketBuffer);
                    int meta = (Integer)DecoderHandler.decode(customPacketBuffer);
                    list.add(new ChanceOre(block1.m_49966_(), chance, meta));
                }
                if (VeinDataLoader.VEIN_DATA.containsKey(resourceLocation)) continue;
                VeinType veinType = new VeinType(block.m_49966_(), TypeVein.SMALL, list);
                VeinDataLoader.VEIN_DATA.put(resourceLocation, veinType);
                for (ChanceOre chanceOre : veinType.getOres()) {
                    BlockState state = chanceOre.getBlock();
                    if (WorldBaseGen.idToblockStateMap.containsKey(state)) continue;
                    WorldBaseGen.idToblockStateMap.put(state, WorldBaseGen.id);
                    WorldBaseGen.blockStateMap.put(WorldBaseGen.id, state);
                    ++WorldBaseGen.id;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

