/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.api.Recipes;
import com.denfop.api.crafting.BaseRecipe;
import com.denfop.api.crafting.PartRecipe;
import com.denfop.api.crafting.RecipeGrid;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputItemStack;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class IndustrialShapedRecipeSerializer
implements RecipeSerializer<BaseRecipe> {
    public BaseRecipe fromJson(ResourceLocation id, JsonObject json) {
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        JsonArray patternArray = GsonHelper.m_13933_((JsonObject)json, (String)"pattern");
        ArrayList<String> pattern = new ArrayList<String>();
        for (JsonElement line : patternArray) {
            pattern.add(line.getAsString());
        }
        RecipeGrid grid = new RecipeGrid(pattern);
        JsonObject keyJson = GsonHelper.m_13930_((JsonObject)json, (String)"key");
        ArrayList<PartRecipe> partRecipes = new ArrayList<PartRecipe>();
        for (Map.Entry entry : keyJson.entrySet()) {
            String symbol = (String)entry.getKey();
            if (symbol.length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + symbol + "' is not a single character.");
            }
            char character = symbol.charAt(0);
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue()));
            IInputItemStack input = Recipes.inputFactory.getInput(ingredient);
            partRecipes.add(new PartRecipe(String.valueOf(character), input));
        }
        JsonObject resultJson = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        ItemStack result = ShapedRecipe.m_151274_((JsonObject)resultJson);
        return new BaseRecipe(id, group, result, grid, partRecipes);
    }

    @Nullable
    public BaseRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf pBuffer) {
        return BaseRecipe.create(id, new CustomPacketBuffer((ByteBuf)pBuffer));
    }

    public void toNetwork(FriendlyByteBuf buf, BaseRecipe recipe) {
        recipe.toNetwork(buf);
    }
}

