/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.componets.Fluids;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.FluidHandlerFix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class InputFluidStack
implements IInputItemStack {
    private static volatile FluidHandlerInfo fluidHandlerInfo = new FluidHandlerInfo(Collections.emptyList());
    private final Fluid fluid;
    private final int amount;

    public InputFluidStack(CompoundTag compoundTag) {
        boolean exist = compoundTag.m_128471_("exist");
        if (exist) {
            ResourceLocation fluidId = new ResourceLocation(compoundTag.m_128461_("Fluid"));
            this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
            this.amount = compoundTag.m_128451_("Amount");
        } else {
            this.fluid = Fluids.EMPTY;
            this.amount = 1;
        }
    }

    public InputFluidStack(Fluid fluid) {
        this(fluid, 1000);
    }

    public InputFluidStack(FluidStack fluid) {
        this(fluid.getFluid(), fluid.getAmount());
    }

    public InputFluidStack(Fluid fluid, int amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    public InputFluidStack(FriendlyByteBuf buffer) {
        this(buffer.readFluidStack());
    }

    public static List<ItemStack> getFluidContainer(Fluid fluid) {
        ItemStack container;
        IFluidHandlerItem handler;
        FluidHandlerInfo info = fluidHandlerInfo;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (Item item : ForgeRegistries.ITEMS) {
            ItemStack stack = new ItemStack((ItemLike)item);
            handler = FluidHandlerFix.getFluidHandler(stack);
            if (handler == null) continue;
            handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            container = handler.getContainer();
            if (FluidUtil.getFluidContained((ItemStack)container).orElse(null) != null) continue;
            ret.add(stack);
        }
        fluidHandlerInfo = info = new FluidHandlerInfo(Collections.unmodifiableList(ret));
        if (fluid == null) {
            return info.items;
        }
        ret = new ArrayList();
        for (ItemStack stack : info.items) {
            handler = FluidHandlerFix.getFluidHandler(stack);
            if (handler == null || handler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE) <= 0) continue;
            container = handler.getContainer();
            if (handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).isEmpty()) continue;
            ret.add(container);
        }
        return ret;
    }

    @Override
    public CompoundTag writeNBT() {
        ResourceLocation fluidId;
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128344_("id", (byte)2);
        compoundTag.m_128379_("exist", this.fluid != null && !this.fluid.equals(Fluids.EMPTY) && this.amount != 0);
        if (this.fluid != null && !this.fluid.equals(Fluids.EMPTY) && (fluidId = ForgeRegistries.FLUIDS.getKey((Object)this.fluid)) != null) {
            compoundTag.m_128359_("Fluid", fluidId.toString());
            compoundTag.m_128405_("Amount", this.amount);
        }
        return null;
    }

    @Override
    public boolean matches(ItemStack subject) {
        Optional fs1 = FluidUtil.getFluidContained((ItemStack)subject);
        FluidStack fs = fs1.orElse(null);
        return fs == null && this.fluid == null || fs != null && fs.getFluid() == this.fluid && fs.getAmount() >= this.amount;
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public List<ItemStack> getInputs() {
        return InputFluidStack.getFluidContainer(this.fluid);
    }

    @Override
    public boolean hasTag() {
        return false;
    }

    @Override
    public TagKey<Item> getTag() {
        return null;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeInt(2);
        buffer.writeFluidStack(new FluidStack(this.fluid, 1000));
    }

    @Override
    public void growAmount(int count) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (this.getClass() != obj.getClass()) return false;
        InputFluidStack other = (InputFluidStack)obj;
        if (other.fluid != this.fluid) return false;
        if (other.amount != this.amount) return false;
        return true;
    }

    public FluidStack getFluid() {
        return new FluidStack(this.fluid, this.amount);
    }

    private static class FluidHandlerInfo {
        final List<ItemStack> items;

        FluidHandlerInfo(List<ItemStack> items) {
            this.items = items;
        }
    }
}

