/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.Recipes;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.universalrecipe.IURecipeDelete;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class IURecipeDeleteSerializer
implements RecipeSerializer<IURecipeDelete> {
    public static final IURecipeDeleteSerializer INSTANCE = new IURecipeDeleteSerializer();

    public IURecipeDelete fromJson(ResourceLocation id, JsonObject json) {
        String recipeType = GsonHelper.m_13906_((JsonObject)json, (String)"recipe_type");
        boolean isFluidRecipe = GsonHelper.m_13855_((JsonObject)json, (String)"isFluidRecipe", (boolean)false);
        boolean removeAll = GsonHelper.m_13855_((JsonObject)json, (String)"isRemoveAll", (boolean)false);
        ArrayList<ItemStack> outputs1 = new ArrayList<ItemStack>();
        ArrayList<FluidStack> outputsFluid = new ArrayList<FluidStack>();
        JsonArray outArr = GsonHelper.m_13933_((JsonObject)json, (String)"output");
        block8: for (JsonElement el : outArr) {
            JsonObject obj = el.getAsJsonObject();
            String itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
            String type = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
            int amount = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
            switch (type) {
                case "item": {
                    ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), amount);
                    outputs1.add(new InputItemStack((ItemStack)stack).input);
                    continue block8;
                }
                case "fluid": {
                    FluidStack fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(itemId)), amount);
                    outputsFluid.add(fluidStack);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown input type: " + type);
        }
        if (isFluidRecipe && !outputsFluid.isEmpty()) {
            Recipes.recipes.addFluidRemoveRecipe(recipeType, (FluidStack)outputsFluid.get(0), removeAll);
        }
        if (!outputs1.isEmpty()) {
            Recipes.recipes.addRemoveRecipe(recipeType, (ItemStack)outputs1.get(0), removeAll);
        }
        return new IURecipeDelete(id, recipeType, isFluidRecipe, new ArrayList<IInputItemStack>(), removeAll);
    }

    public IURecipeDelete fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        return new IURecipeDelete(id, "", false, new ArrayList<IInputItemStack>(), false);
    }

    public void toNetwork(FriendlyByteBuf buf, IURecipeDelete recipe) {
    }
}

