/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.EnumType;
import com.denfop.api.space.IPlanet;
import com.denfop.api.space.Satellite;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.recipe.universalrecipe.PlanetSerializer;
import com.denfop.recipe.universalrecipe.SatelliteRecipe;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SatelliteSerializer
implements RecipeSerializer<SatelliteRecipe> {
    public static final SatelliteSerializer INSTANCE = new SatelliteSerializer();

    public SatelliteRecipe fromJson(ResourceLocation id, JsonObject json) {
        String name = json.get("name").getAsString();
        String systemStr = json.get("system").getAsString().toLowerCase();
        String textureStr = json.get("texture").getAsString();
        EnumLevels level = EnumLevels.valueOf(json.get("level").getAsString().toUpperCase());
        String planetStr = json.get("planet").getAsString();
        int temperature = json.get("temperature").getAsInt();
        boolean pressure = json.get("pressure").getAsBoolean();
        double distance = json.get("distance").getAsDouble();
        EnumType type = EnumType.valueOf(json.get("type").getAsString().toUpperCase());
        boolean oxygen = json.get("oxygen").getAsBoolean();
        boolean colonies = json.get("colonies").getAsBoolean();
        int angle = json.get("angle").getAsInt();
        double time = json.get("time").getAsDouble();
        double size = json.get("size").getAsDouble();
        double rotation = json.get("rotation").getAsDouble();
        ResourceLocation texture = ResourceLocation.m_135820_((String)(textureStr + ".png"));
        if (!PlanetSerializer.stringList.contains("satellite_" + name)) {
            SpaceInit.regSatellite.add(() -> new Satellite(name, SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemStr.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemStr)), texture, level, (IPlanet)SpaceNet.instance.getBodyFromName(planetStr), temperature, pressure, distance, type, oxygen, colonies, angle, time, size, rotation));
            PlanetSerializer.stringList.add("satellite_" + name);
        }
        return new SatelliteRecipe(id, name, systemStr, textureStr, level, planetStr, temperature, pressure, distance, type, oxygen, colonies, angle, time, size, rotation);
    }

    public SatelliteRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        String name = buf.m_130277_();
        String systemName = buf.m_130277_();
        String texturePath = buf.m_130277_();
        EnumLevels level = EnumLevels.valueOf(buf.m_130277_().toUpperCase());
        String planetName = buf.m_130277_();
        int temperature = buf.m_130242_();
        boolean pressure = buf.readBoolean();
        double distance = buf.readDouble();
        EnumType type = EnumType.valueOf(buf.m_130277_().toUpperCase());
        boolean oxygen = buf.readBoolean();
        boolean colonies = buf.readBoolean();
        int angle = buf.m_130242_();
        double time = buf.readDouble();
        double size = buf.readDouble();
        double rotation = buf.readDouble();
        ResourceLocation texture = ResourceLocation.m_135820_((String)(texturePath + ".png"));
        if (!PlanetSerializer.stringList.contains("satellite_" + name)) {
            SpaceInit.regSatellite.add(() -> new Satellite(name, SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemName.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemName)), texture, level, (IPlanet)SpaceNet.instance.getBodyFromName(planetName), temperature, pressure, distance, type, oxygen, colonies, angle, time, size, rotation));
            PlanetSerializer.stringList.add("satellite_" + name);
        }
        return new SatelliteRecipe(id, name, systemName, texturePath, level, planetName, temperature, pressure, distance, type, oxygen, colonies, angle, time, size, rotation);
    }

    public void toNetwork(FriendlyByteBuf buf, SatelliteRecipe recipe) {
        buf.m_130070_(recipe.name);
        buf.m_130070_(recipe.systemName);
        buf.m_130070_(recipe.texturePath);
        buf.m_130070_(recipe.level.name());
        buf.m_130070_(recipe.planetName);
        buf.m_130130_(recipe.temperature.intValue());
        buf.writeBoolean(recipe.pressure.booleanValue());
        buf.writeDouble(recipe.distance.doubleValue());
        buf.m_130070_(recipe.type.name());
        buf.writeBoolean(recipe.oxygen.booleanValue());
        buf.writeBoolean(recipe.colonies.booleanValue());
        buf.m_130130_(recipe.angle.intValue());
        buf.writeDouble(recipe.time.doubleValue());
        buf.writeDouble(recipe.size.doubleValue());
        buf.writeDouble(recipe.rotation.doubleValue());
    }
}

