/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.IUCore;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.blockentity.smeltery.BlockEntitySmelteryController;
import com.denfop.blockentity.smeltery.BlockEntitySmelteryFurnace;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipe.universalrecipe.SmelteryRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class SmelterSerializer
implements RecipeSerializer<SmelteryRecipe> {
    public static final SmelterSerializer INSTANCE = new SmelterSerializer();
    public static List<ResourceLocation> resourceLocations = new LinkedList<ResourceLocation>();

    public SmelteryRecipe fromJson(ResourceLocation id, JsonObject json) {
        String operation = GsonHelper.m_13906_((JsonObject)json, (String)"operation");
        if (resourceLocations.contains(id)) {
            return new SmelteryRecipe(id, "", new LinkedList<IInputItemStack>(), new LinkedList<IInputItemStack>());
        }
        ArrayList<IInputItemStack> inputs = new ArrayList<IInputItemStack>();
        ArrayList<IInputItemStack> outputs = new ArrayList<IInputItemStack>();
        switch (operation) {
            case "furnace": {
                JsonArray inArray;
                Iterator el3;
                JsonArray inArray2;
                Iterator iterator;
                ItemStack stack = null;
                if (GsonHelper.m_13900_((JsonObject)json, (String)"inputs") && (iterator = (inArray2 = GsonHelper.m_13933_((JsonObject)json, (String)"inputs")).iterator()).hasNext()) {
                    el3 = (JsonElement)iterator.next();
                    JsonObject obj = el3.getAsJsonObject();
                    String itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                    int amount = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
                    stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), amount);
                    inputs.add(new InputItemStack(stack));
                }
                FluidStack fluidStack = null;
                if (GsonHelper.m_13900_((JsonObject)json, (String)"outputs") && (el3 = (inArray = GsonHelper.m_13933_((JsonObject)json, (String)"outputs")).iterator()).hasNext()) {
                    JsonElement el2 = (JsonElement)el3.next();
                    JsonObject obj = el2.getAsJsonObject();
                    String itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                    int amount = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
                    fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(itemId)), amount);
                    outputs.add(new InputFluidStack(fluidStack));
                }
                if (stack == null || fluidStack == null) break;
                BlockEntitySmelteryFurnace.addRecipe("", stack, fluidStack);
                break;
            }
            case "castings_ingot": {
                int amount;
                String itemId;
                JsonObject obj;
                JsonElement el;
                JsonArray inArray;
                Iterator el3;
                ItemStack stack = null;
                if (GsonHelper.m_13900_((JsonObject)json, (String)"outputs") && (el3 = (inArray = GsonHelper.m_13933_((JsonObject)json, (String)"outputs")).iterator()).hasNext()) {
                    el = (JsonElement)el3.next();
                    obj = el.getAsJsonObject();
                    itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                    amount = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
                    stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)itemId)), amount);
                    outputs.add(new InputItemStack(stack));
                }
                FluidStack fluidStack = null;
                if (GsonHelper.m_13900_((JsonObject)json, (String)"inputs") && (el3 = (inArray = GsonHelper.m_13933_((JsonObject)json, (String)"inputs")).iterator()).hasNext()) {
                    el = (JsonElement)el3.next();
                    obj = el.getAsJsonObject();
                    itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                    amount = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
                    fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.m_135820_((String)itemId)), amount);
                    inputs.add(new InputFluidStack(fluidStack));
                }
                Recipes.recipes.getRecipeFluid().addRecipe("ingot_casting", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStack), new RecipeOutput(null, stack)));
                break;
            }
            case "castings_gear": {
                int amount;
                String itemId;
                JsonObject obj;
                JsonElement el;
                JsonArray inArray;
                Iterator el3;
                ItemStack stack = null;
                if (GsonHelper.m_13900_((JsonObject)json, (String)"outputs") && (el3 = (inArray = GsonHelper.m_13933_((JsonObject)json, (String)"outputs")).iterator()).hasNext()) {
                    el = (JsonElement)el3.next();
                    obj = el.getAsJsonObject();
                    itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                    amount = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
                    stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)itemId)), amount);
                    outputs.add(new InputItemStack(stack));
                }
                FluidStack fluidStack = null;
                if (GsonHelper.m_13900_((JsonObject)json, (String)"inputs") && (el3 = (inArray = GsonHelper.m_13933_((JsonObject)json, (String)"inputs")).iterator()).hasNext()) {
                    el = (JsonElement)el3.next();
                    obj = el.getAsJsonObject();
                    itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                    amount = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
                    fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.m_135820_((String)itemId)), amount);
                    inputs.add(new InputFluidStack(fluidStack));
                }
                Recipes.recipes.getRecipeFluid().addRecipe("gear_casting", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStack), new RecipeOutput(null, stack)));
                break;
            }
            case "mix": {
                JsonArray inArray;
                Iterator el;
                FluidStack fluidStack1 = null;
                if (GsonHelper.m_13900_((JsonObject)json, (String)"outputs") && (el = (inArray = GsonHelper.m_13933_((JsonObject)json, (String)"outputs")).iterator()).hasNext()) {
                    JsonElement el4 = (JsonElement)el.next();
                    JsonObject obj = el4.getAsJsonObject();
                    String itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                    int amount = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
                    fluidStack1 = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.m_135820_((String)itemId)), amount);
                    outputs.add(new InputFluidStack(fluidStack1));
                }
                LinkedList<FluidStack> list = new LinkedList<FluidStack>();
                if (GsonHelper.m_13900_((JsonObject)json, (String)"inputs")) {
                    JsonArray inArray3 = GsonHelper.m_13933_((JsonObject)json, (String)"inputs");
                    for (JsonElement el5 : inArray3) {
                        JsonObject obj = el5.getAsJsonObject();
                        String itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                        int amount = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
                        FluidStack fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.m_135820_((String)itemId)), amount);
                        list.add(fluidStack);
                        inputs.add(new InputFluidStack(fluidStack));
                    }
                }
                BlockEntitySmelteryController.mapRecipes.put(list, fluidStack1);
            }
        }
        return new SmelteryRecipe(id, operation, inputs, outputs);
    }

    public SmelteryRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        String operation = buf.m_130277_();
        int inSize = buf.m_130242_();
        ArrayList<IInputItemStack> inputs = new ArrayList<IInputItemStack>();
        block32: for (int i = 0; i < inSize; ++i) {
            String type;
            switch (type = buf.m_130277_()) {
                case "fluid": {
                    Object fluidId = buf.m_130281_();
                    int amountF = buf.m_130242_();
                    inputs.add(new InputFluidStack(new FluidStack((Fluid)Registry.f_122822_.m_7745_((ResourceLocation)fluidId), amountF)));
                    continue block32;
                }
                case "tag": {
                    String tag = buf.m_130277_();
                    int amountT = buf.m_130242_();
                    inputs.add(new InputOreDict(tag, amountT));
                    continue block32;
                }
                case "item": {
                    ResourceLocation itemId = buf.m_130281_();
                    int amountI = buf.m_130242_();
                    inputs.add(new InputItemStack(new ItemStack((ItemLike)Registry.f_122827_.m_7745_(itemId), amountI)));
                }
            }
        }
        int outSize = buf.m_130242_();
        ArrayList<IInputItemStack> outputs = new ArrayList<IInputItemStack>();
        block33: for (int i = 0; i < outSize; ++i) {
            String type = buf.m_130277_();
            switch (type) {
                case "fluid": {
                    ResourceLocation fluidId = buf.m_130281_();
                    int amountF = buf.m_130242_();
                    outputs.add(new InputFluidStack(new FluidStack((Fluid)Registry.f_122822_.m_7745_(fluidId), amountF)));
                    continue block33;
                }
                case "tag": {
                    String tag = buf.m_130277_();
                    int amountT = buf.m_130242_();
                    outputs.add(new InputOreDict(tag, amountT));
                    continue block33;
                }
                case "item": {
                    ResourceLocation itemId = buf.m_130281_();
                    int amountI = buf.m_130242_();
                    inputs.add(new InputItemStack(new ItemStack((ItemLike)Registry.f_122827_.m_7745_(itemId), amountI)));
                }
            }
        }
        if (!IUCore.updateRecipe) {
            ArrayList<FluidStack> fluidStacksInput = new ArrayList<FluidStack>();
            ArrayList<ItemStack> itemStacksInput = new ArrayList<ItemStack>();
            ArrayList<FluidStack> fluidStacksOutput = new ArrayList<FluidStack>();
            ArrayList<ItemStack> itemStacksOutput = new ArrayList<ItemStack>();
            for (IInputItemStack o : inputs) {
                if (o instanceof InputFluidStack) {
                    fluidStacksInput.add(((InputFluidStack)o).getFluid());
                    continue;
                }
                itemStacksInput.add(o.getInputs().get(0));
            }
            for (IInputItemStack o : outputs) {
                if (o instanceof InputFluidStack) {
                    fluidStacksOutput.add(((InputFluidStack)o).getFluid());
                    continue;
                }
                itemStacksOutput.add(o.getInputs().get(0));
            }
            switch (operation) {
                case "furnace": {
                    ItemStack stack = (ItemStack)itemStacksInput.get(0);
                    FluidStack fluidStack = (FluidStack)fluidStacksOutput.get(0);
                    if (stack == null || fluidStack == null) break;
                    BlockEntitySmelteryFurnace.addRecipe("", stack, fluidStack);
                    break;
                }
                case "castings_ingot": {
                    ItemStack stack = (ItemStack)itemStacksOutput.get(0);
                    FluidStack fluidStack = (FluidStack)fluidStacksInput.get(0);
                    Recipes.recipes.getRecipeFluid().addRecipe("ingot_casting", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStack), new RecipeOutput(null, stack)));
                    break;
                }
                case "castings_gear": {
                    ItemStack stack = (ItemStack)itemStacksOutput.get(0);
                    FluidStack fluidStack = (FluidStack)fluidStacksInput.get(0);
                    Recipes.recipes.getRecipeFluid().addRecipe("gear_casting", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStack), new RecipeOutput(null, stack)));
                    break;
                }
                case "mix": {
                    FluidStack fluidStack1 = (FluidStack)fluidStacksOutput.get(0);
                    ArrayList<FluidStack> list = fluidStacksInput;
                    BlockEntitySmelteryController.mapRecipes.put(list, fluidStack1);
                }
            }
        }
        return new SmelteryRecipe(id, operation, inputs, outputs);
    }

    public void toNetwork(FriendlyByteBuf buf, SmelteryRecipe recipe) {
        buf.m_130070_(recipe.getOperation());
        buf.m_130130_(recipe.getInputs().size());
        for (IInputItemStack input : recipe.getInputs()) {
            if (input instanceof InputFluidStack) {
                buf.m_130070_("fluid");
                buf.m_130085_(Registry.f_122822_.m_7981_((Object)((InputFluidStack)input).getFluid().getFluid()));
                buf.m_130130_(((InputFluidStack)input).getFluid().getAmount());
                continue;
            }
            if (input instanceof InputOreDict) {
                buf.m_130070_("tag");
                buf.m_130070_(input.getTag().f_203868_().toString());
                buf.m_130130_(input.getAmount());
                continue;
            }
            if (!(input instanceof InputItemStack)) continue;
            buf.m_130070_("item");
            buf.m_130085_(Registry.f_122827_.m_7981_((Object)((InputItemStack)input).input.m_41720_()));
            buf.m_130130_(input.getAmount());
        }
        buf.m_130130_(recipe.getOutputs().size());
        for (IInputItemStack output : recipe.getOutputs()) {
            if (output instanceof InputFluidStack) {
                buf.m_130070_("fluid");
                buf.m_130085_(Registry.f_122822_.m_7981_((Object)((InputFluidStack)output).getFluid().getFluid()));
                buf.m_130130_(((InputFluidStack)output).getFluid().getAmount());
                continue;
            }
            if (output instanceof InputOreDict) {
                buf.m_130070_("tag");
                buf.m_130070_(output.getTag().f_203868_().toString());
                buf.m_130130_(output.getAmount());
                continue;
            }
            if (!(output instanceof InputItemStack)) continue;
            buf.m_130070_("item");
            buf.m_130085_(Registry.f_122827_.m_7981_((Object)((InputItemStack)output).input.m_41720_()));
            buf.m_130130_(output.getAmount());
        }
    }
}

