/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.System;
import com.denfop.recipe.universalrecipe.PlanetSerializer;
import com.denfop.recipe.universalrecipe.SystemRecipe;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SystemSerializer
implements RecipeSerializer<SystemRecipe> {
    public static final SystemSerializer INSTANCE = new SystemSerializer();

    public SystemRecipe fromJson(ResourceLocation id, JsonObject json) {
        String name = json.get("name").getAsString();
        int distanceFromStar = json.get("distance").getAsInt();
        if (!PlanetSerializer.stringList.contains("system_" + name)) {
            SpaceInit.regSystem.add(() -> new System(name, distanceFromStar));
            PlanetSerializer.stringList.add("system_" + name);
        }
        return new SystemRecipe(id, name, distanceFromStar);
    }

    public SystemRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        String name = buf.m_130277_();
        int distanceFromStar = buf.m_130242_();
        if (!PlanetSerializer.stringList.contains("system_" + name)) {
            SpaceInit.regSystem.add(() -> new System(name, distanceFromStar));
            PlanetSerializer.stringList.add("system_" + name);
        }
        return new SystemRecipe(id, name, distanceFromStar);
    }

    public void toNetwork(FriendlyByteBuf buf, SystemRecipe recipe) {
        buf.m_130070_(recipe.name);
        buf.m_130130_(recipe.distance.intValue());
    }
}

