/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipes;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.blocks.BlockClassicOre;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public final class ScrapboxRecipeManager {
    public static ScrapboxRecipeManager instance;
    public final List<Drop> drops = new LinkedList<Drop>();

    public ScrapboxRecipeManager() {
        instance = this;
        this.addBuiltinDrops();
    }

    public boolean addRecipe(IInputItemStack input, Collection<ItemStack> output, CompoundTag metadata, boolean replace) {
        if (!input.matches(IUItem.scrapBox)) {
            throw new IllegalArgumentException("currently only scrap boxes are supported");
        }
        if (metadata != null && metadata.m_128441_("weight")) {
            if (output.size() != 1) {
                throw new IllegalArgumentException("currently only a single drop stack is supported");
            }
            float weight = metadata.m_128457_("weight");
            if (!(weight <= 0.0f || Float.isInfinite(weight) || Float.isNaN(weight))) {
                this.addDrop(output.iterator().next(), weight);
                return true;
            }
            throw new IllegalArgumentException("invalid weight");
        }
        throw new IllegalArgumentException("no weight metadata");
    }

    public boolean addRecipe(IInputItemStack input, CompoundTag metadata, boolean replace, ItemStack ... outputs) {
        return this.addRecipe(input, Arrays.asList(outputs), metadata, replace);
    }

    public ItemStack apply(ItemStack input) {
        if (!ModUtils.isEmpty(input) && input.m_150930_(IUItem.scrapBox.m_41720_())) {
            if (this.drops.isEmpty()) {
                return ItemStack.f_41583_;
            }
            float chance = IUCore.random.nextFloat() * Drop.topChance;
            int low = 0;
            int high = this.drops.size() - 1;
            while (low < high) {
                int mid = (high + low) / 2;
                if (chance < this.drops.get((int)mid).upperChanceBound) {
                    high = mid;
                    continue;
                }
                low = mid + 1;
            }
            return this.drops.get((int)low).item.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getRandomDrop() {
        if (this.drops.isEmpty()) {
            return ItemStack.f_41583_;
        }
        float chance = WorldBaseGen.random.nextFloat() * Drop.topChance;
        int low = 0;
        int high = this.drops.size() - 1;
        while (low < high) {
            int mid = (high + low) / 2;
            if (chance < this.drops.get((int)mid).upperChanceBound) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return this.drops.get((int)low).item;
    }

    public boolean isIterable() {
        return false;
    }

    public void addDrop(ItemStack drop, float rawChance) {
        this.drops.add(new Drop(drop, rawChance));
    }

    public ItemStack getDrop(ItemStack input) {
        return this.apply(input);
    }

    public Map<ItemStack, Float> getDrops() {
        HashMap<ItemStack, Float> ret = new HashMap<ItemStack, Float>(this.drops.size());
        for (Drop drop : this.drops) {
            ret.put(drop.item, Float.valueOf(drop.originalChance / Drop.topChance));
        }
        return ret;
    }

    private void addBuiltinDrops() {
        this.addDrop(Items.f_42424_, 5.01f);
        this.addDrop(Blocks.f_50493_, 5.0f);
        this.addDrop(Items.f_42398_, 4.0f);
        this.addDrop(Blocks.f_50034_, 3.0f);
        this.addDrop(Blocks.f_49994_, 3.0f);
        this.addDrop(Blocks.f_50134_, 2.0f);
        this.addDrop(Items.f_42583_, 2.0f);
        this.addDrop(Items.f_42410_, 1.5f);
        this.addDrop(Items.f_42406_, 1.5f);
        this.addDrop(Items.f_42420_, 1.0f);
        this.addDrop(Items.f_42421_, 1.0f);
        this.addDrop(Items.f_42422_, 1.0f);
        this.addDrop(Blocks.f_50135_, 1.0f);
        this.addDrop(Blocks.f_50095_, 1.0f);
        this.addDrop(Items.f_42454_, 1.0f);
        this.addDrop(Items.f_42402_, 1.0f);
        this.addDrop(Items.f_42500_, 1.0f);
        this.addDrop(Items.f_42486_, 0.9f);
        this.addDrop(Items.f_42580_, 0.9f);
        this.addDrop(Blocks.f_50133_, 0.9f);
        this.addDrop(Items.f_42582_, 0.9f);
        this.addDrop(Items.f_42449_, 0.01f);
        this.addDrop(Items.f_42451_, 0.9f);
        this.addDrop(IUItem.rubber, 0.8f);
        this.addDrop(Items.f_42525_, 0.8f);
        this.addDrop(IUItem.coalDust, 0.8f);
        this.addDrop(IUItem.copperDust, 0.8f);
        this.addDrop(IUItem.tinDust, 0.8f);
        this.addDrop(IUItem.ironDust, 0.7f);
        this.addDrop(IUItem.goldDust, 0.7f);
        this.addDrop(Items.f_42518_, 0.6f);
        this.addDrop(Blocks.f_49996_, 0.5f);
        this.addDrop(Items.f_42476_, 0.01f);
        this.addDrop(Blocks.f_49995_, 0.5f);
        this.addDrop(Items.f_42502_, 0.5f);
        this.addDrop(Items.f_42415_, 0.1f);
        this.addDrop(Items.f_42616_, 0.05f);
        this.addDrop(Items.f_42584_, 0.08f);
        this.addDrop(Items.f_42585_, 0.04f);
        this.addDrop(Items.f_42521_, 0.8f);
        this.addDrop(Blocks.f_152505_, 0.7f);
        this.addDrop(IUItem.classic_ore.getItemStack(BlockClassicOre.Type.tin), 0.7f);
        this.addDrop(Blocks.f_152503_, 0.5f);
        this.addDrop(Blocks.f_152502_, 0.5f);
        this.addDrop(Blocks.f_152501_, 0.4f);
        this.addDrop(Blocks.f_152571_, 0.6f);
        this.addDrop(Blocks.f_152573_, 0.5f);
        this.addDrop(Blocks.f_152572_, 0.4f);
        this.addDrop(Blocks.f_152574_, 0.3f);
        this.addDrop(Blocks.f_152490_, 0.8f);
        this.addDrop(Blocks.f_152491_, 0.6f);
        this.addDrop(Blocks.f_152492_, 0.4f);
        this.addDrop(Blocks.f_152493_, 0.3f);
        this.addDrop(Blocks.f_152494_, 0.2f);
        this.addDrop(Blocks.f_152495_, 0.1f);
        this.addDrop(Items.f_151049_, 0.7f);
        this.addDrop(Blocks.f_152497_, 1.0f);
        this.addDrop(Blocks.f_152496_, 0.8f);
        this.addDrop(Blocks.f_152597_, 0.6f);
        this.addDrop(Items.f_42787_, 0.9f);
        this.addDrop(Blocks.f_50719_, 0.8f);
        this.addDrop(Items.f_42784_, 0.7f);
        this.addDrop(Blocks.f_50720_, 0.6f);
        this.addDrop(Blocks.f_50718_, 0.4f);
        this.addDrop(Blocks.f_50717_, 0.4f);
        this.addDrop(Blocks.f_220855_, 0.6f);
        this.addDrop(Blocks.f_220856_, 0.5f);
        this.addDrop(Blocks.f_220857_, 0.7f);
        this.addDrop(Blocks.f_220858_, 0.8f);
        this.addDrop(Blocks.f_152500_, 0.7f);
        this.addDrop(Blocks.f_220832_, 1.5f);
        this.addDrop(Blocks.f_220835_, 1.5f);
        this.addDrop(Blocks.f_220836_, 1.4f);
        this.addDrop(Blocks.f_220837_, 1.4f);
        this.addDrop(Blocks.f_220865_, 1.0f);
        this.addDrop(Blocks.f_220838_, 0.6f);
        this.addDrop(Blocks.f_220831_, 0.7f);
        this.addDrop(Blocks.f_220833_, 0.5f);
        this.addDrop(Blocks.f_220834_, 0.5f);
        this.addDrop(Blocks.f_220864_, 1.3f);
        this.addDrop(Blocks.f_220843_, 0.9f);
        this.addDrop(Blocks.f_220844_, 1.0f);
        this.addDrop(Blocks.f_220845_, 0.7f);
        this.addDrop(Blocks.f_220849_, 0.5f);
        this.addDrop(Blocks.f_220854_, 0.7f);
        this.addDrop(Blocks.f_220853_, 0.8f);
        this.addDrop(Blocks.f_220842_, 0.8f);
        this.addDrop(Blocks.f_220852_, 0.7f);
        this.addDrop(Blocks.f_220850_, 0.7f);
        this.addDrop(Blocks.f_220851_, 0.5f);
        this.addDrop(Blocks.f_220848_, 0.7f);
        this.addDrop(Items.f_220204_, 1.0f);
        this.addDrop(Blocks.f_152548_, 0.3f);
        this.addDrop(Blocks.f_152549_, 0.6f);
        this.addDrop(Blocks.f_152541_, 1.0f);
        this.addDrop(Blocks.f_152542_, 1.2f);
        this.addDrop(Blocks.f_152544_, 0.8f);
        this.addDrop(Blocks.f_152543_, 0.4f);
        this.addDrop(Blocks.f_152540_, 0.6f);
        this.addDrop(Blocks.f_152547_, 0.4f);
        this.addDrop(Blocks.f_152545_, 0.6f);
        this.addDrop(Items.f_151079_, 0.5f);
        this.addDrop(Blocks.f_50355_, 1.2f);
        this.addDrop(Blocks.f_50357_, 1.2f);
        this.addDrop(Blocks.f_50356_, 1.0f);
        this.addDrop(Blocks.f_50114_, 0.8f);
        this.addDrop(Blocks.f_50113_, 0.6f);
        this.addDrop(Blocks.f_50115_, 0.8f);
        this.addDrop(Blocks.f_50117_, 0.6f);
        this.addDrop(Blocks.f_50116_, 0.6f);
        this.addDrop(Blocks.f_50118_, 0.6f);
        this.addDrop(Blocks.f_50119_, 0.6f);
        this.addDrop(Blocks.f_50120_, 0.8f);
        this.addDrop(Blocks.f_152482_, 0.7f);
        this.addDrop(Blocks.f_152483_, 0.7f);
        this.addDrop(Blocks.f_152484_, 0.7f);
        this.addDrop(Blocks.f_152511_, 0.7f);
        this.addDrop(Blocks.f_152512_, 0.7f);
        this.addDrop(Blocks.f_152513_, 0.7f);
        this.addDrop(Blocks.f_152514_, 0.7f);
        this.addDrop(Blocks.f_152515_, 0.7f);
        this.addDrop(Blocks.f_152516_, 0.7f);
        this.addDrop(Blocks.f_152517_, 0.7f);
        this.addDrop(Blocks.f_152518_, 0.7f);
        this.addDrop(Blocks.f_152519_, 0.7f);
        this.addDrop(Blocks.f_152520_, 0.7f);
        this.addDrop(Blocks.f_152521_, 0.7f);
        this.addDrop(Blocks.f_152522_, 0.7f);
        this.addDrop(Blocks.f_152523_, 0.7f);
        this.addDrop(Blocks.f_152524_, 0.7f);
        this.addDrop(Items.f_151063_, 0.3f);
        this.addDrop(Items.f_151056_, 0.3f);
        this.addDrop(Items.f_42612_, 0.6f);
        this.addDrop(Items.f_220219_, 0.5f);
        this.addDrop(Items.f_220210_, 0.3f);
        this.addDrop(Items.f_220213_, 0.2f);
        this.addDrop(Items.f_220207_, 1.0f);
        this.addDrop(Items.f_220208_, 1.0f);
        this.addDrop(Items.f_220200_, 1.0f);
        this.addDrop(Items.f_220201_, 1.0f);
        this.addDrop(Items.f_220202_, 1.0f);
        this.addDrop(Items.f_220203_, 1.0f);
        this.addDrop(Items.f_220217_, 0.3f);
        this.addDrop(Items.f_186363_, 0.3f);
        this.addDrop(Items.f_42712_, 0.3f);
        this.addDrop(Blocks.f_220863_, 0.5f);
        this.addDrop(Blocks.f_50730_, 1.2f);
        this.addDrop(Blocks.f_50734_, 1.5f);
        this.addDrop(Blocks.f_50735_, 1.5f);
        this.addDrop(Blocks.f_50736_, 1.2f);
        this.addDrop(Blocks.f_50737_, 1.2f);
        this.addDrop(Items.f_42659_, 1.0f);
        this.addDrop(Items.f_42698_, 1.0f);
        this.addDrop(Items.f_42531_, 1.0f);
        this.addDrop(Items.f_42530_, 1.0f);
        this.addDrop(Items.f_42620_, 1.2f);
        this.addDrop(Items.f_42674_, 1.2f);
        this.addDrop(Items.f_42619_, 1.3f);
        this.addDrop(Items.f_42677_, 0.5f);
        this.addDrop(Items.f_42687_, 0.8f);
        this.addDrop(Items.f_42575_, 1.0f);
        this.addDrop(Items.f_42780_, 0.9f);
        this.addDrop(Items.f_42572_, 1.0f);
        this.addDrop(Items.f_42787_, 0.8f);
        this.addDrop(Items.f_42455_, 0.4f);
        this.addDrop(Items.f_42699_, 0.6f);
        this.addDrop(Items.f_42589_, 0.5f);
        this.addDrop(Items.f_42736_, 0.3f);
        this.addDrop(Items.f_42739_, 0.2f);
        this.addDrop(Items.f_42738_, 0.3f);
        this.addDrop(Items.f_42425_, 1.5f);
        this.addDrop(Items.f_42426_, 1.5f);
        this.addDrop(Items.f_42427_, 1.5f);
        this.addDrop(Items.f_42428_, 1.5f);
        this.addDrop(Items.f_42429_, 1.5f);
        this.addDrop(Items.f_42383_, 0.8f);
        this.addDrop(Items.f_42384_, 0.8f);
        this.addDrop(Items.f_42385_, 0.8f);
        this.addDrop(Items.f_42386_, 0.8f);
        this.addDrop(Items.f_42387_, 0.8f);
        this.addDrop(Items.f_42411_, 0.6f);
        this.addDrop(Items.f_42717_, 0.4f);
        this.addDrop(Items.f_42412_, 3.0f);
        this.addDrop(Items.f_42737_, 0.1f);
        this.addDrop(Items.f_42740_, 0.3f);
        this.addDrop(Items.f_42407_, 0.4f);
        this.addDrop(Items.f_42408_, 0.3f);
        this.addDrop(Items.f_42462_, 0.3f);
        this.addDrop(Items.f_42463_, 0.4f);
        this.addDrop(Items.f_42464_, 0.1f);
        this.addDrop(Items.f_42465_, 0.1f);
        this.addDrop(Items.f_42466_, 0.1f);
        this.addDrop(Items.f_42467_, 0.1f);
        this.addDrop(Items.f_42468_, 0.1f);
        this.addDrop(Items.f_42469_, 0.08f);
        this.addDrop(Items.f_42470_, 0.08f);
        this.addDrop(Items.f_42471_, 0.1f);
        this.addDrop(Items.f_42476_, 0.05f);
        this.addDrop(Items.f_42477_, 0.04f);
        this.addDrop(Items.f_42478_, 0.04f);
        this.addDrop(Items.f_42479_, 0.05f);
        this.addDrop(Items.f_42472_, 0.02f);
        this.addDrop(Items.f_42473_, 0.015f);
        this.addDrop(Items.f_42474_, 0.015f);
        this.addDrop(Items.f_42475_, 0.02f);
        this.addDrop(Items.f_42480_, 0.01f);
        this.addDrop(Items.f_42481_, 0.008f);
        this.addDrop(Items.f_42482_, 0.008f);
        this.addDrop(Items.f_42483_, 0.01f);
        this.addDrop(Items.f_42409_, 0.2f);
        this.addDrop(Items.f_42523_, 0.3f);
        this.addDrop(Items.f_42574_, 0.3f);
        this.addDrop(Items.f_42655_, 0.5f);
        this.addDrop(Items.f_42656_, 0.1f);
        this.addDrop(Items.f_42517_, 0.5f);
        this.addDrop(Items.f_42690_, 0.1f);
    }

    private void addDrop(Block block, float rawChance) {
        this.addDrop(new ItemStack((ItemLike)block), rawChance);
    }

    private void addDrop(Item item, float rawChance) {
        this.addDrop(new ItemStack((ItemLike)item), rawChance);
    }

    private static class Drop {
        static float topChance;
        final ItemStack item;
        final float originalChance;
        final float upperChanceBound;

        Drop(ItemStack item, float chance) {
            this.item = item;
            this.originalChance = chance;
            this.upperChanceBound = topChance += chance;
        }
    }
}

