/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.compressor;

import com.denfop.IUItem;
import com.denfop.blockentity.mechanism.BlockEntityCompressor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.ForgeHooksClient;

public class TileEntityRenderCompressor
implements BlockEntityRenderer<BlockEntityCompressor> {
    private final BlockEntityRendererProvider.Context contex;
    private ItemStack stack;
    private float rotation;
    private float prevRotation;

    public TileEntityRenderCompressor(BlockEntityRendererProvider.Context p_173636_) {
        this.contex = p_173636_;
    }

    private int transformModelCount(PoseStack poseStack, float partialTicks) {
        int modelCount = 1;
        float offsetY = 1.0f;
        poseStack.m_85837_(0.5, (double)(0.25f * offsetY) + 0.25, 0.5);
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
        this.prevRotation = this.rotation = (this.prevRotation + (this.rotation - this.prevRotation) * partialTicks) % 360.0f;
        this.rotation += 2.0f;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(this.rotation));
        return modelCount;
    }

    public void renderItem(ItemStack itemStack, Level level, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (itemStack.m_41619_()) {
            return;
        }
        BakedModel bakedModel = this.contex.m_234447_().m_174264_(itemStack, level, null, 0);
        RandomSource random = level.f_46441_;
        if (bakedModel != null) {
            boolean isGui3d = bakedModel.m_7539_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 2.0, 0.0);
            int count = this.transformModelCount(poseStack, Minecraft.m_91087_().getPartialTick());
            for (int i = 0; i < 1; ++i) {
                poseStack.m_85836_();
                if (isGui3d) {
                    if (i > 0) {
                        float xOffset = (random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                        yOffset = (random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                        float zOffset = (random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                        poseStack.m_85837_((double)xOffset, (double)yOffset, (double)zOffset);
                    }
                } else if (i > 0) {
                    float xOffset = (random.m_188501_() * 2.0f - 1.0f) * 0.075f;
                    yOffset = (random.m_188501_() * 2.0f - 1.0f) * 0.075f;
                    poseStack.m_85837_((double)xOffset, (double)yOffset, 0.0);
                }
                BakedModel transformedModel = ForgeHooksClient.handleCameraTransforms((PoseStack)new PoseStack(), (BakedModel)bakedModel, (ItemTransforms.TransformType)ItemTransforms.TransformType.GROUND, (boolean)false);
                this.contex.m_234447_().m_115143_(itemStack, ItemTransforms.TransformType.FIXED, false, poseStack, buffer, light, overlay, transformedModel);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }

    public void render(BlockEntityCompressor te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int combinedOverlay) {
        ItemStack itemstack = te.outputSlot.get(0);
        if (!itemstack.m_41619_()) {
            poseStack.m_85836_();
            if (itemstack.m_41720_() instanceof BlockItem) {
                if (te.facing == 4 || te.facing == 5) {
                    poseStack.m_85837_(0.5, 0.41, 0.31);
                } else {
                    poseStack.m_85837_(0.5, 0.41, 0.3);
                }
            } else {
                poseStack.m_85837_(0.5, 0.42, 0.37501);
            }
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            this.contex.m_234447_().m_174269_(itemstack, ItemTransforms.TransformType.GROUND, packedLight, combinedOverlay, poseStack, bufferSource, 0);
            poseStack.m_85849_();
        }
        poseStack.m_85836_();
        if (te.durability == 0) {
            if (this.stack == null) {
                this.stack = new ItemStack((ItemLike)IUItem.crafting_elements.getStack(76));
            }
            this.renderItem(this.stack, te.m_58904_(), poseStack, bufferSource, packedLight, combinedOverlay);
        }
        poseStack.m_85849_();
        itemstack = te.inputSlotA.get(0);
        if (!itemstack.m_41619_()) {
            poseStack.m_85836_();
            if (itemstack.m_41720_() instanceof BlockItem) {
                if (te.facing == 4 || te.facing == 5) {
                    poseStack.m_85837_(0.5, 0.41, 0.31);
                } else {
                    poseStack.m_85837_(0.5, 0.41, 0.3);
                }
            } else {
                poseStack.m_85837_(0.5, 0.42, 0.37501);
            }
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            this.contex.m_234447_().m_174269_(itemstack, ItemTransforms.TransformType.GROUND, packedLight, combinedOverlay, poseStack, bufferSource, 0);
            poseStack.m_85849_();
        }
    }
}

