/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.fluidintegrator;

import com.denfop.blockentity.mechanism.BlockEntityPrimalFluidIntegrator;
import com.denfop.render.RenderFluidBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PrimalFluidIntegratorRenderer
implements BlockEntityRenderer<BlockEntityPrimalFluidIntegrator> {
    private final ItemRenderer itemRenderer;
    private final BlockEntityRendererProvider.Context contex;
    private float rotation = 0.0f;
    private float prevRotation = 0.0f;

    public PrimalFluidIntegratorRenderer(BlockEntityRendererProvider.Context p_173636_) {
        this.contex = p_173636_;
        this.itemRenderer = Minecraft.m_91087_().m_91291_();
    }

    public void render(BlockEntityPrimalFluidIntegrator tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack outputStack;
        BlockHitResult blockHit;
        this.renderTanks(tile, poseStack, bufferSource, packedLight, packedOverlay);
        ItemStack itemStack = tile.inputSlotA.get(0);
        if (!itemStack.m_41619_()) {
            poseStack.m_85836_();
            float scale = Math.min(1.0f, (float)tile.fluidTank1.getFluidAmount() / (float)tile.fluidTank1.getCapacity());
            Vec3 offset = this.getOffset(tile.getFacing(), scale);
            poseStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            if (scale > 0.1f) {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(this.rotation));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(this.rotation));
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(this.rotation));
            } else {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            }
            poseStack.m_85841_(0.9f, 0.9f, 0.9f);
            this.itemRenderer.m_174269_(itemStack, ItemTransforms.TransformType.GROUND, packedLight, packedOverlay, poseStack, bufferSource, 0);
            poseStack.m_85849_();
        }
        BlockPos cameraPos = tile.m_58899_();
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult instanceof BlockHitResult && (cameraPos.equals((Object)(blockHit = (BlockHitResult)hitResult).m_82425_()) || cameraPos.m_7494_().equals((Object)blockHit.m_82425_()))) {
            String text = (int)(tile.getProgress() * 100.0) + "%";
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 1.5, 0.5);
            MutableComponent text1 = Component.m_237113_((String)text);
            this.renderFloatingText((Component)text1, poseStack, bufferSource, packedLight);
            poseStack.m_85837_(0.0, -0.25, 0.0);
            poseStack.m_85849_();
        }
        if (!(outputStack = tile.outputSlot.get(0)).m_41619_()) {
            poseStack.m_85836_();
            Vec3 outputOffset = this.getOutputOffset(tile.getFacing());
            poseStack.m_85837_(outputOffset.f_82479_, outputOffset.f_82480_, outputOffset.f_82481_);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            Minecraft.m_91087_().m_91291_().m_174269_(outputStack, ItemTransforms.TransformType.GROUND, packedLight, packedOverlay, poseStack, bufferSource, 0);
            poseStack.m_85849_();
        }
        this.prevRotation = this.rotation = this.prevRotation + (this.rotation - this.prevRotation) * partialTicks;
        this.rotation += 0.25f;
    }

    private void renderTanks(BlockEntityPrimalFluidIntegrator tile, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float scale;
        if (!tile.fluidTank1.getFluid().isEmpty()) {
            poseStack.m_85836_();
            scale = (float)tile.fluidTank1.getFluidAmount() * 0.75f / (float)tile.fluidTank1.getCapacity();
            switch (tile.facing) {
                case 2: {
                    poseStack.m_85837_(0.63, 0.3, 0.38);
                    break;
                }
                case 3: {
                    poseStack.m_85837_(0.13, 0.3, 0.38);
                    break;
                }
                case 4: {
                    poseStack.m_85837_(0.38, 0.3, 0.131);
                    break;
                }
                case 5: {
                    poseStack.m_85837_(0.38, 0.3, 0.63);
                }
            }
            RenderFluidBlock.renderFluid(tile.fluidTank1.getFluid(), bufferSource, tile.m_58904_(), tile.getPos(), poseStack, scale, 0.62f);
            poseStack.m_85849_();
        }
        if (!tile.fluidTank2.getFluid().isEmpty()) {
            poseStack.m_85836_();
            scale = (float)tile.fluidTank2.getFluidAmount() * 0.7f / (float)tile.fluidTank2.getCapacity();
            switch (tile.facing) {
                case 2: {
                    poseStack.m_85837_(0.010000000000000009, 0.15, 0.51);
                    break;
                }
                case 3: {
                    poseStack.m_85837_(1.01, 0.15, 0.51);
                    break;
                }
                case 4: {
                    poseStack.m_85837_(0.51, 0.15, 1.01);
                    break;
                }
                case 5: {
                    poseStack.m_85837_(0.51, 0.15, 0.010000000000000009);
                }
            }
            RenderFluidBlock.renderFluid(tile.fluidTank2.getFluid(), bufferSource, tile.m_58904_(), tile.getPos(), poseStack, scale, 0.49f);
            poseStack.m_85849_();
        }
    }

    private void renderFloatingText(Component text, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85845_(this.contex.m_234446_().m_114470_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        Font font = this.contex.m_173586_();
        float f2 = -font.m_92852_((FormattedText)text) / 2;
        font.m_92841_(text, f2, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, false, j, packedLight);
        font.m_92841_(text, f2, 0.0f, -1, false, matrix4f, buffer, false, 0, packedLight);
        poseStack.m_85849_();
    }

    private Vec3 getOffset(Direction facing, float scale) {
        return switch (facing) {
            case Direction.SOUTH -> new Vec3(0.2, 0.3 + 0.6 * (double)scale, 0.5);
            case Direction.NORTH -> new Vec3(0.75, 0.3 + 0.6 * (double)scale, 0.5);
            case Direction.WEST -> new Vec3(0.5, 0.3 + 0.6 * (double)scale, 0.2);
            case Direction.EAST -> new Vec3(0.5, 0.3 + 0.6 * (double)scale, 0.75);
            default -> Vec3.f_82478_;
        };
    }

    private Vec3 getOutputOffset(Direction facing) {
        return switch (facing) {
            case Direction.SOUTH -> new Vec3(1.0, 0.87, 0.5);
            case Direction.NORTH -> new Vec3(0.0, 0.87, 0.5);
            case Direction.WEST -> new Vec3(0.5, 0.87, 0.9);
            case Direction.EAST -> new Vec3(0.5, 0.87, -0.1);
            default -> Vec3.f_82478_;
        };
    }
}

