/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.bee.Bee;
import com.denfop.api.bee.genetics.Genome;
import com.denfop.containermenu.ContainerMenuBeeAnalyzer;
import com.denfop.items.bee.ItemJarBees;
import com.denfop.items.bee.ItemStackBeeAnalyzer;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenBeeAnalyzer<T extends ContainerMenuBeeAnalyzer>
extends ScreenMain<ContainerMenuBeeAnalyzer> {
    private static final ResourceLocation background = new ResourceLocation("industrialupgrade", "textures/gui/guibeeanalyzer.png");
    private final String name;
    private int prevText;
    private float scaled;
    private int textIndex;

    public ScreenBeeAnalyzer(ContainerMenuBeeAnalyzer container, ItemStack itemStack1) {
        super(container);
        this.name = Localization.translate(itemStack1.m_41778_());
        this.componentList.clear();
        this.f_97726_ = 203;
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.bee.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 21; ++i) {
                compatibleUpgrades.add(Localization.translate("iu.bee.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 160, mouseY - 10, text);
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        ScreenBeeAnalyzer.m_93236_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (String)this.name, (int)((this.f_97726_ - this.getStringWidth(this.name)) / 2 - 10), (int)4, (int)0);
        this.handleUpgradeTooltip(par1, par2);
        if (!((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).get(0).m_41619_() && ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).genome == null) {
            ModUtils.nbt(((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).get(0)).m_128379_("analyzed", true);
            ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).genome = new Genome(((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).get(0));
            ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).crop = ItemJarBees.getBee(((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).get(0));
            ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).set();
            this.textIndex = 0;
        } else if (((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).get(0).m_41619_() && ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).genome != null) {
            ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).genome = null;
            ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).crop = null;
            ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).set();
            this.textIndex = 0;
        }
        if (((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).genome != null) {
            String text = this.getInformationFromCrop();
            int canvasX = 13;
            int canvasY = 19;
            int canvasWidth = 150;
            int canvasHeight = 112;
            float scale = 0.5f;
            int maxWidth = (int)((float)canvasWidth / scale);
            Objects.requireNonNull(this.f_96547_);
            double lineHeight = 9.0 * 0.5;
            int x = canvasX;
            double y = canvasY;
            PoseStack pose = poseStack;
            List<String> lines = this.wrapTextWithNewlines(text, maxWidth);
            for (String line : lines) {
                if (y + lineHeight > (double)(canvasY + canvasHeight)) break;
                pose.m_85836_();
                pose.m_85837_((double)x, y, 0.0);
                pose.m_85841_(scale, scale, scale);
                ScreenBeeAnalyzer.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)line, (int)0, (int)0, (int)0xFFFFFF);
                pose.m_85849_();
                y += lineHeight;
            }
        }
    }

    private String getInformationFromCrop() {
        Bee queen = ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).crop;
        ArrayList namesBiomes = new ArrayList();
        queen.getBiomes().forEach(biomeKey -> namesBiomes.add(Localization.translate("biome." + biomeKey.m_135782_().m_135827_() + "." + biomeKey.m_135782_().m_135815_())));
        Genome genome = ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).genome;
        return Localization.translate("iu.bee_analyzer.name") + " " + Localization.translate("bee_" + queen.getName()) + "\n" + Localization.translate("iu.bee_analyzer.time_life") + " " + new Timer((int)((double)queen.getTickLifecycles() * ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).populationGenome / 20.0)).getDisplay() + "\n" + Localization.translate("iu.bee_analyzer.main_crop") + " " + Localization.translate("crop." + queen.getCropFlower().getName()) + "\n" + Localization.translate("iu.bee_analyzer.birth_rate") + " " + ModUtils.getString((double)queen.getOffspring() * ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).birthRateGenome) + "\n" + Localization.translate("iu.bee_analyzer.pest_crop") + " " + ModUtils.getString(Math.abs(((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).pestGenome - 1.0) * 100.0) + "%\n" + Localization.translate("iu.bee_analyzer.daytime") + " " + (queen.isSun() || ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).sunGenome ? Localization.translate("iu.space_yes") : Localization.translate("iu.space_no")) + "\n" + Localization.translate("iu.bee_analyzer.nighttime") + " " + (queen.isNight() || ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).nightGenome ? Localization.translate("iu.space_yes") : Localization.translate("iu.space_no")) + "\n" + Localization.translate("iu.bee_analyzer.radius") + " " + ModUtils.getString(queen.getSizeTerritory().f_82291_ * ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).radiusGenome) + "x" + ModUtils.getString(queen.getSizeTerritory().f_82292_ * ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).radiusGenome) + "x" + ModUtils.getString(queen.getSizeTerritory().f_82293_ * ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).radiusGenome) + "\n" + Localization.translate("iu.bee_analyzer.increase_food") + " " + ModUtils.getString(Math.abs(((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).foodGenome - 1.0) * 100.0) + "%\n" + Localization.translate("iu.bee_analyzer.increase_jelly") + " " + ModUtils.getString(Math.abs(((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).jellyGenome - 1.0) * 100.0) + "%\n" + Localization.translate("iu.bee_analyzer.increase_getting_crop_percent") + " " + ModUtils.getString(Math.abs(((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).productGenome - 1.0) * 100.0) + "%\n" + Localization.translate("iu.bee_analyzer.decrease_sicken") + " " + ModUtils.getString(Math.abs(((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).hardeningGenome - 1.0) * 100.0) + "%\n" + Localization.translate("iu.bee_analyzer.max_population") + " " + ModUtils.getString((double)queen.getMaxSwarm() * ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).swarmGenome) + "\n" + Localization.translate("iu.bee_analyzer.mortality_rate") + " " + ModUtils.getString(queen.getMaxMortalityRate() * ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).mortalityGenome * 100.0) + "%\n" + Localization.translate("iu.bee_analyzer.weather_resistance") + " " + (((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).weatherGenome == 0 ? Localization.translate("iu.space_no") : (((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).weatherGenome == 1 ? Localization.translate("iu.space_rain") : Localization.translate("iu.space_thunder"))) + "\n" + Localization.translate("iu.bee_analyzer.percent_genome_adaptive") + " " + Math.max(5, ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).genomeAdaptive) + "%\n" + Localization.translate("iu.bee_analyzer.percent_genome_resistance") + " " + Math.max(5, ((ItemStackBeeAnalyzer)((ContainerMenuBeeAnalyzer)this.container).base).genomeResistance) + "%\n" + Localization.translate("iu.crop_analyzer.biomes") + namesBiomes.stream().collect(Collectors.joining(", "));
    }

    @Override
    protected void drawBackgroundAndTitle(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.f_97726_, this.f_97727_);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        ScreenBeeAnalyzer.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }

    @Override
    protected ResourceLocation getTexture() {
        return background;
    }
}

