/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.sound.AudioFixer;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.TankWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.mechanism.cooling.BlockEntityFluidCooling;
import com.denfop.componets.ComponentButton;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.CoolComponent;
import com.denfop.containermenu.ContainerMenuFluidCoolMachine;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;

public class ScreenFluidCoolMachine<T extends ContainerMenuFluidCoolMachine>
extends ScreenMain<ContainerMenuFluidCoolMachine> {
    public ContainerMenuFluidCoolMachine container;
    public String name;

    public ScreenFluidCoolMachine(ContainerMenuFluidCoolMachine guiContainer) {
        super(guiContainer);
        this.container = guiContainer;
        this.name = Localization.translate(((BlockEntityFluidCooling)guiContainer.base).getName());
        this.addComponent(new ScreenWidget(this, 3, 14, EnumTypeComponent.SOUND_BUTTON, new WidgetDefault<ComponentSoundButton>(new ComponentSoundButton((BlockEntityBase)((Object)this.container.base), 10, (AudioFixer)((Object)this.container.base)))));
        this.componentList.add(new ScreenWidget(this, 51, 41, EnumTypeComponent.COOL_ENERGY_WEIGHT, new WidgetDefault<CoolComponent>(((BlockEntityFluidCooling)this.container.base).cold)));
        this.componentList.add(new ScreenWidget(this, 20, 37, EnumTypeComponent.WORK_BUTTON, new WidgetDefault<1>(new ComponentButton((BlockEntityBase)((Object)this.container.base), 2, ""){

            @Override
            public String getText() {
                return ((BlockEntityFluidCooling)this.getEntityBlock()).work ? Localization.translate("turn_off") : Localization.translate("turn_on");
            }

            @Override
            public boolean active() {
                return !((BlockEntityFluidCooling)this.getEntityBlock()).work;
            }
        })));
        this.componentList.add(new ScreenWidget(this, 53, 60, EnumTypeComponent.PLUS_BUTTON, new WidgetDefault<2>(new ComponentButton((BlockEntityBase)((Object)this.container.base), 0, ""){

            @Override
            public String getText() {
                return "+4";
            }
        })));
        this.componentList.add(new ScreenWidget(this, 78, 60, EnumTypeComponent.MINUS_BUTTON, new WidgetDefault<3>(new ComponentButton((BlockEntityBase)((Object)this.container.base), 1, ""){

            @Override
            public String getText() {
                return "-4";
            }
        })));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.cool_storage.info_main"));
            List<String> compatibleUpgrades = ListInformationUtils.cooling;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        TankWidget.createNormal(this, 112, 20, (IFluidTank)((BlockEntityFluidCooling)this.container.base).tank).drawForeground(poseStack, par1, par2);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenFluidCoolMachine.bindTexture(this.getTexture());
        int xOffset = this.guiLeft;
        int yOffset = this.guiTop;
        ScreenFluidCoolMachine.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, xOffset + 3, yOffset + 3, 0, 0, 10, 10);
        ScreenFluidCoolMachine.bindTexture(this.getTexture());
        TankWidget.createNormal(this, 112, 20, (IFluidTank)((BlockEntityFluidCooling)this.container.base).tank).drawBackground(poseStack, this.guiLeft, this.guiTop);
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guimachine.png");
    }
}

