/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.upgrades.BlockEntityUpgrade;
import com.denfop.api.upgrades.BlockEntityUpgradeManager;
import com.denfop.api.upgrades.EnumBlockEntityUpgrade;
import com.denfop.api.upgrades.UpgradeItem;
import com.denfop.api.widget.MouseButton;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.ScrollDirection;
import com.denfop.api.widget.SliderWidget;
import com.denfop.api.widget.VerticalSliderListWidget;
import com.denfop.api.widget.VerticalSliderWidget;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.mixin.access.AbstractContainerScreenAccessor;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import java.awt.Rectangle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public abstract class ScreenIndustrialUpgrade<T extends ContainerMenuBase<? extends CustomWorldContainer>>
extends AbstractContainerScreen<T>
implements MenuAccess<T> {
    public final T container;
    protected final List<ScreenWidget> elements;
    private final Queue<Tooltip> queuedTooltips;
    public int guiLeft;
    public int guiTop;

    public ScreenIndustrialUpgrade(T container) {
        this(container, 176, 166);
    }

    public ScreenIndustrialUpgrade(T container, int ySize) {
        this(container, 176, ySize);
    }

    public ScreenIndustrialUpgrade(T t, int n, int n2) {
        super(t, ((ContainerMenuBase)((Object)t)).getInventory(), (Component)Component.m_237119_());
        this.container = t;
        this.queuedTooltips = new ArrayDeque<Tooltip>();
        this.elements = new ArrayList<ScreenWidget>();
        this.f_97727_ = n2;
        this.f_97726_ = n;
    }

    private static List<ItemStack> getCompatibleUpgrades(BlockEntityUpgrade block) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Set<EnumBlockEntityUpgrade> properties = block.getUpgradableProperties();
        for (ItemStack stack : BlockEntityUpgradeManager.getUpgrades()) {
            UpgradeItem item = (UpgradeItem)stack.m_41720_();
            if (!item.isSuitableFor(stack, properties)) continue;
            ret.add(stack);
        }
        return ret;
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)resourceLocation);
    }

    public void drawSplitString(PoseStack poseStack, Font font, String str, int x, int y, int wrapWidth, int textColor) {
        List strs = font.m_92923_(FormattedText.m_130775_((String)str), wrapWidth);
        for (FormattedCharSequence s : strs) {
            font.m_92877_(poseStack, s, (float)x, (float)y, textColor);
            y += 9;
        }
    }

    public ItemRenderer getItemRenderer() {
        return this.f_96542_;
    }

    public void drawSplitString(PoseStack poseStack, String str, int x, int y, int wrapWidth, int textColor) {
        if (this.f_96547_ == null) {
            this.f_96547_ = Minecraft.m_91087_().f_91062_;
        }
        List strs = this.f_96547_.m_92923_(FormattedText.m_130775_((String)str), wrapWidth);
        for (FormattedCharSequence s : strs) {
            this.f_96547_.m_92877_(poseStack, s, (float)x, (float)y, textColor);
            y += 9;
        }
    }

    public void changeParams() {
    }

    public float adjustTextScale(String text, int canvasWidth, int canvasHeight, float scale, float scaleStep) {
        float newScale;
        block4: {
            newScale = scale;
            float min = 70.0f;
            float max = 0.0f;
            boolean prevScaleDecrease = false;
            boolean prevScaleIncrease = false;
            while (true) {
                if (newScale < min) {
                    min = newScale;
                }
                if (newScale > max) {
                    max = newScale;
                }
                List<String> lines = this.splitTextToLines(text, canvasWidth, newScale);
                int n = lines.size();
                Objects.requireNonNull(this.f_96547_);
                int totalTextHeight = (int)((float)(n * 9) * newScale);
                if (this.isTextTooLarge(lines, canvasWidth, canvasHeight, newScale)) {
                    newScale *= 1.0f - scaleStep;
                    prevScaleDecrease = true;
                    if (!prevScaleIncrease) continue;
                    newScale = (min + max) * 0.95f / 2.0f;
                    break block4;
                }
                if (!((float)totalTextHeight < (float)canvasHeight * 0.8f)) break block4;
                prevScaleIncrease = true;
                newScale *= 1.0f + scaleStep;
                if (prevScaleDecrease) break;
            }
            newScale = (min + max) * 1.2f / 2.0f;
        }
        return newScale;
    }

    public boolean isTextTooLarge(List<String> lines, int canvasWidth, int canvasHeight, float scale) {
        int n = lines.size();
        Objects.requireNonNull(this.f_96547_);
        int totalHeight = (int)((float)(n * 9) * scale);
        for (String line : lines) {
            int lineWidth = (int)((float)this.f_96547_.m_92895_(line) * scale);
            if (lineWidth <= canvasWidth) continue;
            return true;
        }
        return totalHeight > canvasHeight;
    }

    public List<String> wrapTextWithNewlines(String text, int maxWidth) {
        String[] paragraphs;
        ArrayList<String> lines = new ArrayList<String>();
        for (String paragraph : paragraphs = text.split("\n")) {
            lines.addAll(this.wrapText(paragraph, maxWidth));
        }
        return lines;
    }

    public List<String> wrapText(String text, int maxWidth) {
        String[] words;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : words = text.split(" ")) {
            if (this.f_96547_.m_92895_(currentLine + word) <= maxWidth) {
                currentLine.append(word).append(" ");
                continue;
            }
            lines.add(currentLine.toString().trim());
            currentLine.setLength(0);
            currentLine.append(word).append(" ");
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString().trim());
        }
        return lines;
    }

    public void drawTextInCanvasWithScissor(PoseStack poseStack, String text, int canvasX, int canvasY, int canvasWidth, int canvasHeight, int scale) {
        int maxWidth = canvasWidth / 1;
        int lineHeight = 10;
        int x = canvasX;
        int y = canvasY;
        List<String> lines = this.splitTextToLines(text, maxWidth, 1.0f);
        for (int i = scale - 1; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (y + lineHeight > canvasY + canvasHeight) break;
            poseStack.m_85836_();
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
            this.drawString(poseStack, line, x / 1, y / 1, 0xFFFFFF);
            poseStack.m_85849_();
            y += lineHeight;
        }
    }

    public void drawTextInCanvas(PoseStack poseStack, String text, int canvasX, int canvasY, int canvasWidth, int canvasHeight, float scale) {
        int maxWidth = (int)((float)canvasWidth / scale);
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = (int)(9.0f * scale);
        int x = canvasX;
        int y = canvasY;
        List<String> lines = this.wrapTextWithNewlines(text, maxWidth);
        for (String line : lines) {
            if (y + lineHeight > canvasY + canvasHeight) break;
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, scale);
            this.f_96547_.m_92889_(poseStack, (Component)Component.m_237113_((String)line), (float)x / scale, (float)y / scale, 0xFFFFFF);
            poseStack.m_85849_();
            y += lineHeight;
        }
    }

    public void drawTextInCanvas(PoseStack poseStack, String text, int canvasX, int canvasY, int canvasWidth, int canvasHeight, float scale, int color) {
        int maxWidth = (int)((float)canvasWidth / scale);
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = (int)(9.0f * scale);
        int x = canvasX;
        int y = canvasY;
        List<String> lines = this.wrapTextWithNewlines(text, maxWidth);
        for (String line : lines) {
            if (y + lineHeight > canvasY + canvasHeight) break;
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, scale);
            this.f_96547_.m_92889_(poseStack, (Component)Component.m_237113_((String)line), (float)x / scale, (float)y / scale, color);
            poseStack.m_85849_();
            y += lineHeight;
        }
    }

    public List<String> splitTextToLines(String text, int canvasWidth, float scale) {
        String[] manualLines;
        ArrayList<String> lines = new ArrayList<String>();
        for (String manualLine : manualLines = text.split("\n")) {
            String[] words;
            StringBuilder currentLine = new StringBuilder();
            for (String word : words = manualLine.split(" ")) {
                Object testLine = currentLine.length() == 0 ? word : currentLine + " " + word;
                int lineWidth = (int)((float)this.f_96547_.m_92895_((String)testLine) * scale);
                if (lineWidth > canvasWidth) {
                    lines.add(currentLine.toString());
                    currentLine = new StringBuilder(word);
                    continue;
                }
                currentLine.append((String)(currentLine.isEmpty() ? word : " " + word));
            }
            if (currentLine.isEmpty()) continue;
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public final T getContainer() {
        return (T)((Object)((ContainerMenuBase)this.f_97732_));
    }

    public final int guiLeft() {
        return this.f_97735_;
    }

    public final int guiTop() {
        return this.f_97736_;
    }

    public final Slot getFocusedSlot() {
        return this.f_97734_;
    }

    public boolean m_97774_(Slot p_97775_, double p_97776_, double p_97777_) {
        return this.m_6774_(p_97775_.f_40220_, p_97775_.f_40221_, 16, 16, p_97776_, p_97777_);
    }

    public void m_97782_(ItemStack p_97783_, int p_97784_, int p_97785_, String p_97786_) {
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85837_(0.0, 0.0, 32.0);
        RenderSystem.m_157182_();
        this.m_93250_(200);
        this.f_96542_.f_115093_ = 200.0f;
        Font font = IClientItemExtensions.of((ItemStack)p_97783_).getFont(p_97783_, IClientItemExtensions.FontContext.ITEM_COUNT);
        if (font == null) {
            font = this.f_96547_;
        }
        this.f_96542_.m_115203_(p_97783_, p_97784_, p_97785_);
        this.f_96542_.m_115174_(font, p_97783_, p_97784_, p_97785_ - (this.f_97711_.m_41619_() ? 0 : 8), p_97786_);
        this.m_93250_(0);
        this.f_96542_.f_115093_ = 0.0f;
    }

    public void m_6305_(@NotNull PoseStack graphics, int mouseX, int mouseY, float partialTick) {
        ItemStack itemstack;
        this.guiLeft = this.getGuiLeft();
        this.guiTop = this.getGuiTop();
        this.m_7333_(graphics);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_7286_(graphics, partialTick, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Background((AbstractContainerScreen)this, graphics, mouseX, mouseY));
        RenderSystem.m_69465_();
        for (Widget widget : this.f_169369_) {
            widget.m_6305_(graphics, mouseX, mouseY, partialTick);
        }
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)i, (double)j, 0.0);
        RenderSystem.m_157182_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_97734_ = null;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int k = 0; k < ((ContainerMenuBase)this.f_97732_).f_38839_.size(); ++k) {
            Slot slot = (Slot)((ContainerMenuBase)this.f_97732_).f_38839_.get(k);
            if (slot.m_6659_()) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                this.m_97799_(graphics, slot);
            }
            if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            this.f_97734_ = slot;
            int l = slot.f_40220_;
            int i1 = slot.f_40221_;
            ScreenIndustrialUpgrade.renderSlotHighlight((PoseStack)graphics, (int)l, (int)i1, (int)this.m_93252_(), (int)this.getSlotColor(k));
        }
        this.m_7027_(graphics, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground((AbstractContainerScreen)this, graphics, mouseX, mouseY));
        ItemStack itemStack = itemstack = this.f_97711_.m_41619_() ? ((ContainerMenuBase)this.f_97732_).m_142621_() : this.f_97711_;
        if (!itemstack.m_41619_()) {
            int l1 = 8;
            int i2 = this.f_97711_.m_41619_() ? 8 : 16;
            String s = null;
            if (!this.f_97711_.m_41619_() && this.f_97710_) {
                itemstack = itemstack.m_41777_();
                itemstack.m_41764_(Mth.m_14167_((float)((float)itemstack.m_41613_() / 2.0f)));
            } else if (this.f_97738_ && this.f_97737_.size() > 1) {
                itemstack = itemstack.m_41777_();
                itemstack.m_41764_(this.f_97720_);
                if (itemstack.m_41619_()) {
                    s = ChatFormatting.YELLOW + "0";
                }
            }
            this.m_97782_(itemstack, mouseX - i - 8, mouseY - j - i2, s);
        }
        if (!this.f_97715_.m_41619_()) {
            float f = (float)(Util.m_137550_() - this.f_97714_) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.f_97715_ = ItemStack.f_41583_;
            }
            int j2 = this.f_97707_.f_40220_ - this.f_97712_;
            int k2 = this.f_97707_.f_40221_ - this.f_97713_;
            int j1 = this.f_97712_ + (int)((float)j2 * f);
            int k1 = this.f_97713_ + (int)((float)k2 * f);
            this.m_97782_(this.f_97715_, j1, k1, null);
        }
        posestack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69482_();
        this.m_7025_(graphics, mouseX, mouseY);
        this.changeParams();
    }

    public void m_97799_(PoseStack p_97800_, Slot p_97801_) {
        Pair pair;
        int i = p_97801_.f_40220_;
        int j = p_97801_.f_40221_;
        ItemStack itemstack = p_97801_.m_7993_();
        boolean flag = false;
        boolean flag1 = p_97801_ == ((AbstractContainerScreenAccessor)((Object)this)).getClickedSlot() && !this.f_97711_.m_41619_() && !this.f_97710_;
        ItemStack itemstack1 = ((ContainerMenuBase)this.f_97732_).m_142621_();
        String s = null;
        if (p_97801_ == ((AbstractContainerScreenAccessor)((Object)this)).getClickedSlot() && !this.f_97711_.m_41619_() && this.f_97710_ && !itemstack.m_41619_()) {
            itemstack = itemstack.m_41777_();
            itemstack.m_41764_(itemstack.m_41613_() / 2);
        } else if (this.f_97738_ && this.f_97737_.contains(p_97801_) && !itemstack1.m_41619_()) {
            if (this.f_97737_.size() == 1) {
                return;
            }
            if (AbstractContainerMenu.m_38899_((Slot)p_97801_, (ItemStack)itemstack1, (boolean)true) && ((ContainerMenuBase)this.f_97732_).m_5622_(p_97801_)) {
                itemstack = itemstack1.m_41777_();
                flag = true;
                AbstractContainerMenu.m_38922_((Set)this.f_97737_, (int)((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType(), (ItemStack)itemstack, (int)(p_97801_.m_7993_().m_41619_() ? 0 : p_97801_.m_7993_().m_41613_()));
                int k = Math.min(itemstack.m_41741_(), p_97801_.m_5866_(itemstack));
                if (itemstack.m_41613_() > k) {
                    s = ChatFormatting.YELLOW.toString() + k;
                    itemstack.m_41764_(k);
                }
            } else {
                this.f_97737_.remove(p_97801_);
                this.m_97818_();
            }
        }
        this.m_93250_(100);
        this.f_96542_.f_115093_ = 100.0f;
        if (itemstack.m_41619_() && p_97801_.m_6659_() && (pair = p_97801_.m_7543_()) != null) {
            TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.f_96541_.m_91258_((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
            ScreenIndustrialUpgrade.m_93200_((PoseStack)p_97800_, (int)i, (int)j, (int)this.m_93252_(), (int)16, (int)16, (TextureAtlasSprite)textureatlassprite);
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                ScreenIndustrialUpgrade.m_93172_((PoseStack)p_97800_, (int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
            }
            RenderSystem.m_69482_();
            this.f_96542_.m_174229_((LivingEntity)this.f_96541_.f_91074_, itemstack, i, j, p_97801_.f_40220_ + p_97801_.f_40221_ * this.f_97726_);
            this.f_96542_.m_115174_(this.f_96547_, itemstack, i, j, s);
        }
        this.f_96542_.f_115093_ = 0.0f;
        this.m_93250_(0);
    }

    public void m_97818_() {
        ItemStack itemstack = ((ContainerMenuBase)this.f_97732_).m_142621_();
        if (!itemstack.m_41619_() && this.f_97738_) {
            if (((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType() == 2) {
                this.f_97720_ = itemstack.m_41741_();
            } else {
                this.f_97720_ = itemstack.m_41613_();
                for (Slot slot : this.f_97737_) {
                    ItemStack itemstack1 = itemstack.m_41777_();
                    ItemStack itemstack2 = slot.m_7993_();
                    int i = itemstack2.m_41619_() ? 0 : itemstack2.m_41613_();
                    AbstractContainerMenu.m_38922_((Set)this.f_97737_, (int)((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType(), (ItemStack)itemstack1, (int)i);
                    int j = Math.min(itemstack1.m_41741_(), slot.m_5866_(itemstack1));
                    if (itemstack1.m_41613_() > j) {
                        itemstack1.m_41764_(j);
                    }
                    this.f_97720_ -= itemstack1.m_41613_() - i;
                }
            }
        }
    }

    protected void m_7286_(@NotNull PoseStack graphics, float partialTick, int mouseX, int mouseY) {
        this.drawBackgroundAndTitle(graphics, partialTick, mouseX - this.f_97735_, mouseY - this.f_97736_);
        for (ScreenWidget element : this.elements) {
            ScreenWidget guiElement = element;
            if (!guiElement.visible()) continue;
            guiElement.drawBackground(graphics, this.guiLeft, this.guiTop);
        }
    }

    public void drawItemStack(int x, int y, ItemStack stack) {
        this.f_96542_.m_115123_(stack, x + this.guiLeft(), y + this.guiTop());
        this.f_96542_.m_115169_(this.f_96547_, stack, x + this.guiLeft(), y + this.guiTop());
    }

    public void drawItemStack(ItemStack stack, int x, int y) {
        this.f_96542_.m_115123_(stack, x + this.guiLeft(), y + this.guiTop());
        this.f_96542_.m_115169_(this.f_96547_, stack, x + this.guiLeft(), y + this.guiTop());
    }

    protected void drawBackgroundAndTitle(@NotNull PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        ScreenIndustrialUpgrade.bindTexture(this.getTexture());
        this.m_93228_(poseStack, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        this.drawXCenteredString(poseStack, this.f_97726_ / 2, 6, this.f_96539_, 0x404040, false);
    }

    protected void m_7027_(@NotNull PoseStack graphics, int mouseX, int mouseY) {
        this.drawForegroundLayer(graphics, mouseX - this.f_97735_, mouseY - this.f_97736_);
        this.flushTooltips(graphics);
    }

    protected void drawForegroundLayer(@NotNull PoseStack graphics, int mouseX, int mouseY) {
        if (((ContainerMenuBase)this.f_97732_).base instanceof BlockEntityUpgrade) {
            this.handleUpgradeTooltip(mouseX, mouseY);
        }
        for (ScreenWidget element : this.elements) {
            ScreenWidget guiElement = element;
            if (!guiElement.visible()) continue;
            guiElement.drawForeground(graphics, mouseX, mouseY);
        }
    }

    private void handleUpgradeTooltip(int n, int n2) {
        if (n >= 0 && n <= 12 && n2 >= 0 && n2 <= 12) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(Localization.translate("iu.generic.text.upgrade"));
            for (ItemStack itemStack : ScreenIndustrialUpgrade.getCompatibleUpgrades((BlockEntityUpgrade)((ContainerMenuBase)this.f_97732_).base)) {
                arrayList.add(itemStack.m_41786_().getString());
            }
            this.drawTooltip(n, n2, arrayList);
        }
    }

    public boolean m_6050_(double d, double d2, double d3) {
        ScrollDirection scrollDirection = d3 != 0.0 ? (d3 < 0.0 ? ScrollDirection.down : ScrollDirection.up) : ScrollDirection.stopped;
        List listButton = this.f_169369_;
        for (Widget button : listButton) {
            AbstractWidget slider;
            if (button instanceof VerticalSliderListWidget) {
                slider = (VerticalSliderListWidget)button;
                if (scrollDirection != ScrollDirection.stopped) {
                    slider.handleMouseWheel(scrollDirection, (int)d, (int)d2);
                }
            }
            if (button instanceof SliderWidget) {
                slider = (SliderWidget)button;
                if (scrollDirection != ScrollDirection.stopped) {
                    slider.handleMouseWheel(scrollDirection, (int)d, (int)d2);
                }
            }
            if (!(button instanceof VerticalSliderWidget)) continue;
            slider = (VerticalSliderWidget)button;
            if (scrollDirection == ScrollDirection.stopped) continue;
            slider.handleMouseWheel(scrollDirection, (int)d, (int)d2);
        }
        return super.m_6050_(d, d2, d3);
    }

    protected void mouseClicked(int i, int j, int k) {
        for (Widget widget : this.f_169369_) {
            if (!(widget instanceof GuiEventListener)) continue;
            ((GuiEventListener)widget).m_6375_((double)i, (double)j, k);
        }
    }

    public boolean m_6375_(double d, double d2, int n) {
        MouseButton mouseButton = MouseButton.get(n);
        boolean bl = false;
        d -= (double)this.f_97735_;
        d2 -= (double)this.f_97736_;
        for (ScreenWidget element : this.elements) {
            ScreenWidget guiElement = element;
            if (!guiElement.visible()) continue;
            bl |= guiElement.onMouseClick((int)d, (int)d2, mouseButton);
        }
        if (bl) {
            return true;
        }
        this.mouseClicked((int)(d += (double)this.f_97735_), (int)(d2 += (double)this.f_97736_), n);
        return super.m_6375_(d, d2, n);
    }

    public boolean m_7979_(double d, double d2, int n, double d3, double d4) {
        for (Widget widget : this.f_169369_) {
            if (!(widget instanceof GuiEventListener)) continue;
            ((GuiEventListener)widget).m_7979_(d, d2, n, d3, d4);
        }
        return super.m_7979_(d, d2, n, d3, d4);
    }

    public void drawTexturedRect(PoseStack graphics, double x, double y, double width, double height, double texX, double texY) {
        this.drawTexturedRect(graphics, x, y, width, height, texX, texY, false);
    }

    public void drawTexturedRect(PoseStack graphics, double x, double y, double width, double height, double texX, double texY, boolean mirrorX) {
        this.drawTexturedRect(graphics, x, y, width, height, texX / 256.0, texY / 256.0, (texX + width) / 256.0, (texY + height) / 256.0, mirrorX);
    }

    public void drawTexturedRect(PoseStack graphics, double x, double y, double width, double height, double uS, double vS, double uE, double vE, boolean mirrorX) {
        double xE = (x += (double)this.guiLeft()) + width;
        double yE = (y += (double)this.guiTop()) + height;
        if (mirrorX) {
            double tmp = uS;
            uS = uE;
            uE = tmp;
        }
        this.m_93228_(graphics, (int)x, (int)y, (int)uS, (int)vS, (int)width, (int)height);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        Matrix4f matrix = graphics.m_85850_().m_85861_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix, (float)x, (float)y, 0.0f).m_7421_((float)uS, (float)vS).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)x, (float)yE, 0.0f).m_7421_((float)uS, (float)vE).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)xE, (float)yE, 0.0f).m_7421_((float)uE, (float)vE).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)xE, (float)y, 0.0f).m_7421_((float)uE, (float)vS).m_5752_();
        tessellator.m_85914_();
    }

    public void drawSprite(PoseStack graphics, double x, double y, double width, double height, TextureAtlasSprite sprite, int color, double textureSize, boolean wrapX, boolean wrapY) {
        double tileWidth;
        if (sprite == null) {
            sprite = ((TextureAtlas)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_)).m_118316_(MissingTextureAtlasSprite.m_118071_());
        }
        double startX = x;
        double startY = y;
        double tileSize = 16.0;
        double u0 = sprite.m_118409_();
        double v0 = sprite.m_118411_();
        double u1 = sprite.m_118410_();
        double v1 = sprite.m_118412_();
        double uSize = u1 - u0;
        double vSize = v1 - v0;
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        Matrix4f matrix = graphics.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        double remX = width % tileSize;
        double remY = height % tileSize;
        for (double tileX = startX; tileX < startX + width; tileX += tileWidth) {
            double tileHeight;
            tileWidth = tileSize;
            double uStart = u0;
            if (tileX == startX && remX > 0.0) {
                tileWidth = remX;
                uStart = u0 + uSize * (1.0 - remX / tileSize);
            }
            if (tileX + tileWidth > startX + width) {
                tileWidth = startX + width - tileX;
                uStart = u0;
            }
            double tileXEnd = tileX + tileWidth;
            double uEnd = uStart + (tileXEnd - tileX) / tileSize * uSize;
            for (double tileY = startY; tileY < startY + height; tileY += tileHeight) {
                tileHeight = tileSize;
                double vStart = v0;
                if (tileY == startY && remY > 0.0) {
                    tileHeight = remY;
                    vStart = v0 + vSize * (1.0 - remY / tileSize);
                }
                if (tileY + tileHeight > startY + height) {
                    tileHeight = startY + height - tileY;
                    vStart = v0;
                }
                double tileYEnd = tileY + tileHeight;
                double vEnd = vStart + (tileYEnd - tileY) / tileSize * vSize;
                buffer.m_85982_(matrix, (float)tileX, (float)tileY, 0.0f).m_7421_((float)uStart, (float)vStart).m_6122_(red, green, blue, alpha).m_5752_();
                buffer.m_85982_(matrix, (float)tileX, (float)tileYEnd, 0.0f).m_7421_((float)uStart, (float)vEnd).m_6122_(red, green, blue, alpha).m_5752_();
                buffer.m_85982_(matrix, (float)tileXEnd, (float)tileYEnd, 0.0f).m_7421_((float)uEnd, (float)vEnd).m_6122_(red, green, blue, alpha).m_5752_();
                buffer.m_85982_(matrix, (float)tileXEnd, (float)tileY, 0.0f).m_7421_((float)uEnd, (float)vStart).m_6122_(red, green, blue, alpha).m_5752_();
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public void drawItem(int x, int y, ItemStack itemStack) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        itemRenderer.m_115203_(itemStack, x, y);
    }

    public void drawColoredRect(PoseStack poseStack, int x, int y, int width, int height, int color, BufferBuilder bufferBuilder) {
        int alpha = color >>> 24;
        boolean translucent = alpha != 255 && alpha != 0;
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        int x2 = (x += this.f_97735_) + width;
        int y2 = (y += this.f_97736_) + height;
        boolean z = false;
        if (translucent) {
            RenderSystem.m_69478_();
        }
        bufferBuilder.m_85982_(matrix4f, (float)x, (float)y, (float)z).m_193479_(color).m_5752_();
        bufferBuilder.m_85982_(matrix4f, (float)x, (float)y2, (float)z).m_193479_(color).m_5752_();
        bufferBuilder.m_85982_(matrix4f, (float)x2, (float)y2, (float)z).m_193479_(color).m_5752_();
        bufferBuilder.m_85982_(matrix4f, (float)x2, (float)y, (float)z).m_193479_(color).m_5752_();
        if (translucent) {
            RenderSystem.m_69461_();
        }
    }

    public int draw(PoseStack poseStack, String text, int x, int y, int color) {
        if (this.f_96547_ == null) {
            this.f_96547_ = Minecraft.m_91087_().f_91062_;
        }
        this.f_96547_.m_92883_(poseStack, text, (float)(x + this.guiLeft - this.f_97735_), (float)(y + this.guiTop - this.f_97736_), color);
        return x;
    }

    public int drawString(PoseStack poseStack, String text, int x, int y, int color) {
        if (this.f_96547_ == null) {
            this.f_96547_ = Minecraft.m_91087_().f_91062_;
        }
        this.f_96547_.m_92883_(poseStack, text, (float)(x + this.guiLeft - this.f_97735_), (float)(y + this.guiTop - this.f_97736_), color);
        return x;
    }

    public int drawString(PoseStack poseStack, int x, int y, String text, int color) {
        if (this.f_96547_ == null) {
            this.f_96547_ = Minecraft.m_91087_().f_91062_;
        }
        this.f_96547_.m_92883_(poseStack, text, (float)(x + this.guiLeft - this.f_97735_), (float)(y + this.guiTop - this.f_97736_), color);
        return x;
    }

    public int drawString(PoseStack poseStack, int x, int y, String text, int color, boolean shadow) {
        if (this.f_96547_ == null) {
            this.f_96547_ = Minecraft.m_91087_().f_91062_;
        }
        if (shadow) {
            this.f_96547_.m_92750_(poseStack, text, (float)(x + this.guiLeft - this.f_97735_), (float)(y + this.guiTop - this.f_97736_), color);
        } else {
            this.f_96547_.m_92883_(poseStack, text, (float)(x + this.guiLeft - this.f_97735_), (float)(y + this.guiTop - this.f_97736_), color);
        }
        return x;
    }

    public void drawXCenteredString(PoseStack graphics, int n, int n2, Component component, int n3, boolean bl) {
        this.drawCenteredString(graphics, n, n2, component, n3, bl, true, false);
    }

    public void drawXCenteredString(PoseStack graphics, int n, int n2, String component, int n3, boolean bl) {
        this.drawCenteredString(graphics, n, n2, component, n3, bl, true, false);
    }

    public void drawXYCenteredString(PoseStack graphics, int n, int n2, String string, int n3, boolean bl) {
        this.drawCenteredString(graphics, n, n2, string, n3, bl, true, true);
    }

    public void drawCenteredString(PoseStack graphics, int n, int n2, String string, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            n -= this.getStringWidth(string) / 2;
        }
        if (bl3) {
            n2 -= 4;
        }
        this.f_96547_.m_92883_(graphics, string, (float)(this.getGuiLeft() + n), (float)(this.getGuiTop() + n2), n3);
    }

    public void drawCenteredString(PoseStack graphics, int n, int n2, Component component, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            n -= this.getStringWidth(component) / 2;
        }
        if (bl3) {
            n2 -= 4;
        }
        this.f_96547_.m_92883_(graphics, component.getString(), (float)(this.getGuiLeft() + n), (float)(this.getGuiTop() + n2), n3);
    }

    public int getStringWidth(String string) {
        return this.f_96547_.m_92895_(string);
    }

    public int getStringWidth(Component component) {
        return this.f_96547_.m_92852_((FormattedText)component);
    }

    public String trimStringToWidth(String string, int n) {
        return this.f_96547_.m_92837_(string, n, false);
    }

    public String trimStringToWidthReverse(String string, int n) {
        return this.f_96547_.m_92837_(string, n, true);
    }

    public void drawTooltip(PoseStack poseStack, int x, int y, ItemStack stack) {
        assert (!ModUtils.isEmpty(stack));
        this.m_6057_(poseStack, stack, x, y);
    }

    public void drawTooltipOnlyName(PoseStack poseStack, int x, int y, ItemStack stack, List<String> strings) {
        if (stack.m_41619_()) {
            return;
        }
        ArrayList<Component> tooltipComponents = new ArrayList<Component>();
        tooltipComponents.add(stack.m_41611_());
        strings.forEach(s -> tooltipComponents.add((Component)Component.m_237113_((String)s)));
        this.m_96597_(poseStack, tooltipComponents, x, y);
    }

    public void drawTooltip(int n, int n2, List<String> list) {
        this.queuedTooltips.add(new Tooltip(list, n, n2));
    }

    protected void flushTooltips(PoseStack graphics) {
        ArrayList<Tooltip> tooltips = new ArrayList<Tooltip>(this.queuedTooltips);
        ArrayList<Tooltip> tooltipsToRender = new ArrayList<Tooltip>();
        ArrayList<Rectangle> usedAreas = new ArrayList<Rectangle>();
        for (int i = tooltips.size() - 1; i >= 0; --i) {
            Tooltip tooltip = (Tooltip)tooltips.get(i);
            int maxWidth = 0;
            for (FormattedText formattedText : tooltip.text) {
                int lineWidth = Minecraft.m_91087_().f_91062_.m_92852_(formattedText);
                if (lineWidth <= maxWidth) continue;
                maxWidth = lineWidth;
            }
            int tooltipWidth = maxWidth + 8;
            int n = tooltip.text.size() * 10 + 8;
            Rectangle tooltipArea = new Rectangle(tooltip.x, tooltip.y, tooltipWidth, n);
            boolean overlaps = false;
            for (Rectangle area : usedAreas) {
                if (!tooltipArea.intersects(area)) continue;
                overlaps = true;
                break;
            }
            if (overlaps) continue;
            usedAreas.add(tooltipArea);
            tooltipsToRender.add(tooltip);
        }
        Collections.reverse(tooltipsToRender);
        for (Tooltip tooltip : tooltipsToRender) {
            this.m_169388_(graphics, tooltip.text, Optional.empty(), tooltip.x, tooltip.y);
        }
        this.queuedTooltips.clear();
    }

    protected void addWidget(ScreenWidget guiElement) {
        this.elements.add(guiElement);
    }

    public final void bindTexture() {
        ScreenIndustrialUpgrade.bindTexture(this.getTexture());
    }

    protected abstract ResourceLocation getTexture();

    public void drawTexturedModalRect(PoseStack poseStack, int i, int i1, int i2, int i3, int i4, int i5) {
        this.m_93228_(poseStack, i, i1, i2, i3, i4, i5);
    }

    private static class Tooltip {
        final int x;
        final int y;
        final List<Component> text = new LinkedList<Component>();

        Tooltip(List<String> list, int n, int n2) {
            list.forEach(s -> this.text.add((Component)Component.m_237113_((String)s)));
            this.x = n;
            this.y = n2;
        }
    }
}

