/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.componets.ComponentRenderInventory;
import com.denfop.componets.EnumTypeComponentSlot;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.Inventory;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;

public abstract class ScreenMain<T extends ContainerMenuBase<? extends CustomWorldContainer>>
extends ScreenIndustrialUpgrade<T> {
    private final EnumTypeStyle style;
    public boolean isBlack = false;
    protected ScreenWidget inventory;
    protected ScreenWidget slots;
    protected List<Inventory> inventoryList = new ArrayList<Inventory>();
    protected List<ScreenWidget> componentList = new ArrayList<ScreenWidget>();

    public ScreenMain(T container) {
        super(container);
        this.style = EnumTypeStyle.DEFAULT;
        this.inventory = new ScreenWidget(this, 7, 83, this.getComponent(), new WidgetDefault<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.ALL)));
        this.slots = new ScreenWidget(this, 0, 0, this.getComponent(), new WidgetDefault<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.SLOTS_UPGRADE)));
        this.componentList.add(this.inventory);
        this.componentList.add(this.slots);
    }

    public ScreenMain(T container, EnumTypeStyle style) {
        super(container);
        this.style = style;
        this.inventory = new ScreenWidget(this, 7, 83, this.getComponent(), new WidgetDefault<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.ALL)));
        this.slots = new ScreenWidget(this, 0, 0, this.getComponent(), new WidgetDefault<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.SLOTS_UPGRADE)));
        this.componentList.add(this.inventory);
        this.componentList.add(this.slots);
    }

    public ScreenMain(T container, EnumTypeComponent style) {
        super(container);
        this.style = this.getStyle(style);
        this.inventory = new ScreenWidget(this, 7, 83, this.getComponent(), new WidgetDefault<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.ALL)));
        this.slots = new ScreenWidget(this, 0, 0, this.getComponent(), new WidgetDefault<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.SLOTS_UPGRADE)));
        this.componentList.add(this.inventory);
        this.componentList.add(this.slots);
    }

    public EnumTypeComponent getComponent() {
        switch (this.style) {
            case ADVANCED: {
                return EnumTypeComponent.ADVANCED;
            }
            case IMPROVED: {
                return EnumTypeComponent.IMPROVED;
            }
            case PERFECT: {
                return EnumTypeComponent.PERFECT;
            }
            case PHOTONIC: {
                return EnumTypeComponent.PHOTONIC;
            }
            case STEAM: {
                return EnumTypeComponent.STEAM_DEFAULT;
            }
            case BIO: {
                return EnumTypeComponent.BIO_DEFAULT;
            }
            case SPACE: {
                return EnumTypeComponent.SPACE_DEFAULT;
            }
        }
        return EnumTypeComponent.DEFAULT;
    }

    public Font getFontRenderer() {
        return Minecraft.m_91087_().f_91062_;
    }

    public EnumTypeStyle getStyle(EnumTypeComponent style) {
        switch (style) {
            case ADVANCED: {
                return EnumTypeStyle.ADVANCED;
            }
            case IMPROVED: {
                return EnumTypeStyle.IMPROVED;
            }
            case PERFECT: {
                return EnumTypeStyle.PERFECT;
            }
            case PHOTONIC: {
                return EnumTypeStyle.PHOTONIC;
            }
            case STEAM_DEFAULT: {
                return EnumTypeStyle.STEAM;
            }
            case BIO_DEFAULT: {
                return EnumTypeStyle.BIO;
            }
            case SPACE_DEFAULT: {
                return EnumTypeStyle.SPACE;
            }
        }
        return EnumTypeStyle.DEFAULT;
    }

    public EnumTypeStyle getStyle() {
        return this.style;
    }

    public void addComponent(ScreenWidget component) {
        this.componentList.add(component);
    }

    public void removeComponent(int index) {
        this.componentList.remove(index);
    }

    public void removeComponent(ScreenWidget component) {
        this.componentList.remove((Object)component);
    }

    public void drawForeground(PoseStack poseStack, int mouseX, int mouseY) {
        this.componentList.forEach(guiComponent -> guiComponent.drawForeground(poseStack, mouseX, mouseY));
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        int xMin = (this.f_96543_ - this.f_97726_) / 2;
        int yMin = (this.f_96544_ - this.f_97727_) / 2;
        int x = i - xMin;
        int y = j - yMin;
        this.componentList.forEach(guiComponent -> guiComponent.buttonClicked(x, y));
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        this.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        this.drawBackground(poseStack);
    }

    protected void drawBackground(PoseStack poseStack) {
        this.componentList.forEach(guiComponent -> guiComponent.drawBackground(poseStack, this.guiLeft(), this.guiTop()));
    }

    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
    }

    @Override
    public void drawTextInCanvasWithScissor(PoseStack poseStack, String text, int canvasX, int canvasY, int canvasWidth, int canvasHeight, int scale) {
        int maxWidth = canvasWidth / 1;
        int lineHeight = 10;
        int x = canvasX;
        int y = canvasY;
        List<String> lines = this.splitTextToLines(text, maxWidth, 1.0f);
        for (int i = scale - 1; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (y + lineHeight > canvasY + canvasHeight) break;
            poseStack.m_85836_();
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
            this.drawString(poseStack, line, x / 1, y / 1, 0xFFFFFF);
            poseStack.m_85849_();
            y += lineHeight;
        }
    }

    @Override
    protected void drawBackgroundAndTitle(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.m_93228_(poseStack, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        String name = this.container.base.m_5446_().getString();
        int textWidth = this.getStringWidth(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        int centerX = this.guiLeft + this.f_97726_ / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.guiTop + 6) / scale);
        this.f_96547_.m_92883_(poseStack, name, (float)textX, (float)textY, 0x404040);
        poseStack.m_85841_(1.0f / scale, 1.0f / scale, 1.0f);
        poseStack.m_85849_();
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.drawForeground(poseStack, par1, par2);
    }

    public void updateTickInterface() {
    }
}

