/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.TankWidget;
import com.denfop.api.widget.TooltipWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.mechanism.BlockEntityRocketLaunchPad;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuRocketLaunchPad;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class ScreenRocketLaunchPad<T extends ContainerMenuRocketLaunchPad>
extends ScreenMain<ContainerMenuRocketLaunchPad> {
    public ScreenRocketLaunchPad(ContainerMenuRocketLaunchPad guiContainer) {
        super(guiContainer);
        this.f_97727_ = 220;
        this.componentList.clear();
        this.addWidget(new TankWidget(this, 106, 15, 12, 35, (IFluidTank)((BlockEntityRocketLaunchPad)guiContainer.base).tank){

            @Override
            public void drawBackground(PoseStack poseStack, int mouseX, int mouseY) {
                1.bindCommonTexture();
                FluidStack fs = this.tank.getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    int fluidX = this.f_93620_;
                    int fluidY = this.f_93621_;
                    int fluidWidth = 12;
                    int fluidHeight = 35;
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 1.getBlockTextureMap().m_118316_(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
                    1.bindBlockTexture();
                    this.gui.drawSprite(poseStack, mouseX + fluidX, (double)mouseY + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    1.bindCommonTexture();
                }
            }
        });
        this.componentList.add(new ScreenWidget(this, 56, 12, EnumTypeComponent.ENERGY_HEIGHT_1, new WidgetDefault<Energy>(((BlockEntityRocketLaunchPad)guiContainer.base).energy)));
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        for (int i = 0; i < 9; ++i) {
            if (((BlockEntityRocketLaunchPad)((ContainerMenuRocketLaunchPad)this.container).base).tanks[i].getFluidAmount() <= 0) continue;
            FluidStack fs = ((BlockEntityRocketLaunchPad)((ContainerMenuRocketLaunchPad)this.container).base).tanks[i].getFluid();
            new TooltipWidget(this, 8 + i * 18, 60, 18, 18).withTooltip(fs.getFluid().getFluidType().getDescription().getString() + ": " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb")).drawForeground(poseStack, par1, par2);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        for (int i = 0; i < 9; ++i) {
            if (((BlockEntityRocketLaunchPad)((ContainerMenuRocketLaunchPad)this.container).base).tanks[i].getFluidAmount() <= 0) continue;
            FluidStack fs = ((BlockEntityRocketLaunchPad)((ContainerMenuRocketLaunchPad)this.container).base).tanks[i].getFluid();
            int fluidX = 7 + i * 18 + 1;
            int fluidY = 60;
            int fluidWidth = 16;
            int fluidHeight = 16;
            Fluid fluid = fs.getFluid();
            IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
            TextureAtlasSprite sprite = ScreenWidget.getBlockTextureMap().m_118316_(extensions.getStillTexture(fs));
            int color = extensions.getTintColor();
            ScreenWidget.bindBlockTexture();
            this.drawSprite(poseStack, this.guiLeft + fluidX, this.guiTop + fluidY, fluidWidth, fluidHeight, sprite, color, 1.0, false, false);
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/gui_rocket_pad.png");
    }
}

