/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.widget.TooltipWidget;
import com.denfop.blockentity.base.BlockEntitySolarGeneratorEnergy;
import com.denfop.containermenu.ContainerMenuSolarGeneratorEnergy;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenSolarGeneratorEnergy<T extends ContainerMenuSolarGeneratorEnergy>
extends ScreenMain<ContainerMenuSolarGeneratorEnergy> {
    private static final ResourceLocation background = new ResourceLocation("industrialupgrade", "textures/gui/SunnariumGenerator.png".toLowerCase());
    private final ContainerMenuSolarGeneratorEnergy container;
    private final String name;

    public ScreenSolarGeneratorEnergy(ContainerMenuSolarGeneratorEnergy container1) {
        super(container1, ((BlockEntitySolarGeneratorEnergy)container1.base).getStyle());
        this.componentList.clear();
        this.container = container1;
        this.name = Localization.translate(((BlockEntitySolarGeneratorEnergy)container1.base).getName());
    }

    @Override
    protected void drawBackgroundAndTitle(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft(), this.guiTop(), 0, 0, this.f_97726_, this.f_97727_);
        String name = Localization.translate(((BlockEntitySolarGeneratorEnergy)this.container.base).getName());
        int textWidth = this.getStringWidth(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        int centerX = this.guiLeft() + this.f_97726_ / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.guiTop() + 6) / scale);
        this.f_96547_.m_92883_(poseStack, name, (float)textX, (float)textY, 0x404040);
        poseStack.m_85849_();
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(poseStack, mouseX, mouseY);
        this.handleUpgradeTooltip(mouseX, mouseY);
        String tooltip = "SE: " + ModUtils.getString(((BlockEntitySolarGeneratorEnergy)this.container.base).sunenergy.getEnergy());
        new TooltipWidget(this, 66, 33, 53, 10).withTooltip(tooltip).drawForeground(poseStack, mouseX, mouseY);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_96547_.m_92883_(poseStack, Localization.translate("gui.SuperSolarPanel.generating") + ": " + (int)((BlockEntitySolarGeneratorEnergy)this.container.base).generation + Localization.translate("iu.machines_work_energy_type_se"), 29.0f, 61.0f, ModUtils.convertRGBcolorToInt(13, 229, 34));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.solar_generator_info"));
            List<String> compatibleUpgrades = ListInformationUtils.solar;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float f, int x, int y) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenSolarGeneratorEnergy.bindTexture(background);
        int j = this.guiLeft();
        int k = this.guiTop();
        this.drawBackground(poseStack);
        ScreenSolarGeneratorEnergy.bindTexture(background);
        if (((BlockEntitySolarGeneratorEnergy)this.container.base).sunenergy.getEnergy() > 0.0) {
            int i1 = (int)(52.0 * ((BlockEntitySolarGeneratorEnergy)this.container.base).sunenergy.getFillRatio());
            this.drawTexturedModalRect(poseStack, j + 66, k + 33, 179, 3, i1 + 1, 10);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenSolarGeneratorEnergy.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, j + 3, k + 3, 0, 0, 10, 10);
    }

    @Override
    protected ResourceLocation getTexture() {
        return background;
    }
}

