/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.sound.AudioFixer;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.mechanism.BlockEntitySolidCooling;
import com.denfop.componets.ComponentButton;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.CoolComponent;
import com.denfop.containermenu.ContainerMenuSolidCoolMachine;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class ScreenSolidCoolMachine<T extends ContainerMenuSolidCoolMachine>
extends ScreenMain<ContainerMenuSolidCoolMachine> {
    public ContainerMenuSolidCoolMachine container;
    public String name;

    public ScreenSolidCoolMachine(ContainerMenuSolidCoolMachine guiContainer) {
        super(guiContainer);
        this.container = guiContainer;
        this.name = Localization.translate(((BlockEntitySolidCooling)guiContainer.base).getName());
        this.addComponent(new ScreenWidget(this, 3, 14, EnumTypeComponent.SOUND_BUTTON, new WidgetDefault<ComponentSoundButton>(new ComponentSoundButton((BlockEntityBase)((Object)this.container.base), 10, (AudioFixer)((Object)this.container.base)))));
        this.componentList.add(new ScreenWidget(this, 51, 41, EnumTypeComponent.COOL_ENERGY_WEIGHT, new WidgetDefault<CoolComponent>(((BlockEntitySolidCooling)this.container.base).cold)));
        this.componentList.add(new ScreenWidget(this, 20, 37, EnumTypeComponent.WORK_BUTTON, new WidgetDefault<1>(new ComponentButton((BlockEntityBase)((Object)this.container.base), 2, ""){

            @Override
            public String getText() {
                return ((BlockEntitySolidCooling)this.getEntityBlock()).work ? Localization.translate("turn_off") : Localization.translate("turn_on");
            }

            @Override
            public boolean active() {
                return !((BlockEntitySolidCooling)this.getEntityBlock()).work;
            }
        })));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.cool_storage.info_main"));
            List<String> compatibleUpgrades = ListInformationUtils.cooling;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        if (((BlockEntitySolidCooling)this.container.base).time != 0) {
            List<Double> time = ModUtils.Time(((BlockEntitySolidCooling)this.container.base).time);
            String timer = Localization.translate("iu.timetoend") + time.get(1) + Localization.translate("iu.minutes") + time.get(2) + Localization.translate("iu.seconds");
            this.f_96547_.m_92883_(poseStack, timer, 20.0f, 70.0f, 0x404040);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenSolidCoolMachine.bindTexture(this.getTexture());
        int xOffset = this.guiLeft;
        int yOffset = this.guiTop;
        ScreenSolidCoolMachine.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, xOffset + 3, yOffset + 3, 0, 0, 10, 10);
        ScreenSolidCoolMachine.bindTexture(this.getTexture());
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guimachine.png");
    }
}

