/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.agriculture;

import com.denfop.IUItem;
import com.denfop.api.agriculture.EnumSoil;
import com.denfop.api.agriculture.ICrop;
import com.denfop.api.agriculture.ICropItem;
import com.denfop.api.agriculture.genetics.GeneticsManager;
import com.denfop.api.agriculture.genetics.Genome;
import com.denfop.api.pollution.ChunkLevel;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.tiles.crop.TileEntityCrop;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public class CropNetwork {
    public static CropNetwork instance;
    Map<Integer, ICrop> cropMap = new HashMap<Integer, ICrop>();
    Map<ResourceKey<Level>, Map<ChunkPos, List<TileEntityCrop>>> mapWorldCrop = new HashMap<ResourceKey<Level>, Map<ChunkPos, List<TileEntityCrop>>>();

    public static void init() {
        if (instance == null) {
            instance = new CropNetwork();
        }
    }

    public List<TileEntityCrop> getCropsFromChunk(Level world, ChunkPos chunkPos) {
        Map map = this.mapWorldCrop.computeIfAbsent((ResourceKey<Level>)world.m_46472_(), k -> new HashMap());
        return map.computeIfAbsent(chunkPos, k -> new ArrayList());
    }

    public void addNewCropToWorld(TileEntityCrop crop) {
        Map<ChunkPos, List<TileEntityCrop>> map = this.mapWorldCrop.get(crop.getWorld().m_46472_());
        if (map == null) {
            map = new HashMap<ChunkPos, List<TileEntityCrop>>();
            ChunkPos chunkPos = new ChunkPos(crop.getPos());
            ArrayList<TileEntityCrop> list = new ArrayList<TileEntityCrop>();
            list.add(crop);
            map.put(chunkPos, list);
            this.mapWorldCrop.put((ResourceKey<Level>)crop.getWorld().m_46472_(), map);
        } else {
            ChunkPos chunkPos = new ChunkPos(crop.getPos());
            List<TileEntityCrop> list = map.get(chunkPos);
            if (list == null) {
                list = new ArrayList<TileEntityCrop>();
                list.add(crop);
                map.put(chunkPos, list);
            } else {
                list.add(crop);
            }
        }
    }

    public void removeCropFromWorld(TileEntityCrop crop) {
        ChunkPos chunkPos;
        List<TileEntityCrop> list;
        Map<ChunkPos, List<TileEntityCrop>> map = this.mapWorldCrop.get(crop.getWorld().m_46472_());
        if (map != null && (list = map.get(chunkPos = new ChunkPos(crop.getPos()))) != null) {
            list.remove(crop);
        }
    }

    public CropNetwork getInstance() {
        return instance;
    }

    public Map<Integer, ICrop> getCropMap() {
        return this.cropMap;
    }

    public ICrop getCropFromStack(ItemStack stack, Genome genome) {
        if (stack.m_41720_() instanceof ICropItem) {
            ICrop crop = ((ICropItem)stack.m_41720_()).getCrop(stack.m_41773_(), stack).copy();
            GeneticsManager.instance.loadGenomeToCrop(genome, crop);
            return crop;
        }
        return null;
    }

    public ICrop getCropFromStack(ItemStack stack) {
        if (stack.m_41720_() instanceof ICropItem) {
            return ((ICropItem)stack.m_41720_()).getCrop(stack.m_41773_(), stack);
        }
        return null;
    }

    public ICrop getCrop(int id) {
        return this.cropMap.get(id);
    }

    public ICrop canCropCombine(List<ICrop> crops) {
        for (ICrop crop : this.cropMap.values()) {
            if (!crop.isCombine() || !crop.isCombineWithCrops(crops)) continue;
            return crop.copy();
        }
        return null;
    }

    public boolean canPlantCrop(ItemStack stack, Level world, BlockPos pos, BlockState downBlock, Biome biome) {
        ICrop crop = this.getCropFromStack(stack);
        if (crop == null) {
            return false;
        }
        if (crop.isIgnoreSoil() || crop.getSoil().getState() == downBlock && !crop.getSoil().isIgnore() || crop.getSoil().getBlock() == downBlock.m_60734_() && crop.getSoil().isIgnore() || crop.getSoil() == EnumSoil.FARMLAND && downBlock.m_60734_() == IUItem.humus.getBlock(0)) {
            return crop.canGrowInBiome(biome, world);
        }
        return false;
    }

    public void addCrop(ICrop cropBase) {
        this.cropMap.putIfAbsent(cropBase.getId(), cropBase);
    }

    public boolean canGrow(Level world, BlockPos pos, ChunkPos chunkPos, ICrop crop, Radiation radLevel, ChunkAccess chunk, Biome biome, ChunkLevel chunkLevel) {
        boolean day;
        ChunkLevel air;
        int light;
        if ((radLevel == null || radLevel.getLevel().ordinal() <= crop.getRadiationRequirements().ordinal()) && this.isWaterNearby(world, pos, crop) && (light = world.m_45524_(pos, 0)) >= crop.getLightLevel() && ((air = PollutionManager.pollutionManager.getChunkLevelAir(chunkPos)) == null || air.getLevelPollution().ordinal() <= crop.getAirRequirements().ordinal()) && (chunkLevel == null || chunkLevel.getLevelPollution().ordinal() <= crop.getSoilRequirements().ordinal()) && ((day = world.m_46461_()) && crop.isSun() || !day && crop.isNight())) {
            boolean rain = world.m_46471_();
            boolean thundering = world.m_46470_();
            if (rain && crop.getWeatherResistance() >= 1 || thundering && crop.getWeatherResistance() >= 2 || !rain && !thundering) {
                return crop.canGrowInBiome(biome, world);
            }
        }
        return false;
    }

    public boolean canMultiGrow(Level world, BlockPos pos, ChunkPos chunkPos, ICrop crop, Radiation radLevel, ChunkAccess chunk, Biome biome, ChunkLevel chunkLevel) {
        boolean day;
        ChunkLevel air;
        int light;
        if (radLevel.getLevel().ordinal() <= crop.getRadiationRequirements().ordinal() && (light = world.m_45524_(pos, 0)) >= crop.getLightLevel() && ((air = PollutionManager.pollutionManager.getChunkLevelAir(chunkPos)) == null || air.getLevelPollution().ordinal() <= crop.getAirRequirements().ordinal()) && (chunkLevel == null || chunkLevel.getLevelPollution().ordinal() <= crop.getSoilRequirements().ordinal()) && ((day = world.m_46461_()) && crop.isSun() || !day && crop.isNight())) {
            boolean rain = world.m_46471_();
            boolean thundering = world.m_46470_();
            if (rain && crop.getWeatherResistance() >= 1 || thundering && crop.getWeatherResistance() >= 2 || !rain && !thundering) {
                return crop.canGrowInBiome(biome, world);
            }
        }
        return false;
    }

    public boolean isWaterNearby(Level world, BlockPos pos, ICrop crop) {
        if (crop.getWaterRequirement() == 0) {
            return true;
        }
        int radius = crop.getWaterRequirement() + 1;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos checkPos = pos.m_7918_(x, -1, z);
                BlockState state = world.m_8055_(checkPos);
                if (state.m_60734_() != Blocks.f_49990_) continue;
                return true;
            }
        }
        return false;
    }
}

