/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.bee;

import com.denfop.api.agriculture.ICrop;
import java.util.Objects;

public class Product {
    private double chance;
    private final ICrop crop;

    public Product(double chance, ICrop crop) {
        this.chance = chance;
        this.crop = crop;
    }

    public boolean equals(ICrop crop) {
        return crop.getId() == crop.getId();
    }

    public double getChance() {
        return this.chance;
    }

    public void addChance(double chance) {
        this.chance += chance;
    }

    public ICrop getCrop() {
        return this.crop;
    }

    public void removeChance(double chance) {
        this.chance -= chance;
        if (this.chance < 0.0) {
            this.chance = 0.0;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Product product = (Product)o;
        return this.crop.getId() == product.crop.getId();
    }

    public int hashCode() {
        return Objects.hash(this.crop.getId());
    }
}

