/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.DataBlock;
import com.denfop.api.Recipes;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.datagen.blocktags.IBlockTag;
import com.denfop.world.WorldBaseGen;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class BlockSpace3<T extends Enum<T>>
extends BlockCore<T>
implements IBlockTag {
    public BlockSpace3(T[] elements, T element, DataBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_155954_(1.0f).m_155956_(5.0f).m_60918_(SoundType.f_56742_).m_60999_(), elements, element, dataBlock);
        BlockTagsProvider.list.add(this);
    }

    @Override
    int getMetaFromState(BlockState state) {
        return ((ISubEnum)this.getElement()).getId();
    }

    @Override
    public List<ItemStack> getDrops(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, int fortune) {
        RandomSource rand = world.f_46441_;
        NonNullList ret = NonNullList.m_122779_();
        Type type = (Type)this.getElement();
        if (type.ordinal() != 12) {
            ItemStack stack = type.getStack();
            if (stack == null) {
                stack = Recipes.inputFactory.getInput(type.getRaw()).getInputs().get(0);
                type.setStack(stack);
            }
            stack = stack.m_41777_();
            stack.m_41764_(1 + this.getDrop(fortune));
            ret.add((Object)stack);
        } else {
            int i = WorldBaseGen.random.nextInt(fortune + 2) + 1;
            ret.add((Object)new ItemStack((ItemLike)Items.f_42415_, i));
        }
        return ret;
    }

    public int quantityDropped(int fortune, RandomSource random) {
        return this.quantityDroppedWithBonus(fortune, random);
    }

    public int quantityDroppedWithBonus(int fortune, @Nonnull RandomSource random) {
        return fortune == 0 ? 1 : 1 + random.m_188503_(fortune);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49915_) {
    }

    public int quantityRedstoneDroppedWithBonus(int fortune, Random random) {
        return this.quantityRedstoneDropped(random) + random.nextInt(fortune + 1);
    }

    public int quantityRedstoneDropped(Random random) {
        return 4 + random.nextInt(2);
    }

    private int getDrop(int fortune) {
        switch (fortune) {
            case 0: {
                return 0;
            }
            case 1: {
                return WorldBaseGen.random.nextInt(100) < 50 ? 1 : 0;
            }
            case 2: {
                return WorldBaseGen.random.nextInt(100) < 100 ? 1 : 1;
            }
        }
        return WorldBaseGen.random.nextInt(100) < 50 ? 2 : 1;
    }

    @Override
    public <T extends Enum<T>> BlockState getStateForPlacement(T element, BlockPlaceContext context) {
        return (BlockState)this.f_49792_.m_61090_();
    }

    @Override
    public <T extends Enum<T>> void fillItemCategory(CreativeModeTab p40569, NonNullList<ItemStack> p40570, T element) {
        p40570.add((Object)new ItemStack((ItemLike)((BlockState)this.f_49792_.m_61090_()).m_60734_()));
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Pair<String, Integer> getHarvestLevel() {
        return new Pair((Object)"pickaxe", (Object)1);
    }

    public static enum Type implements ISubEnum
    {
        rhea_chromium(0),
        rhea_osmium_ore(1),
        rhea_vanadium_ore(2),
        tethys_gallium(3),
        tethys_molybdenum_ore(4),
        titan_nickel_ore(5),
        titan_titanium_ore(6),
        titania_polonium_ore(7),
        titania_yttrium(8),
        triton_neodymium(9),
        triton_strontium(10),
        umbriel_spinel_ore(11),
        venus_diamond_ore(12);

        private final int metadata;
        private final String name;
        ItemStack stack;
        private String raw;

        private Type(int metadata) {
            this.metadata = metadata;
            this.name = this.name().toLowerCase(Locale.US);
            this.setRaw(this.getName().split("_")[1]);
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Override
        public int getId() {
            return this.metadata;
        }

        @Override
        public String getOtherPart() {
            return "type=";
        }

        public String getRaw() {
            return this.raw;
        }

        public void setRaw(String name) {
            this.raw = "forge:raw_materials/" + name;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "blockspace4";
        }

        public int getLight() {
            return 0;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
        }
    }
}

