/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.IUItem;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.IMultiUpdateTick;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotSteamMultiRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.blocks.FluidName;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.PressureComponent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.EnumMultiMachine;
import com.denfop.tiles.base.ISteamMechanism;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.EnumTypeMachines;
import com.denfop.utils.Timer;
import java.io.IOException;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class SteamProcessMultiComponent
extends AbstractComponent
implements IMultiUpdateTick {
    public final InvSlotSteamMultiRecipes inputSlots;
    public final InvSlotOutput outputSlot;
    private final ComponentSteamEnergy steam;
    private final PressureComponent pressure;
    private final ISteamMechanism multimachine;
    private final EnumMultiMachine enumMultiMachine;
    private final int sizeWorkingSlot;
    private final short[] progress;
    private final double[] guiProgress;
    private final double defaultEnergyConsume;
    private final int defaultOperationLength;
    private final int operationChange;
    private final MachineRecipe[] output;
    public double energyConsume;
    public int operationLength;
    private int mode;
    private int[] col;
    private Timer timer1 = new Timer(0, 0, 0);
    private Timer timer = null;

    public SteamProcessMultiComponent(ISteamMechanism parent, EnumMultiMachine enumMultiMachine) {
        super((TileEntityBlock)((Object)parent));
        this.multimachine = parent;
        this.inputSlots = new InvSlotSteamMultiRecipes((TileEntityInventory)((Object)parent), enumMultiMachine.type.recipe, (IMultiUpdateTick)this, enumMultiMachine.sizeWorkingSlot, this);
        this.outputSlot = new InvSlotOutput((IAdvInventory)((Object)parent), enumMultiMachine.sizeWorkingSlot + (enumMultiMachine.output ? 2 : 0));
        this.enumMultiMachine = enumMultiMachine;
        this.sizeWorkingSlot = enumMultiMachine.sizeWorkingSlot;
        this.progress = new short[this.sizeWorkingSlot];
        this.guiProgress = new double[this.sizeWorkingSlot];
        double coefenergy = 1.0;
        double speed = 1.0;
        this.mode = 0;
        this.defaultEnergyConsume = this.energyConsume = (double)Math.max((int)((double)enumMultiMachine.usagePerTick * coefenergy), 1);
        this.operationChange = this.operationLength = Math.max((int)((double)enumMultiMachine.lenghtOperation * 1.0 / speed), 1);
        this.defaultOperationLength = this.operationLength;
        this.output = new MachineRecipe[this.sizeWorkingSlot];
        this.steam = ((TileEntityBlock)((Object)parent)).getComp(ComponentSteamEnergy.class);
        this.pressure = ((TileEntityBlock)((Object)parent)).getComp(PressureComponent.class);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.parent.m_58904_().m_5776_()) {
            this.inputSlots.load();
            this.getsOutputs();
        }
    }

    @Override
    public boolean onBlockActivated(Player player, InteractionHand hand) {
        IFluidHandlerItem handler;
        FluidStack fluid;
        ItemStack stack = player.m_21120_(hand);
        if (!(!stack.m_41720_().equals((Object)IUItem.canister.getItem()) || (fluid = (handler = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse((Object)((IFluidHandlerItem)stack.m_41720_().initCapabilities(stack, stack.m_41783_())))).getFluidInTank(0)) == FluidStack.EMPTY || fluid.getFluid() != FluidName.fluidsteam_oil.getInstance().get() || fluid.getAmount() < 250 || this.timer1.canWork() && this.timer1.getBar() != 0 || this.timer != null && this.timer.canWork())) {
            this.timer = new Timer(0, 0, 40);
            handler.drain(250, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return super.onBlockActivated(player, hand);
    }

    public void setOverclockRates() {
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeInt(this.operationLength);
        for (int i = 0; i < this.sizeWorkingSlot; ++i) {
            buffer.writeInt(this.progress[i]);
        }
        buffer.writeDouble(this.energyConsume);
        buffer.writeInt(this.mode);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeInt(this.operationLength);
        for (int i = 0; i < this.sizeWorkingSlot; ++i) {
            buffer.writeInt(this.progress[i]);
        }
        buffer.writeDouble(this.energyConsume);
        buffer.writeInt(this.mode);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        super.onNetworkUpdate(is);
        this.operationLength = is.readInt();
        for (int i = 0; i < this.sizeWorkingSlot; ++i) {
            this.progress[i] = (short)is.readInt();
        }
        this.energyConsume = is.readDouble();
        this.mode = is.readInt();
    }

    @Override
    public void updateEntityServer() {
        boolean active = false;
        int type = -1;
        for (int i = 0; i < this.getSizeWorkingSlot(); ++i) {
            MachineRecipe output = this.output[i];
            boolean size = true;
            if (output != null && this.inputSlots.continue_proccess(this.outputSlot, i) && this.steam.canUseEnergy(this.energyConsume) && this.pressure.getEnergy() == 1.0) {
                active = true;
                if (this.progress[i] == 0 && (double)this.operationLength > (double)this.defaultOperationLength * 0.1 && type == -1) {
                    this.multimachine.initiate(0);
                    type = 0;
                }
                this.steam.useEnergy(this.energyConsume);
                int n = i;
                this.progress[n] = (short)(this.progress[n] + 1);
                this.guiProgress[i] = (double)this.progress[i] / (double)this.operationLength;
                if (this.timer != null && this.timer.canWork()) {
                    int n2 = i;
                    this.progress[n2] = (short)(this.progress[n2] + 1);
                }
                if (this.progress[i] < this.operationLength) continue;
                this.guiProgress[i] = 0.0;
                this.progress[i] = 0;
                this.operate(i, output);
                if (!((double)this.operationLength > (double)this.defaultOperationLength * 0.1) && this.multimachine.getTypeAudio() == EnumTypeAudio.VALUES[2 % EnumTypeAudio.VALUES.length] || type != -1) continue;
                this.multimachine.initiate(2);
                type = 2;
                continue;
            }
            if (this.progress[i] != 0 && this.parent.getActive() && ((double)this.operationLength > (double)this.defaultOperationLength * 0.1 || this.multimachine.getTypeAudio() != EnumTypeAudio.VALUES[1 % EnumTypeAudio.VALUES.length]) && type == -1) {
                this.multimachine.initiate(1);
                type = 1;
            }
            if (output != null) continue;
            this.progress[i] = 0;
        }
        if (this.parent.getActive() != active) {
            this.parent.setActive(active);
        }
        if (this.parent.getActive() && this.parent.getWorld().m_46467_() % 20L == 0L) {
            if (this.timer != null && this.timer.canWork()) {
                this.timer.work();
                if (!this.timer.canWork()) {
                    this.timer1 = new Timer(0, 0, 10);
                }
            }
            if (this.timer1.canWork()) {
                this.timer1.work();
            }
        }
    }

    @Override
    public MachineRecipe getRecipeOutput(int slotId) {
        return this.output[slotId];
    }

    @Override
    public void setRecipeOutput(MachineRecipe output, int slotId) {
        this.output[slotId] = output;
    }

    public int getSizeWorkingSlot() {
        return this.sizeWorkingSlot;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output[0];
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output[0] = output;
    }

    private void getsOutputs() {
        for (int i = 0; i < this.sizeWorkingSlot; ++i) {
            this.output[i] = this.getOutput(i);
        }
    }

    public void operate(int slotId, MachineRecipe output) {
        for (int i = 0; i < 1; ++i) {
            this.operateOnce(slotId, output.getRecipe().output.items);
            if (this.enumMultiMachine.recipe.equals("recycler")) continue;
            if (this.inputSlots.get(slotId).m_41619_() || this.inputSlots.get(slotId).m_41613_() < this.output[slotId].getRecipe().input.getInputs().get(0).getAmount() || !this.outputSlot.canAdd(output.getRecipe().output.items)) {
                this.getOutput(slotId);
                break;
            }
            if (!this.inputSlots.get(slotId).m_41619_() && this.inputSlots.get(slotId).m_41613_() >= 1 && this.outputSlot.canAdd(output.getRecipe().output.items)) continue;
            this.getOutput(slotId);
            break;
        }
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public void operateOnce(int slotId, List<ItemStack> processResult) {
        for (ItemStack stack : processResult) {
            this.outputSlot.add(stack);
        }
        this.inputSlots.consume(slotId);
    }

    public MachineRecipe getOutput(int slotId) {
        if (this.enumMultiMachine == null || this.enumMultiMachine.type != EnumTypeMachines.COMBRECYCLER && this.enumMultiMachine.type != EnumTypeMachines.RECYCLER) {
            if (this.inputSlots.get(slotId).m_41619_()) {
                this.output[slotId] = null;
                return null;
            }
            this.output[slotId] = this.inputSlots.process(slotId);
            return this.output[slotId];
        }
        if (this.inputSlots.get(slotId).m_41619_()) {
            this.output[slotId] = null;
            return null;
        }
        this.output[slotId] = this.inputSlots.recycler_output;
        return this.output[slotId];
    }

    public double getProgress(int slotId) {
        return (double)this.progress[slotId] * 1.0 / (double)this.operationLength;
    }
}

