/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets.client;

import com.denfop.Localization;
import com.denfop.componets.AbstractComponent;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityBlock;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;

public class ComponentVisibleArea
extends AbstractComponent {
    public AABB aabb;
    private boolean visible;

    public ComponentVisibleArea(TileEntityBlock parent) {
        super(parent);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("component.visible_area.info"));
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag tag = super.writeToNbt();
        tag.m_128379_("visible", this.visible);
        return tag;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        this.visible = nbt.m_128471_("visible");
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        super.onNetworkUpdate(is);
        this.visible = is.readBoolean();
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeBoolean(this.visible);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer packetBuffer = super.updateComponent();
        packetBuffer.writeBoolean(this.visible);
        return packetBuffer;
    }

    @Override
    public boolean onSneakingActivated(Player player, InteractionHand hand) {
        this.visible = !this.visible;
        return super.onSneakingActivated(player, hand);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.parent.getWorld().f_46443_) {
            GlobalRenderManager.addRender(this.parent.getWorld(), this.parent.getPos(), this.createFunction(this));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private Function<RenderLevelStageEvent, Void> createFunction(ComponentVisibleArea componentVisibleArea) {
        Function<RenderLevelStageEvent, Void> function = event -> {
            PoseStack poseStack = event.getPoseStack();
            if (!this.visible) {
                return null;
            }
            poseStack.m_85836_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            VertexConsumer buffer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(com.denfop.render.base.RenderType.QUAD_TRANSPARENT_OVER_WATER);
            float p_109630_ = 1.0f;
            float p_109635_ = 1.0f;
            float p_109636_ = 1.0f;
            float p_109633_ = 1.0f;
            float p_109634_ = 1.0f;
            float p_109631_ = 1.0f;
            float p_109632_ = 1.0f;
            Matrix4f matrix = poseStack.m_85850_().m_85861_();
            Matrix3f matrix3f = poseStack.m_85850_().m_85864_();
            int f = (int)this.aabb.f_82288_;
            int f1 = (int)this.aabb.f_82289_;
            int f2 = (int)this.aabb.f_82290_;
            int f3 = (int)this.aabb.f_82291_;
            int f4 = (int)this.aabb.f_82292_;
            int f5 = (int)this.aabb.f_82293_;
            float x1 = (float)this.aabb.f_82288_;
            float y1 = (float)this.aabb.f_82289_;
            float z1 = (float)this.aabb.f_82290_;
            float x2 = (float)this.aabb.f_82291_;
            float y2 = (float)this.aabb.f_82292_;
            float z2 = (float)this.aabb.f_82293_;
            float red = 0.0f;
            float green = 0.4862745f;
            float blue = 0.6666667f;
            float alpha = 0.5f;
            buffer.m_85982_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x1, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x1, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x1, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x2, y1, z1).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x2, y2, z1).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_85982_(matrix, x2, y1, z2).m_85950_(red, green, blue, alpha).m_5752_();
            poseStack.m_85849_();
            poseStack.m_85836_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            VertexConsumer p_109623_ = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
            red = 0.0f;
            green = 0.4862745f;
            blue = 1.0f;
            alpha = 1.0f;
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            poseStack.m_85849_();
            poseStack.m_85836_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            p_109623_ = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
            red = 0.0f;
            green = 0.4862745f;
            blue = 1.0f;
            alpha = 1.0f;
            matrix4f = poseStack.m_85850_().m_85861_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            p_109623_.m_85982_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            poseStack.m_85849_();
            return null;
        };
        return function;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.parent.getWorld().f_46443_) {
            GlobalRenderManager.removeRender(this.parent.getWorld(), this.parent.getPos());
        }
    }
}

