/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.cool;

import com.denfop.api.cool.ICoolNet;
import com.denfop.api.cool.ICoolTile;
import com.denfop.cool.CoolNetLocal;
import com.denfop.cool.EventHandler;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class CoolNetGlobal
implements ICoolNet {
    private static Map<ResourceKey<Level>, CoolNetLocal> worldToEnergyNetMap = new WeakHashMap<ResourceKey<Level>, CoolNetLocal>();

    public static CoolNetGlobal initialize() {
        new EventHandler();
        return new CoolNetGlobal();
    }

    public static void onWorldUnload(Level world) {
        CoolNetLocal local = worldToEnergyNetMap.remove(world.m_46472_());
        if (local != null) {
            local.onUnload();
        }
    }

    public static CoolNetLocal getForWorld(Level world) {
        if (world == null) {
            return null;
        }
        if (!worldToEnergyNetMap.containsKey(world.m_46472_())) {
            worldToEnergyNetMap.put((ResourceKey<Level>)world.m_46472_(), new CoolNetLocal());
        }
        return worldToEnergyNetMap.get(world.m_46472_());
    }

    public static void onTickEnd(Level world) {
        CoolNetLocal energyNet = CoolNetGlobal.getForWorld(world);
        if (energyNet != null) {
            energyNet.onTickEnd();
        }
    }

    @Override
    public ICoolTile getSubTile(Level var1, BlockPos var2) {
        CoolNetLocal local = CoolNetGlobal.getForWorld(var1);
        if (local != null) {
            return local.getTileEntity(var2);
        }
        return null;
    }
}

