/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.CustomButton;
import com.denfop.container.ContainerFacadeBlock;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ListInformationUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class GuiFacadeBlock<T extends ContainerFacadeBlock>
extends GuiIU<ContainerFacadeBlock> {
    public GuiFacadeBlock(ContainerFacadeBlock container) {
        super(container);
        this.addElement(new CustomButton(this, 5, 40, 60, 15, (TileEntityBlock)((Object)container.base), 0, Localization.translate("button.write")));
        this.addElement(new CustomButton(this, 90, 40, 60, 15, (TileEntityBlock)((Object)container.base), 1, Localization.translate("facademechanism_button")));
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(poseStack, mouseX, mouseY);
        this.handleUpgradeTooltip(mouseX, mouseY);
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            List<String> compatibleUpgrades = ListInformationUtils.facade;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        int h = this.guiLeft;
        int k = this.guiTop;
        GuiFacadeBlock.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, h + 3, k + 3, 0, 0, 10, 10);
        GuiFacadeBlock.bindTexture(this.getTexture());
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guimachine.png");
    }
}

